/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.sosy_lab.common.Classes;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.ToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class ExpressionTreeLocationInvariant
extends SingleLocationFormulaInvariant
implements ExpressionTreeCandidateInvariant {
    private final ExpressionTree<AExpression> expressionTree;
    private final CFANode location;
    private final String groupId;
    private final ConcurrentMap<ManagerKey, ToFormulaVisitor> visitorCache;

    public ExpressionTreeLocationInvariant(String pGroupId, CFANode pLocation, ExpressionTree<AExpression> pExpressionTree, ConcurrentMap<ManagerKey, ToFormulaVisitor> pVisitorCache) {
        super(pLocation);
        this.groupId = Objects.requireNonNull(pGroupId);
        this.location = Objects.requireNonNull(pLocation);
        this.expressionTree = Objects.requireNonNull(pExpressionTree);
        this.visitorCache = (ConcurrentMap)Preconditions.checkNotNull(pVisitorCache);
    }

    @Override
    public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, PathFormula pContext) throws CPATransferException, InterruptedException {
        PathFormula clearContext = pContext == null ? null : pPFMGR.makeEmptyPathFormulaWithContextFrom(pContext);
        ManagerKey key = new ManagerKey(pFMGR, pPFMGR, clearContext);
        ToFormulaVisitor toFormulaVisitor = this.visitorCache.computeIfAbsent(key, k -> new ToFormulaVisitor(k.formulaManagerView, k.pathFormulaManager, k.clearContext));
        try {
            return this.expressionTree.accept(toFormulaVisitor);
        }
        catch (ToFormulaVisitor.ToFormulaException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPATransferException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("expression tree to formula", (Throwable)e);
        }
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        if (this.expressionTree.equals(ExpressionTrees.getFalse())) {
            ImmutableList infeasibleStates = ImmutableList.copyOf(AbstractStates.filterLocation(pReachedSet, this.getLocation()));
            pReachedSet.removeAll((Iterable<? extends AbstractState>)infeasibleStates);
            for (ARGState s : FluentIterable.from((Iterable)infeasibleStates).filter(ARGState.class)) {
                s.removeFromARG();
            }
        }
    }

    @Override
    public ExpressionTree<Object> asExpressionTree() {
        return ExpressionTrees.cast(this.expressionTree);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.location, this.expressionTree, System.identityHashCode(this.visitorCache));
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof ExpressionTreeLocationInvariant) {
            ExpressionTreeLocationInvariant other = (ExpressionTreeLocationInvariant)pObj;
            return this.groupId.equals(other.groupId) && this.location.equals(other.location) && this.expressionTree.equals(other.expressionTree) && this.visitorCache == other.visitorCache;
        }
        return false;
    }

    public String toString() {
        return this.groupId + " at " + this.location + ": " + this.expressionTree;
    }

    public static class ManagerKey {
        private final FormulaManagerView formulaManagerView;
        private final PathFormulaManager pathFormulaManager;
        private final PathFormula clearContext;

        public ManagerKey(FormulaManagerView pFormulaManagerView, PathFormulaManager pPathFormulaManager, PathFormula pClearContext) {
            this.formulaManagerView = Objects.requireNonNull(pFormulaManagerView);
            this.pathFormulaManager = Objects.requireNonNull(pPathFormulaManager);
            this.clearContext = pClearContext;
        }

        public int hashCode() {
            return Objects.hash(this.formulaManagerView, this.pathFormulaManager);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof ManagerKey) {
                ManagerKey other = (ManagerKey)pObj;
                return this.formulaManagerView == other.formulaManagerView && this.pathFormulaManager == other.pathFormulaManager && Objects.equals(this.clearContext, other.clearContext);
            }
            return false;
        }
    }
}

