/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public abstract class SingleLocationFormulaInvariant
implements CandidateInvariant {
    private final CFANode location;

    protected SingleLocationFormulaInvariant(CFANode pLocation) {
        Preconditions.checkNotNull((Object)pLocation);
        this.location = pLocation;
    }

    public final CFANode getLocation() {
        return this.location;
    }

    @Override
    public boolean appliesTo(CFANode pLocation) {
        return this.location.equals(pLocation);
    }

    @Override
    public final BooleanFormula getAssertion(Iterable<AbstractState> pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        Iterable<AbstractState> locationStates = this.filterApplicable(pReachedSet);
        return BMCHelper.assertAt(locationStates, this, pFMGR, pPFMGR);
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
    }

    @Override
    public Iterable<AbstractState> filterApplicable(Iterable<AbstractState> pStates) {
        return AbstractStates.filterLocation(pStates, this.location);
    }

    public static SingleLocationFormulaInvariant makeBooleanInvariant(final CFANode pLocation, final boolean pValue) {
        class SingleLocationBooleanInvariant
        extends SingleLocationFormulaInvariant {
            private final boolean value;

            private SingleLocationBooleanInvariant() {
                super(cFANode);
                this.value = pValue;
            }

            @Override
            public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, PathFormula pContext) {
                return pFMGR.getBooleanFormulaManager().makeBoolean(this.value);
            }

            public boolean equals(Object pOther) {
                if (this == pOther) {
                    return true;
                }
                if (pOther instanceof SingleLocationBooleanInvariant) {
                    SingleLocationBooleanInvariant other = (SingleLocationBooleanInvariant)pOther;
                    return this.getLocation().equals(other.getLocation()) && this.value == other.value;
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(pLocation, this.value);
            }

            public String toString() {
                return this.value + " at " + this.getLocation();
            }
        }
        return new SingleLocationBooleanInvariant();
    }

    public static SingleLocationFormulaInvariant makeLocationInvariant(final CFANode pLocation, BooleanFormula pInvariant, final FormulaManagerView pOriginalFormulaManager) {
        BooleanFormulaManagerView bfmgr = pOriginalFormulaManager.getBooleanFormulaManager();
        if (bfmgr.isTrue(pInvariant)) {
            return SingleLocationFormulaInvariant.makeBooleanInvariant(pLocation, true);
        }
        if (bfmgr.isFalse(pInvariant)) {
            return SingleLocationFormulaInvariant.makeBooleanInvariant(pLocation, false);
        }
        class SpecificSMTLibLocationFormulaInvariant
        extends SingleLocationFormulaInvariant {
            private final BooleanFormula invariant;
            private final SMTLibLocationFormulaInvariant delegate;

            public SpecificSMTLibLocationFormulaInvariant(BooleanFormula pInv) {
                super(cFANode);
                this.invariant = pInv;
                this.delegate = new SMTLibLocationFormulaInvariant(pLocation, pOriginalFormulaManager.dumpFormula(pInv).toString());
            }

            @Override
            public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, @Nullable PathFormula pContext) throws CPATransferException, InterruptedException {
                return this.delegate.getFormula(pFMGR, pPFMGR, pContext);
            }

            @Override
            public void assumeTruth(ReachedSet pReachedSet) {
                this.delegate.assumeTruth(pReachedSet);
            }

            public String toString() {
                return this.invariant + " at " + this.getLocation();
            }

            public boolean equals(Object pOther) {
                if (this == pOther) {
                    return true;
                }
                if (pOther instanceof SpecificSMTLibLocationFormulaInvariant) {
                    SpecificSMTLibLocationFormulaInvariant other = (SpecificSMTLibLocationFormulaInvariant)pOther;
                    return this.delegate.equals(other.delegate);
                }
                return false;
            }

            public int hashCode() {
                return this.delegate.hashCode();
            }
        }
        return new SpecificSMTLibLocationFormulaInvariant(pInvariant);
    }

    public static CandidateInvariant makeLocationInvariant(CFANode pLocation, String pInvariant) {
        return new SMTLibLocationFormulaInvariant(pLocation, pInvariant);
    }

    private static final class SMTLibLocationFormulaInvariant
    extends SingleLocationFormulaInvariant {
        private boolean isDefinitelyBooleanFalse = false;
        private final LoadingCache<FormulaManagerView, BooleanFormula> cachedFormulas;
        private final String invariant;

        private SMTLibLocationFormulaInvariant(CFANode pLocation, String pInvariant) {
            super(pLocation);
            this.invariant = pInvariant;
            this.cachedFormulas = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(fmgr -> fmgr.parse(this.invariant)));
        }

        @Override
        public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, PathFormula pContext) throws CPATransferException, InterruptedException {
            BooleanFormula formula;
            if (this.isDefinitelyBooleanFalse) {
                return pFMGR.getBooleanFormulaManager().makeFalse();
            }
            try {
                formula = (BooleanFormula)this.cachedFormulas.get((Object)pFMGR);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    Throwables.propagateIfPossible((Throwable)cause, CPATransferException.class, InterruptedException.class);
                    throw new UncheckedExecutionException(cause);
                }
                throw new UncheckedExecutionException((Throwable)e);
            }
            if (!this.isDefinitelyBooleanFalse && pFMGR.getBooleanFormulaManager().isFalse(formula)) {
                this.isDefinitelyBooleanFalse = true;
            }
            return formula;
        }

        public String toString() {
            return this.invariant;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof SMTLibLocationFormulaInvariant) {
                SMTLibLocationFormulaInvariant other = (SMTLibLocationFormulaInvariant)pOther;
                return this.getLocation().equals(other.getLocation()) && this.invariant.equals(other.invariant);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getLocation(), this.invariant.hashCode());
        }

        @Override
        public void assumeTruth(ReachedSet pReachedSet) {
            if (this.isDefinitelyBooleanFalse) {
                ImmutableList targetStates = ImmutableList.copyOf(this.filterApplicable(pReachedSet));
                pReachedSet.removeAll((Iterable<? extends AbstractState>)targetStates);
                for (ARGState s : FluentIterable.from((Iterable)targetStates).filter(ARGState.class)) {
                    s.removeFromARG();
                }
            }
        }
    }
}

