/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CounterexampleToInductivity;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ModelValue;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;

public class SymbolicCandiateInvariant
implements CandidateInvariant {
    private final LoadingCache<FormulaManagerView, BooleanFormula> cachedFormulas;
    private final Set<CFANode> applicableLocations;
    private final String invariant;
    private final Predicate<? super AbstractState> stateFilter;
    private final Supplier<String> textualRepresentation;
    private boolean isDefinitelyBooleanFalse = false;

    private SymbolicCandiateInvariant(Iterable<CFANode> pApplicableLocations, Predicate<? super AbstractState> pStateFilter, String pInvariant, Supplier<String> pTextualRepresentation) {
        this.applicableLocations = ImmutableSet.copyOf(pApplicableLocations);
        this.cachedFormulas = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(fmgr -> fmgr.parse(pInvariant)));
        this.invariant = pInvariant;
        this.stateFilter = Objects.requireNonNull(pStateFilter);
        this.textualRepresentation = Objects.requireNonNull(pTextualRepresentation);
    }

    @Override
    public final BooleanFormula getAssertion(Iterable<AbstractState> pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        Iterable<AbstractState> locationStates = this.filterApplicable(pReachedSet);
        return BMCHelper.assertAt(locationStates, this, pFMGR, pPFMGR);
    }

    @Override
    public Iterable<AbstractState> filterApplicable(Iterable<AbstractState> pStates) {
        return AbstractStates.filterLocations(pStates, this.applicableLocations).filter(this.stateFilter::test);
    }

    @Override
    public BooleanFormula getFormula(FormulaManagerView pFmgr, PathFormulaManager pPfmgr, PathFormula pContext) throws InterruptedException {
        return this.getPlainFormula(pFmgr);
    }

    public String toString() {
        return this.textualRepresentation.get();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof SymbolicCandiateInvariant) {
            SymbolicCandiateInvariant other = (SymbolicCandiateInvariant)pOther;
            return this.stateFilter.equals(other.stateFilter) && this.invariant.equals(other.invariant) && this.applicableLocations.equals(other.applicableLocations);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.stateFilter, this.invariant, this.applicableLocations);
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        if (this.isDefinitelyBooleanFalse) {
            ImmutableList targetStates = ImmutableList.copyOf(this.filterApplicable(pReachedSet));
            pReachedSet.removeAll((Iterable<? extends AbstractState>)targetStates);
            for (ARGState s : FluentIterable.from((Iterable)targetStates).filter(ARGState.class)) {
                s.removeFromARG();
            }
        }
    }

    @Override
    public boolean appliesTo(CFANode pLocation) {
        return this.applicableLocations.contains(pLocation);
    }

    public Set<CFANode> getApplicableLocations() {
        return this.applicableLocations;
    }

    public Predicate<? super AbstractState> getStateFilter() {
        return this.stateFilter;
    }

    public BooleanFormula getPlainFormula(FormulaManagerView pFmgr) throws InterruptedException {
        BooleanFormula formula;
        if (this.isDefinitelyBooleanFalse) {
            return pFmgr.getBooleanFormulaManager().makeFalse();
        }
        try {
            formula = (BooleanFormula)this.cachedFormulas.get((Object)pFmgr);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.propagateIfPossible((Throwable)cause, InterruptedException.class);
                throw new UncheckedExecutionException(cause);
            }
            throw new UncheckedExecutionException((Throwable)e);
        }
        if (!this.isDefinitelyBooleanFalse && pFmgr.getBooleanFormulaManager().isFalse(formula)) {
            this.isDefinitelyBooleanFalse = true;
        }
        return formula;
    }

    public SymbolicCandiateInvariant negate(FormulaManagerView pFmgr) throws InterruptedException {
        return SymbolicCandiateInvariant.makeSymbolicInvariant(this.applicableLocations, this.stateFilter, pFmgr.getBooleanFormulaManager().not(this.getPlainFormula(pFmgr)), pFmgr);
    }

    public Iterable<SymbolicCandiateInvariant> splitLiterals(FormulaManagerView pFMGR, boolean pSplitNumeralEqualities) throws InterruptedException {
        BooleanFormula formula = this.getPlainFormula(pFMGR);
        Iterable<BooleanFormula> literals = SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, formula, pSplitNumeralEqualities);
        return Iterables.transform(literals, f -> SymbolicCandiateInvariant.makeSymbolicInvariant(this.applicableLocations, this.stateFilter, f, pFMGR));
    }

    public static BlockedCounterexampleToInductivity blockCti(Set<CFANode> pApplicableLocations, CounterexampleToInductivity pCtiToBlock, FormulaManagerView pOriginalFormulaManager) {
        return SymbolicCandiateInvariant.blockCti(pApplicableLocations, (Predicate<? super AbstractState>)Predicates.alwaysTrue(), pCtiToBlock, pOriginalFormulaManager);
    }

    public static BlockedCounterexampleToInductivity blockCti(Set<CFANode> pApplicableLocations, Predicate<? super AbstractState> pStateFilter, CounterexampleToInductivity pCtiToBlock, FormulaManagerView pOriginalFormulaManager) {
        return new BlockedCounterexampleToInductivity(pApplicableLocations, pStateFilter, pCtiToBlock, pOriginalFormulaManager);
    }

    public static SymbolicCandiateInvariant makeSymbolicInvariant(Set<CFANode> pApplicableLocations, Predicate<? super AbstractState> pStateFilter, BooleanFormula pInvariant, FormulaManagerView pOriginalFormulaManager) {
        return new SymbolicCandiateInvariant(pApplicableLocations, pStateFilter, pOriginalFormulaManager.dumpFormula(pInvariant).toString(), pInvariant::toString);
    }

    public static Iterable<BooleanFormula> getConjunctionOperands(FormulaManagerView pFMGR, BooleanFormula pFormula, boolean pSplitNumeralEqualities) {
        Iterable<BooleanFormula> operands = SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, pFormula);
        if (!pSplitNumeralEqualities) {
            return operands;
        }
        return FluentIterable.from(operands).transformAndConcat(pFMGR::splitNumeralEqualityIfPossible);
    }

    private static Iterable<BooleanFormula> getConjunctionOperands(final FormulaManagerView pFMGR, final BooleanFormula pFormula) {
        final BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        return (Iterable)bfmgr.visit(pFormula, (BooleanFormulaVisitor)new DefaultBooleanFormulaVisitor<Iterable<BooleanFormula>>(){

            protected Iterable<BooleanFormula> visitDefault() {
                return pFMGR.splitNumeralEqualityIfPossible(pFormula);
            }

            public Iterable<BooleanFormula> visitAnd(List<BooleanFormula> pArg0) {
                return FluentIterable.from(pArg0).transformAndConcat(operand -> SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, operand));
            }

            public Iterable<BooleanFormula> visitNot(BooleanFormula pArg0) {
                FluentIterable disjunctionOperands = FluentIterable.from(SymbolicCandiateInvariant.getDisjunctionOperands(pFMGR, pArg0));
                if (disjunctionOperands.skip(1).isEmpty()) {
                    return Collections.singleton(bfmgr.not((BooleanFormula)disjunctionOperands.iterator().next()));
                }
                return disjunctionOperands.transformAndConcat(innerOp -> SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, bfmgr.not(innerOp)));
            }
        });
    }

    private static Iterable<BooleanFormula> getDisjunctionOperands(final FormulaManagerView pFMGR, final BooleanFormula pFormula) {
        final BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        return (Iterable)bfmgr.visit(pFormula, (BooleanFormulaVisitor)new DefaultBooleanFormulaVisitor<Iterable<BooleanFormula>>(){

            protected Iterable<BooleanFormula> visitDefault() {
                return Collections.singleton(pFormula);
            }

            public Iterable<BooleanFormula> visitOr(List<BooleanFormula> pArg0) {
                return FluentIterable.from(pArg0).transformAndConcat(operand -> SymbolicCandiateInvariant.getDisjunctionOperands(pFMGR, operand));
            }

            public Iterable<BooleanFormula> visitNot(BooleanFormula pArg0) {
                FluentIterable conjunctionOperands = FluentIterable.from(SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, pArg0));
                if (conjunctionOperands.skip(1).isEmpty()) {
                    return Collections.singleton(bfmgr.not((BooleanFormula)conjunctionOperands.iterator().next()));
                }
                return conjunctionOperands.transformAndConcat(innerOp -> SymbolicCandiateInvariant.getDisjunctionOperands(pFMGR, bfmgr.not(innerOp)));
            }
        });
    }

    public static Multimap<Set<AbstractState>, SymbolicCandiateInvariant> indexByApplicableStates(Iterable<SymbolicCandiateInvariant> pCandidateInvariants, Iterable<AbstractState> pStates) {
        if (Iterables.isEmpty(pCandidateInvariants)) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        Iterator<SymbolicCandiateInvariant> candidateIterator = pCandidateInvariants.iterator();
        SymbolicCandiateInvariant first = candidateIterator.next();
        HashSet firstApplicableStates = Sets.newHashSet(first.filterApplicable(pStates));
        builder.put((Object)firstApplicableStates, (Object)first);
        while (candidateIterator.hasNext()) {
            SymbolicCandiateInvariant current = candidateIterator.next();
            if (current.stateFilter.equals(first.stateFilter) && current.applicableLocations.equals(first.applicableLocations)) {
                builder.put((Object)firstApplicableStates, (Object)current);
                continue;
            }
            builder.put((Object)Sets.newHashSet(current.filterApplicable(pStates)), (Object)current);
        }
        return builder.build();
    }

    public static class BlockedCounterexampleToInductivity
    extends SymbolicCandiateInvariant {
        private final CounterexampleToInductivity blockedCti;

        private BlockedCounterexampleToInductivity(Set<CFANode> pApplicableLocations, Predicate<? super AbstractState> pStateFilter, CounterexampleToInductivity pCtiToBlock, FormulaManagerView pFmgr) {
            super(pApplicableLocations, pStateFilter, pFmgr.dumpFormula(pFmgr.getBooleanFormulaManager().not(pCtiToBlock.getFormula(pFmgr))).toString(), () -> "");
            this.blockedCti = Objects.requireNonNull(pCtiToBlock);
        }

        @Override
        public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, @Nullable PathFormula pContext) {
            BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
            BooleanFormula model = bfmgr.makeFalse();
            for (Map.Entry<String, ModelValue> valueAssignment : this.blockedCti.getAssignments().entrySet()) {
                String variableName = valueAssignment.getKey();
                ModelValue v = valueAssignment.getValue();
                assert (variableName.equals(v.getVariableName()));
                model = bfmgr.or(model, bfmgr.not(v.toAssignment(pFMGR)));
            }
            return model;
        }

        public CounterexampleToInductivity getCti() {
            return this.blockedCti;
        }

        @Override
        public String toString() {
            return String.format("!%s", this.blockedCti.getAssignments().values());
        }

        @Override
        public boolean equals(Object pOther) {
            return super.equals(pOther);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

