/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public enum TargetLocationCandidateInvariant implements CandidateInvariant
{
    INSTANCE;


    @Override
    public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, PathFormula pContext) {
        return pFMGR.getBooleanFormulaManager().makeFalse();
    }

    @Override
    public BooleanFormula getAssertion(Iterable<AbstractState> pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws InterruptedException {
        FluentIterable<AbstractState> targetStates = this.filterApplicable(pReachedSet);
        return pFMGR.getBooleanFormulaManager().not(BMCHelper.createFormulaFor(targetStates, pFMGR.getBooleanFormulaManager()));
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        ImmutableList targetStates = this.filterApplicable((Iterable<AbstractState>)pReachedSet).toList();
        pReachedSet.removeAll((Iterable<? extends AbstractState>)targetStates);
        for (ARGState s : FluentIterable.from((Iterable)targetStates).filter(ARGState.class)) {
            s.removeFromARG();
        }
    }

    public String toString() {
        return "No target locations reachable";
    }

    @Override
    public boolean appliesTo(CFANode pLocation) {
        return true;
    }

    public FluentIterable<AbstractState> filterApplicable(Iterable<AbstractState> pStates) {
        return FluentIterable.from(pStates).filter(AbstractStates::isTargetState);
    }
}

