/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.pdr;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariantCombination;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.SolverContext;

class FrameSet
implements AutoCloseable {
    private final Solver solver;
    private final Set<SolverContext.ProverOptions> proverOptions;
    private final List<Set<CandidateInvariant>> frames = new ArrayList<Set<CandidateInvariant>>();
    private final List<ProverEnvironmentWithFallback> frameProvers = new ArrayList<ProverEnvironmentWithFallback>();
    private final Set<Integer> emptyFrames = new HashSet<Integer>(2);
    private final Map<CandidateInvariant, Integer> rootCandidateInvariantFrontierIndices = new HashMap<CandidateInvariant, Integer>();

    public FrameSet(Solver pSolver, Set<SolverContext.ProverOptions> pProverOptions) {
        this.solver = pSolver;
        this.proverOptions = pProverOptions.isEmpty() ? ImmutableSet.of() : Sets.immutableEnumSet(pProverOptions);
        this.newFrame();
    }

    private void newFrame() {
        this.frames.add(new LinkedHashSet());
        ProverEnvironmentWithFallback prover = new ProverEnvironmentWithFallback(this.solver, this.proverOptions.toArray(new SolverContext.ProverOptions[0]));
        this.frameProvers.add(prover);
    }

    @Override
    public void close() {
        for (ProverEnvironmentWithFallback prover : this.frameProvers) {
            prover.close();
        }
    }

    public String toString() {
        return IntStream.rangeClosed(0, this.getFrontierIndex()).mapToObj(i -> {
            Iterable result = this.frames.get(i);
            if (i == 0) {
                result = Iterables.concat((Iterable)ImmutableSet.of((Object)"I"), (Iterable)result);
            }
            return result;
        }).map(Object::toString).collect(Collectors.joining(", "));
    }

    public int getFrontierIndex() {
        return this.frames.size() - 1;
    }

    public Set<CandidateInvariant> getFrameClauses(int pFrameIndex) {
        return Collections.unmodifiableSet(this.frames.get(pFrameIndex));
    }

    public Iterable<CandidateInvariant> getPushableFrameClauses(int pFrameIndex) {
        return Iterables.filter(this.getFrameClauses(pFrameIndex), c -> !this.rootCandidateInvariantFrontierIndices.containsKey(c));
    }

    public ProverEnvironmentWithFallback getFrameProver(int pFrameIndex) {
        return this.frameProvers.get(pFrameIndex);
    }

    public ImmutableSet<CandidateInvariant> getInvariants(int pFrameIndex) {
        if (pFrameIndex < 0) {
            throw new IndexOutOfBoundsException("Illegal frame index: " + pFrameIndex);
        }
        if (pFrameIndex > this.getFrontierIndex()) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)IntStream.rangeClosed(pFrameIndex, this.getFrontierIndex()).mapToObj(this.frames::get).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
    }

    public void addFrameClause(int pFrameIndex, CandidateInvariant pClause) {
        Preconditions.checkArgument((pFrameIndex <= this.getFrontierIndex() ? 1 : 0) != 0, (Object)"To push the frontier, use pushFrontier");
        Set<CandidateInvariant> frame = this.frames.get(pFrameIndex);
        boolean added = false;
        for (CandidateInvariant clauseComponent : CandidateInvariantCombination.getConjunctiveParts(pClause)) {
            if (this.rootCandidateInvariantFrontierIndices.containsKey(clauseComponent) || !frame.add(clauseComponent)) continue;
            added = true;
        }
        if (added) {
            this.emptyFrames.remove(pFrameIndex);
        }
    }

    public void pushFrameClause(int pFrameIndex, CandidateInvariant pClause) {
        Set<CandidateInvariant> oldFrame = this.frames.get(pFrameIndex);
        if (!oldFrame.remove(pClause)) {
            throw new IllegalArgumentException(pClause + " not found in frame " + pFrameIndex);
        }
        for (CandidateInvariant clauseComponent : CandidateInvariantCombination.getConjunctiveParts(pClause)) {
            oldFrame.remove(clauseComponent);
        }
        if (oldFrame.isEmpty()) {
            this.emptyFrames.add(pFrameIndex);
        }
        this.addFrameClause(pFrameIndex + 1, pClause);
        this.frames.get(pFrameIndex + 1).add(pClause);
    }

    public int getFrontierIndex(CandidateInvariant pRootInvariant) {
        Integer index = this.rootCandidateInvariantFrontierIndices.get(pRootInvariant);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Unknown root invariant: %s", (Object)pRootInvariant);
        return index;
    }

    public void pushFrontier(int pFrontierIndex, CandidateInvariant pRootInvariant) {
        Integer previousIndex = this.rootCandidateInvariantFrontierIndices.get(pRootInvariant);
        if (previousIndex == null && pFrontierIndex != 1) {
            throw new IllegalArgumentException("Root invariants must initially be pushed to frame one instead of frame " + pFrontierIndex);
        }
        if (previousIndex != null && previousIndex < pFrontierIndex - 1) {
            throw new IllegalArgumentException("Incorrect new frontier index " + pFrontierIndex + ": The frontier for the root invariant " + pRootInvariant + " is currently at " + previousIndex);
        }
        if (previousIndex != null && previousIndex >= pFrontierIndex) {
            return;
        }
        assert (previousIndex == null || previousIndex == pFrontierIndex - 1);
        if (previousIndex != null) {
            Set<CandidateInvariant> oldFrame = this.frames.get(previousIndex);
            boolean removed = oldFrame.remove(pRootInvariant);
            assert (removed);
            if (oldFrame.isEmpty()) {
                this.emptyFrames.add(previousIndex);
            }
        }
        if (pFrontierIndex > this.getFrontierIndex()) {
            assert (this.getFrontierIndex() + 1 == pFrontierIndex);
            this.newFrame();
        }
        assert (this.getFrontierIndex() >= pFrontierIndex);
        this.frames.get(pFrontierIndex).add(pRootInvariant);
        this.rootCandidateInvariantFrontierIndices.put(pRootInvariant, pFrontierIndex);
    }

    public boolean isConfirmed(CandidateInvariant pRootInvariant) {
        int index = this.getFrontierIndex(pRootInvariant);
        return IntStream.range(1, index).anyMatch(this.emptyFrames::contains);
    }
}

