/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.pdr;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CounterexampleToInductivity;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ModelValue;
import org.sosy_lab.cpachecker.core.algorithm.bmc.UnrolledReachedSet;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariantCombination;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.TotalTransitionRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.input.InputState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;

class PartialTransitionRelation
implements Comparable<PartialTransitionRelation> {
    private final CFANode startLocation;
    private final LogManager logger;
    private final UnrolledReachedSet reachedSet;
    private final Set<CFANode> loopHeads;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final PathFormulaManager pmgr;
    private @Nullable ImmutableSet<AbstractState> currentEndStates = null;
    private @Nullable ImmutableMap<String, Formula> currentVariables = null;
    private int lastK = -1;

    public PartialTransitionRelation(CFANode pStartLocation, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, FormulaManagerView pFmgr, PathFormulaManager pPmgr, LogManager pLogger, ReachedSet pReachedSet, Set<CFANode> pLoopHeads) {
        this.startLocation = Objects.requireNonNull(pStartLocation);
        this.logger = Objects.requireNonNull(pLogger);
        this.loopHeads = Objects.requireNonNull(pLoopHeads);
        this.reachedSet = new UnrolledReachedSet(pAlgorithm, pCpa, pLoopHeads, pReachedSet, this::ensureK);
        this.fmgr = Objects.requireNonNull(pFmgr);
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.pmgr = Objects.requireNonNull(pPmgr);
    }

    public int getDesiredK() {
        return this.reachedSet.getDesiredK();
    }

    public void setDesiredK(int pK) {
        if (pK < this.reachedSet.getCurrentMaxK()) {
            throw new IllegalArgumentException("The length of this transition relation is " + this.reachedSet.getCurrentMaxK() + " and cannot be decreased.");
        }
        this.reachedSet.setDesiredK(pK);
    }

    public Algorithm.AlgorithmStatus ensureK() throws InterruptedException, CPAException {
        if (this.reachedSet.getDesiredK() > this.lastK) {
            this.currentEndStates = null;
            this.currentVariables = null;
        }
        return this.reachedSet.ensureK();
    }

    public CFANode getStartLocation() {
        return this.startLocation;
    }

    public ImmutableSet<AbstractState> getEndStates() {
        int desiredK = this.getDesiredK();
        if (this.currentEndStates != null && this.lastK == desiredK) {
            return this.currentEndStates;
        }
        this.currentEndStates = this.filterIterationsUpTo(this.reachedSet.getReachedSet(), desiredK).filter(state -> BMCHelper.isEndState(state) || BMCHelper.hasMatchingLocation(state, this.loopHeads) && !Iterables.isEmpty(this.filterIteration(Collections.singleton(state), desiredK))).toSet();
        this.currentVariables = null;
        this.lastK = desiredK;
        return this.currentEndStates;
    }

    public boolean transitionsTo(PartialTransitionRelation pOther) {
        return Iterables.contains(AbstractStates.extractLocations(this.getEndStates()), (Object)pOther.getStartLocation());
    }

    @Override
    public int compareTo(PartialTransitionRelation pOther) {
        return this.startLocation.compareTo(pOther.startLocation);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof PartialTransitionRelation) {
            PartialTransitionRelation other = (PartialTransitionRelation)pOther;
            return this.startLocation.equals(other.startLocation) && this.bfmgr.equals(other.bfmgr) && this.fmgr.equals(other.fmgr) && this.pmgr.equals(other.pmgr) && this.reachedSet.equals(other.reachedSet) && this.logger.equals(other.logger) && this.loopHeads.equals(other.loopHeads);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.startLocation, this.bfmgr, this.fmgr, this.pmgr, this.reachedSet, this.logger, this.loopHeads);
    }

    private Algorithm.AlgorithmStatus ensureK(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, ReachedSet pReachedSet) throws InterruptedException, CPAException {
        if (pReachedSet.size() < 1) {
            AbstractState initialState = pCpa.getInitialState(this.startLocation, StateSpacePartition.getDefaultPartition());
            Precision precision = pCpa.getInitialPrecision(this.startLocation, StateSpacePartition.getDefaultPartition());
            pReachedSet.add(initialState, precision);
            if (pReachedSet.isEmpty()) {
                return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
            }
        }
        return BMCHelper.unroll(this.logger, pReachedSet, pAlgorithm, pCpa);
    }

    public UnrolledReachedSet getReachedSet() {
        return this.reachedSet;
    }

    private FluentIterable<AbstractState> filterIteration(Iterable<AbstractState> pStates, int pIteration) {
        return this.filterIterationsBetween(pStates, pIteration, pIteration);
    }

    private FluentIterable<AbstractState> filterIterationsUpTo(Iterable<AbstractState> pStates, int pIteration) {
        return this.filterIterationsBetween(pStates, 0, pIteration);
    }

    private FluentIterable<AbstractState> filterIterationsBetween(Iterable<AbstractState> pStates, int pMinIt, int pMaxIt) {
        if (pMinIt > pMaxIt) {
            throw new IllegalArgumentException(String.format("Minimum (%d) not lower than maximum (%d)", pMinIt, pMaxIt));
        }
        Preconditions.checkArgument((pMinIt >= 0 ? 1 : 0) != 0, (String)"Minimum must not be lower than 0 but is %s", (int)pMinIt);
        int min = pMinIt;
        int max = pMaxIt;
        Sets.SetView startLocations = this.loopHeads;
        if (this.startLocation.getNumEnteringEdges() == 0 && this.startLocation instanceof FunctionEntryNode) {
            startLocations = Sets.union(startLocations, Collections.singleton(this.startLocation));
            --min;
            if (--max < 0) {
                ReachedSet reached = this.reachedSet.getReachedSet();
                if (reached.isEmpty()) {
                    return FluentIterable.of();
                }
                return FluentIterable.of((Object)reached.getFirstState(), (Object[])new AbstractState[0]);
            }
            min = Math.max(0, min);
            max = Math.max(0, max);
        }
        return BMCHelper.filterIterationsBetween(pStates, min, max, startLocations);
    }

    public ImmutableMap<String, Formula> getVariables() {
        int desiredK = this.getDesiredK();
        if (this.currentVariables != null && this.lastK == desiredK) {
            return this.currentVariables;
        }
        this.currentEndStates = null;
        Sets.SetView relevantLocations = Sets.union(this.loopHeads, Collections.singleton(this.startLocation));
        FluentIterable<AbstractState> relevantStates = this.filterIterationsUpTo((Iterable<AbstractState>)AbstractStates.filterLocations(this.reachedSet.getReachedSet(), (Set<CFANode>)relevantLocations), desiredK);
        this.currentVariables = (ImmutableMap)AbstractStates.projectToType(relevantStates, PredicateAbstractState.class).stream().map(PartialTransitionRelation::getPathFormula).flatMap(pathFormula -> {
            SSAMap ssaMap = pathFormula.getSsa();
            return ssaMap.allVariables().stream().filter(name -> !name.startsWith("*")).map(name -> this.pmgr.makeFormulaForUninstantiatedVariable((String)name, ssaMap.getType((String)name), pathFormula.getPointerTargetSet(), false));
        }).distinct().collect(ImmutableMap.toImmutableMap(f -> this.fmgr.extractVariableNames((Formula)f).iterator().next(), Function.identity()));
        this.lastK = desiredK;
        return this.currentVariables;
    }

    public BooleanFormula getPredecessorAssertions(Iterable<CandidateInvariant> pPredecessorAssertions) throws CPATransferException, InterruptedException {
        return this.getStateAssertions(pPredecessorAssertions, states -> this.filterIterationsUpTo((Iterable<AbstractState>)states, this.getDesiredK() - 1), 1);
    }

    public BooleanFormula getSuccessorAssertion(CandidateInvariant pSuccessorAssertion) throws CPATransferException, InterruptedException {
        return this.getSuccessorAssertions(Collections.singleton(pSuccessorAssertion));
    }

    public BooleanFormula getSuccessorAssertions(Iterable<CandidateInvariant> pSuccessorAssertions) throws CPATransferException, InterruptedException {
        return this.getStateAssertions(pSuccessorAssertions, states -> this.filterIteration((Iterable<AbstractState>)states, this.getDesiredK()), 2);
    }

    private BooleanFormula getStateAssertions(Iterable<CandidateInvariant> pAssertions, UnaryOperator<Iterable<AbstractState>> pStateFilter, int pDefaultIndex) throws CPATransferException, InterruptedException {
        BooleanFormula assertions = this.bfmgr.makeBoolean(true);
        for (CandidateInvariant assertion : pAssertions) {
            for (CandidateInvariant conjunctivePart : CandidateInvariantCombination.getConjunctiveParts(assertion)) {
                assertions = this.bfmgr.and(assertions, this.getStateAssertion(conjunctivePart, pStateFilter, pDefaultIndex));
            }
        }
        return assertions;
    }

    private BooleanFormula getStateAssertion(CandidateInvariant pAssertion, UnaryOperator<Iterable<AbstractState>> pStateFilter, int pDefaultIndex) throws CPATransferException, InterruptedException {
        ReachedSet reached = this.reachedSet.getReachedSet();
        ImmutableSet states = this.filterIterationsUpTo((Iterable)pStateFilter.apply(pAssertion.filterApplicable(reached)), this.getDesiredK()).toSet();
        BooleanFormula stateAssertionFormula = this.bfmgr.makeTrue();
        for (AbstractState state : states) {
            BooleanFormula stateFormula = this.getStateFormula(state);
            BooleanFormula invariantFormula = this.instantiateAt(state, pAssertion, pDefaultIndex);
            stateAssertionFormula = this.bfmgr.and(stateAssertionFormula, this.bfmgr.implication(stateFormula, invariantFormula));
        }
        return stateAssertionFormula;
    }

    private BooleanFormula getStateFormula(AbstractState state) {
        BooleanFormula startLocationFormula = this.getStartLocationFormula();
        BooleanFormula stateFormula = PartialTransitionRelation.getPathFormula(state).getFormula();
        stateFormula = this.bfmgr.and(startLocationFormula, stateFormula);
        if (this.getEndStates().contains((Object)state)) {
            BooleanFormula endLocationFormula = this.bfmgr.makeFalse();
            for (CFANode endLocation : AbstractStates.extractLocations(state)) {
                endLocationFormula = this.bfmgr.or(endLocationFormula, TotalTransitionRelation.getPrimedLocationFormula(this.fmgr, endLocation));
            }
            stateFormula = this.bfmgr.and(stateFormula, endLocationFormula);
        }
        return stateFormula;
    }

    void collectSuccessorViolationAssertions(CandidateInvariant pCandidateInvariant, Multimap<BooleanFormula, BooleanFormula> pCollection) throws CPATransferException, InterruptedException {
        ReachedSet reached = this.reachedSet.getReachedSet();
        FluentIterable<AbstractState> assertionStates = this.filterIteration(pCandidateInvariant.filterApplicable(reached), this.getDesiredK());
        for (AbstractState state : assertionStates) {
            BooleanFormula stateFormula = this.getStateFormula(state);
            BooleanFormula invariantFormula = this.instantiateAt(state, pCandidateInvariant, 2);
            pCollection.put((Object)stateFormula, (Object)this.bfmgr.not(invariantFormula));
        }
    }

    private BooleanFormula instantiateAt(AbstractState pState, CandidateInvariant pCandidateInvariant, int pDefaultIndex) throws CPATransferException, InterruptedException {
        PathFormula pathFormula = PartialTransitionRelation.getPathFormula(pState);
        SSAMap ssaMap = pathFormula.getSsa().withDefault(pDefaultIndex);
        pathFormula = pathFormula.withContext(ssaMap, pathFormula.getPointerTargetSet());
        BooleanFormula uninstantiatedFormula = pCandidateInvariant.getFormula(this.fmgr, this.pmgr, pathFormula);
        return this.fmgr.instantiate(uninstantiatedFormula, ssaMap);
    }

    public BooleanFormula getStartLocationFormula() {
        return TotalTransitionRelation.getUnprimedLocationFormula(this.fmgr, this.startLocation);
    }

    public BooleanFormula getFormula() {
        ImmutableSet<AbstractState> endStates = this.getEndStates();
        ReachedSet reached = this.reachedSet.getReachedSet();
        if (reached.isEmpty() || endStates.isEmpty()) {
            return this.bfmgr.makeFalse();
        }
        BooleanFormula transition = this.bfmgr.makeFalse();
        for (AbstractState endState : endStates) {
            BooleanFormula endStateFormula = this.getStateFormula(endState);
            transition = this.bfmgr.or(transition, endStateFormula);
        }
        return transition;
    }

    public CtiWithInputs getCtiWithInputs(List<Model.ValueAssignment> pModelAssignments) {
        HashMap<String, CType> types = new HashMap<String, CType>();
        Multimap<String, Integer> inputs = PartialTransitionRelation.extractInputs(this.filterIterationsUpTo(this.getReachedSet().getReachedSet(), this.getDesiredK() + 1), types);
        ImmutableMap<String, Formula> variables = this.getVariables();
        PersistentSortedMap model = PathCopyingPersistentTreeMap.of();
        for (Model.ValueAssignment valueAssignment : pModelAssignments) {
            if (valueAssignment.isFunction()) continue;
            String fullName = valueAssignment.getName();
            Pair<String, OptionalInt> pair = FormulaManagerView.parseName(fullName);
            String actualName = pair.getFirst();
            OptionalInt index = pair.getSecond();
            Object value = valueAssignment.getValue();
            if (!index.isPresent() || index.orElseThrow() != 1 || !(value instanceof Number) || !actualName.equals(TotalTransitionRelation.getLocationVariableName()) && (!variables.containsKey((Object)actualName) || inputs.get((Object)actualName).contains(index.orElseThrow()))) continue;
            BooleanFormula assignment = this.fmgr.uninstantiate(valueAssignment.getAssignmentAsFormula());
            model = model.putAndCopy((Object)actualName, (Object)new ModelValue(actualName, assignment, this.fmgr));
        }
        CounterexampleToInductivity cti = new CounterexampleToInductivity(this.startLocation, (Map<String, ModelValue>)model);
        return new CtiWithInputs(cti, PartialTransitionRelation.getInputAssignments(this.fmgr, variables, this.getReachedSet().getReachedSet(), pModelAssignments));
    }

    private static BooleanFormula getInputAssignments(FormulaManagerView pFmgr, Map<String, Formula> pVariables, Iterable<AbstractState> pReached, Iterable<Model.ValueAssignment> pModelAssignments) {
        BooleanFormulaManagerView bfmgr = pFmgr.getBooleanFormulaManager();
        BooleanFormula inputAssignments = bfmgr.makeTrue();
        HashMap<String, CType> types = new HashMap<String, CType>();
        Multimap<String, Integer> inputs = PartialTransitionRelation.extractInputs(pReached, types);
        if (inputs.isEmpty()) {
            return inputAssignments;
        }
        for (Model.ValueAssignment valueAssignment : pModelAssignments) {
            if (valueAssignment.isFunction()) continue;
            String fullName = valueAssignment.getName();
            Pair<String, OptionalInt> pair = FormulaManagerView.parseName(fullName);
            String actualName = pair.getFirst();
            OptionalInt index = pair.getSecond();
            if ((!index.isPresent() || !inputs.get((Object)actualName).contains(index.orElseThrow())) && (index.isPresent() || pVariables.containsKey(actualName))) continue;
            inputAssignments = bfmgr.and(inputAssignments, valueAssignment.getAssignmentAsFormula());
        }
        return inputAssignments;
    }

    private static Multimap<String, Integer> extractInputs(Iterable<AbstractState> pReached, Map<String, CType> types) {
        LinkedHashMultimap inputs = LinkedHashMultimap.create();
        for (AbstractState s : pReached) {
            InputState is = AbstractStates.extractStateByType(s, InputState.class);
            if (is == null) continue;
            PredicateAbstractState pas = AbstractStates.extractStateByType(s, PredicateAbstractState.class);
            SSAMap ssaMap = pas.getPathFormula().getSsa();
            for (String input : is.getInputs()) {
                if (!ssaMap.containsVariable(input)) continue;
                inputs.put((Object)input, (Object)(ssaMap.getIndex(input) - 1));
                types.put(input, ssaMap.getType(input));
            }
            for (String varName : ssaMap.allVariables()) {
                types.put(varName, ssaMap.getType(varName));
            }
        }
        return inputs;
    }

    private static PathFormula getPathFormula(AbstractState pPas) {
        PredicateAbstractState pas = AbstractStates.extractStateByType(pPas, PredicateAbstractState.class);
        return PartialTransitionRelation.getPathFormula(pas);
    }

    private static PathFormula getPathFormula(PredicateAbstractState pPas) {
        if (pPas.isAbstractionState()) {
            return pPas.getAbstractionFormula().getBlockFormula();
        }
        return pPas.getPathFormula();
    }

    static class CtiWithInputs {
        private final CounterexampleToInductivity cti;
        private final BooleanFormula inputs;

        public CtiWithInputs(CounterexampleToInductivity pCti, BooleanFormula pInputs) {
            this.cti = Objects.requireNonNull(pCti);
            this.inputs = Objects.requireNonNull(pInputs);
        }

        public String toString() {
            return this.cti + " with inputs " + this.inputs;
        }

        public CounterexampleToInductivity getCti() {
            return this.cti;
        }

        public BooleanFormula getInputs() {
            return this.inputs;
        }
    }
}

