/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.pdr;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractionBasedLifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AssertCandidate;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InductionResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthening;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthenings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.Lifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.PredicateAbstractionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProofResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StandardLiftings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StaticCandidateProvider;
import org.sosy_lab.cpachecker.core.algorithm.bmc.UnrolledReachedSet;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.FrameSet;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.FrontierExtensionResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.PartialTransitionRelation;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.ProofObligation;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.TotalTransitionRelation;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.invariants.ExpressionTreeInvariantSupplier;
import org.sosy_lab.cpachecker.util.predicates.invariants.FormulaInvariantsSupplier;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class PdrAlgorithm
implements Algorithm {
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final FormulaManagerView fmgr;
    private final PathFormulaManager pmgr;
    private final PredicateAbstractionManager pam;
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final CFA cfa;
    private final Specification specification;
    private final Configuration config;
    private final PdrStatistics stats;
    private final BasicPdrOptions basicPdrOptions;
    private final AbstractionStrategy abstractionStrategy;
    private final InvariantGenerator invariantGenerator;
    private final TargetLocationProvider targetLocationProvider;
    private final ShutdownNotifier shutdownNotifier;
    private final AssignmentToPathAllocator assignmentToPathAllocator;
    private final Set<CandidateInvariant> confirmedCandidates = new CopyOnWriteArraySet<CandidateInvariant>();
    private boolean invariantGenerationRunning = true;

    public PdrAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, final CFA pCFA, Specification pSpecification, final AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException {
        this.algorithm = pAlgorithm;
        this.cpa = pCPA;
        this.logger = pLogger;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCFA;
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.config = pConfig;
        this.stats = new PdrStatistics();
        this.basicPdrOptions = new BasicPdrOptions(this.config);
        this.abstractionStrategy = this.basicPdrOptions.abstractionStrategyFactory.createAbstractionStrategy(this.cfa.getVarClassification());
        this.shutdownNotifier = pShutdownNotifier;
        this.targetLocationProvider = new CachingTargetLocationProvider(this.shutdownNotifier, this.logger, this.cfa);
        PredicateCPA predCpa = CPAs.retrieveCPAOrFail(this.cpa, PredicateCPA.class, BMCAlgorithm.class);
        this.solver = predCpa.getSolver();
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pmgr = predCpa.getPathFormulaManager();
        this.pam = predCpa.getPredicateManager();
        this.assignmentToPathAllocator = new AssignmentToPathAllocator(this.config, this.shutdownNotifier, pLogger, this.cfa.getMachineModel());
        this.invariantGenerator = new AbstractInvariantGenerator(){

            @Override
            protected void startImpl(CFANode pInitialLocation) {
            }

            @Override
            public boolean isProgramSafe() {
                return false;
            }

            @Override
            public void cancel() {
            }

            @Override
            public InvariantSupplier getSupplier() throws CPAException, InterruptedException {
                return new FormulaInvariantsSupplier(pAggregatedReachedSets);
            }

            @Override
            public ExpressionTreeSupplier getExpressionTreeSupplier() throws CPAException, InterruptedException {
                return new ExpressionTreeInvariantSupplier(pAggregatedReachedSets, pCFA);
            }
        };
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        CFANode initialLocation = AbstractStates.extractLocation(pReachedSet.getFirstState());
        TotalTransitionRelation transitionRelation = new TotalTransitionRelation(this.fmgr, initialLocation, this.getNonTrivialLoopHeads().iterator(), (Function<CFANode, PartialTransitionRelation>)((Function)location -> location == initialLocation ? this.createPartialTransitionRelation((CFANode)location, pReachedSet) : this.createPartialTransitionRelation((CFANode)location)));
        for (BooleanFormula locationFormula : transitionRelation.getPredecessorLocationFormulas()) {
            this.abstractionStrategy.refinePrecision(this.pam, Collections.singleton(locationFormula));
        }
        try {
            return this.runPdr(transitionRelation);
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure: " + e.getMessage(), e);
        }
    }

    private Algorithm.AlgorithmStatus runPdr(TotalTransitionRelation pTransitionRelation) throws InterruptedException, CPAException, SolverException {
        Objects.requireNonNull(pTransitionRelation);
        UnrolledReachedSet bmcReachedSet = pTransitionRelation.getInitiationRelation().getReachedSet();
        ReachedSet rawBmcReachedSet = bmcReachedSet.getReachedSet();
        CandidateGenerator candidateGenerator = this.getCandidateInvariants();
        if (!candidateGenerator.produceMoreCandidates()) {
            rawBmcReachedSet.clearWaitlist();
            return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        }
        Algorithm.AlgorithmStatus status = pTransitionRelation.ensureK();
        if (!this.checkAbstractionFree(rawBmcReachedSet)) {
            return status;
        }
        boolean producedNewRootInvariants = true;
        try (FrameSet frameSet = new FrameSet(this.solver, EnumSet.of(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_UNSAT_CORE));){
            this.learnClause(frameSet, 0, pTransitionRelation.getInitiationAssertion());
            while (producedNewRootInvariants) {
                Optional<Algorithm.AlgorithmStatus> initialPushResult = this.initialPush(candidateGenerator, bmcReachedSet, frameSet);
                if (initialPushResult.isPresent()) {
                    Algorithm.AlgorithmStatus algorithmStatus = initialPushResult.orElseThrow();
                    return algorithmStatus;
                }
                while (candidateGenerator.hasCandidatesAvailable()) {
                    Algorithm.AlgorithmStatus algorithmStatus;
                    Optional<Algorithm.AlgorithmStatus> candidateConfirmationResult;
                    boolean propagated = false;
                    for (int i = 0; i < frameSet.getFrontierIndex(); ++i) {
                        ProverEnvironmentWithFallback frameProver = frameSet.getFrameProver(i);
                        Sets.SetView frameInvariants = frameSet.getInvariants(i);
                        frameInvariants = Sets.union(frameInvariants, Collections.singleton(this.getCurrentInvariant(pTransitionRelation)));
                        ArrayList<CandidateInvariant> toPush = new ArrayList<CandidateInvariant>();
                        for (CandidateInvariant frameClause : frameSet.getPushableFrameClauses(i)) {
                            InductionResult pushAttempt = this.checkInduction(frameProver, (Set<CandidateInvariant>)frameInvariants, pTransitionRelation, frameClause, InvariantStrengthenings.noStrengthening(), StandardLiftings.NO_LIFTING);
                            if (!pushAttempt.isSuccessful()) continue;
                            toPush.add(frameClause);
                            propagated = true;
                        }
                        for (CandidateInvariant pushableClause : toPush) {
                            frameSet.pushFrameClause(i, pushableClause);
                        }
                    }
                    if (propagated && (candidateConfirmationResult = this.handleConfirmedCandidates(candidateGenerator, frameSet, rawBmcReachedSet)).isPresent()) {
                        algorithmStatus = candidateConfirmationResult.orElseThrow();
                        return algorithmStatus;
                    }
                    Optional<Algorithm.AlgorithmStatus> strengthenResult = this.strengthen(candidateGenerator, frameSet, pTransitionRelation);
                    if (!strengthenResult.isPresent()) continue;
                    algorithmStatus = strengthenResult.orElseThrow();
                    return algorithmStatus;
                }
                producedNewRootInvariants = candidateGenerator.produceMoreCandidates();
            }
        }
        return status;
    }

    private boolean adjustConditions() {
        FluentIterable conditionCPAs = CPAs.asIterable(this.cpa).filter(AdjustableConditionCPA.class);
        boolean adjusted = false;
        for (AdjustableConditionCPA condCpa : conditionCPAs) {
            if (!condCpa.adjustPrecision()) continue;
            adjusted = true;
        }
        if (!adjusted) {
            this.logger.log(Level.INFO, new Object[]{"Terminating because none of the following CPAs' precision can be adjusted any further ", conditionCPAs.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", "))});
            return false;
        }
        return !Iterables.isEmpty((Iterable)conditionCPAs);
    }

    private boolean continueAfterFailedConditionAdjustment() {
        return true;
    }

    private Optional<Algorithm.AlgorithmStatus> strengthen(CandidateGenerator pCandidateGenerator, FrameSet pFrameSet, TotalTransitionRelation pTransitionRelation) throws InterruptedException, SolverException, CPAException {
        Optional<Algorithm.AlgorithmStatus> strengthenResult = this.blockAllKStepCounterexamples(pCandidateGenerator, pFrameSet, pTransitionRelation);
        if (strengthenResult.isPresent()) {
            return strengthenResult;
        }
        Optional<Algorithm.AlgorithmStatus> candidateConfirmationResult = this.handleConfirmedCandidates(pCandidateGenerator, pFrameSet, pTransitionRelation.getInitiationRelation().getReachedSet().getReachedSet());
        if (candidateConfirmationResult.isPresent()) {
            return candidateConfirmationResult;
        }
        if (this.basicPdrOptions.getConditionAdjustmentCriterion().shouldAdjustConditions() && !this.adjustConditions() && !this.continueAfterFailedConditionAdjustment()) {
            return Optional.of(Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE);
        }
        return Optional.empty();
    }

    private Optional<Algorithm.AlgorithmStatus> blockAllKStepCounterexamples(CandidateGenerator pCandidateGenerator, FrameSet pFrameSet, TotalTransitionRelation pTransitionRelation) throws InterruptedException, SolverException, CPAException {
        for (CandidateInvariant rootCandidateInvariant : pCandidateGenerator) {
            ProofResult frontierExtensionResult = null;
            while (frontierExtensionResult == null || !frontierExtensionResult.isSuccessful()) {
                Optional<Algorithm.AlgorithmStatus> blockResult;
                frontierExtensionResult = this.extendFrontier(rootCandidateInvariant, pFrameSet, pTransitionRelation);
                if (frontierExtensionResult.getEarlyReturn().isPresent()) {
                    return frontierExtensionResult.getEarlyReturn();
                }
                if (frontierExtensionResult.isSuccessful() || !(blockResult = this.blockProofObligation(pFrameSet, pTransitionRelation, ((FrontierExtensionResult)frontierExtensionResult).getProofObligation(), pCandidateGenerator)).isPresent()) continue;
                return blockResult;
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<Algorithm.AlgorithmStatus> blockProofObligation(FrameSet pFrameSet, TotalTransitionRelation pTransitionRelation, ProofObligation pObligation, CandidateGenerator pCandidateGenerator) throws SolverException, InterruptedException, CPAException {
        int frontierIndex = pFrameSet.getFrontierIndex();
        HashSet<ProofObligation> forceEagerLiftingRefinement = new HashSet<ProofObligation>();
        PriorityQueue<ProofObligation> proofObligations = new PriorityQueue<ProofObligation>();
        proofObligations.add(pObligation);
        boolean checkCounterexample = false;
        while (!proofObligations.isEmpty()) {
            boolean safe;
            this.shutdownNotifier.shutdownIfNecessary();
            ProofObligation obligation = (ProofObligation)proofObligations.poll();
            SymbolicCandiateInvariant abstractBlockingClause = obligation.getBlockedAbstractCti();
            int frameIndex = obligation.getFrameIndex();
            Sets.SetView invariants = pFrameSet.getInvariants(frameIndex);
            invariants = Sets.union(invariants, Collections.singleton(this.getCurrentInvariant(pTransitionRelation)));
            ProverEnvironmentWithFallback prover = pFrameSet.getFrameProver(frameIndex);
            boolean eagerLiftingRefinement = obligation.getLiftingAbstractionFailureCount() >= this.basicPdrOptions.getLiftingAbstractionFailureThreshold() || frameIndex == 0 || forceEagerLiftingRefinement.contains(obligation);
            DetectingLiftingAbstractionFailureStrategy lafsForAbstractCheck = new DetectingLiftingAbstractionFailureStrategy(eagerLiftingRefinement);
            Lifting liftingForAbstractCheck = this.basicPdrOptions.getLiftingStrategy().createLifting(this.abstractionStrategy, lafsForAbstractCheck);
            InductionResult<SymbolicCandiateInvariant> abstractResult = this.checkInduction(prover, (Set<CandidateInvariant>)invariants, pTransitionRelation, abstractBlockingClause, this.basicPdrOptions.getInvariantRefinementStrategy().createRefinementStrategy(this.abstractionStrategy), liftingForAbstractCheck);
            if (abstractResult.isSuccessful()) {
                this.learnClause(pFrameSet, frameIndex + 1, abstractResult.getInvariantRefinement());
                this.logger.log(Level.FINEST, new Object[]{"Learned clause " + abstractBlockingClause + " at frame index " + (frameIndex + 1) + " to block " + obligation});
                if (frameIndex + 1 < frontierIndex) {
                    proofObligations.add(obligation.incrementFrameIndex());
                }
            } else if (obligation.getBlockedConcreteCti().isPresent()) {
                InvariantStrengthening invariantAbstraction = this.mustRefineOnConsecutionAbstractionFailure(obligation) ? this.basicPdrOptions.getInvariantRefinementStrategy().createRefinementStrategy(this.abstractionStrategy) : InvariantStrengthenings.noStrengthening();
                DetectingLiftingAbstractionFailureStrategy lafsForConcreteCheck = new DetectingLiftingAbstractionFailureStrategy(eagerLiftingRefinement);
                Lifting liftingForConcreteCheck = this.basicPdrOptions.getLiftingStrategy().createLifting(this.abstractionStrategy, lafsForConcreteCheck);
                InductionResult concreteResult = this.checkInduction(prover, (Set<CandidateInvariant>)invariants, pTransitionRelation, obligation.getBlockedConcreteCti().orElseThrow(), invariantAbstraction, liftingForConcreteCheck);
                if (concreteResult.isSuccessful()) {
                    assert (this.implies(prover, (Set<CandidateInvariant>)invariants, obligation.getBlockedConcreteCti().orElseThrow()));
                    if (this.mustRefineOnConsecutionAbstractionFailure(obligation)) {
                        SymbolicCandiateInvariant refined = (SymbolicCandiateInvariant)concreteResult.getInvariantRefinement();
                        assert (this.implies(prover, (Set<CandidateInvariant>)invariants, refined));
                        this.logger.log(Level.FINEST, new Object[]{"Learned clause " + refined + " at frame index " + (frameIndex + 1) + " to block " + pObligation});
                        this.learnClause(pFrameSet, frameIndex + 1, refined);
                    } else {
                        if (frameIndex <= 0) throw new AssertionError((Object)("Negative frame index? Frame zero should be handled in the first CAF case, frames with positive index in the second CAF case. Actual index: " + frameIndex));
                        PdrAlgorithm.extractNewProofObligations(obligation, lafsForAbstractCheck, abstractResult).map(ProofObligation::addSpuriousTransition).forEach(proofObligations::offer);
                    }
                } else if (frameIndex > 0) {
                    PdrAlgorithm.extractNewProofObligations(obligation, lafsForConcreteCheck, concreteResult).map(ProofObligation::addSpuriousTransition).forEach(proofObligations::offer);
                } else {
                    Optional<ProofObligation> nextLAF = obligation.find(o -> o != obligation && o.getBlockedConcreteCti().isPresent());
                    if (nextLAF.isPresent()) {
                        ProofObligation next = nextLAF.orElseThrow();
                        next = next.addSpuriousTransition();
                        forceEagerLiftingRefinement.add(next);
                        proofObligations.offer(next);
                    } else {
                        checkCounterexample = true;
                    }
                }
            } else if (frameIndex > 0) {
                PdrAlgorithm.extractNewProofObligations(obligation, lafsForAbstractCheck, abstractResult).forEach(proofObligations::offer);
            } else {
                checkCounterexample = true;
            }
            if (!checkCounterexample || (safe = this.boundedModelCheck(obligation, pTransitionRelation.getInitiationRelation().getReachedSet(), pFrameSet.getFrameProver(0)))) continue;
            CandidateInvariant violatedCandidate = obligation.getViolatedInvariant();
            Iterables.removeIf((Iterable)pCandidateGenerator, violatedCandidate::equals);
            if (violatedCandidate != TargetLocationCandidateInvariant.INSTANCE) continue;
            return Optional.of(Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean implies(ProverEnvironmentWithFallback pProver, Set<CandidateInvariant> pInvariants, SymbolicCandiateInvariant pBlockedAbstractCti) throws SolverException, InterruptedException {
        try {
            boolean sound;
            BooleanFormula frameAssertion = this.bfmgr.makeTrue();
            for (SymbolicCandiateInvariant frameClause : Iterables.filter(pInvariants, SymbolicCandiateInvariant.class)) {
                frameAssertion = this.bfmgr.and(frameAssertion, frameClause.getPlainFormula(this.fmgr));
            }
            BooleanFormula violation = this.bfmgr.not(pBlockedAbstractCti.getPlainFormula(this.fmgr));
            pProver.push(frameAssertion);
            pProver.push(violation);
            boolean bl = sound = pProver.isUnsat();
            return bl;
        }
        finally {
            pProver.pop();
            pProver.pop();
        }
    }

    private static Stream<ProofObligation> extractNewProofObligations(ProofObligation pOldObligation, DetectingLiftingAbstractionFailureStrategy pLafsForCheck, InductionResult<? extends CandidateInvariant> pCheckResult) {
        return pCheckResult.getBadStateBlockingClauses().stream().map(badStateBlockingClause -> pOldObligation.causeProofObligation((SymbolicCandiateInvariant)badStateBlockingClause, pLafsForCheck.getBlockedConcreteCtiForSpuriousAbstraction((SymbolicCandiateInvariant)badStateBlockingClause), pOldObligation.getNSpuriousTransitions(), pCheckResult.getK()));
    }

    private boolean mustRefineOnConsecutionAbstractionFailure(ProofObligation obligation) {
        return obligation.getNSpuriousTransitions() >= this.basicPdrOptions.getSpuriousTransitionCountThreshold() || obligation.getFrameIndex() == 0;
    }

    private void learnClause(FrameSet pFrameSet, int pFrameIndex, SymbolicCandiateInvariant pClause) {
        pFrameSet.addFrameClause(pFrameIndex, pClause);
    }

    private InvariantSupplier getCurrentInvariantSupplier() throws InterruptedException {
        if (this.invariantGenerationRunning) {
            try {
                return this.invariantGenerator.getSupplier();
            }
            catch (CPAException e) {
                this.logger.logUserException(Level.FINE, (Throwable)e, "Invariant generation failed.");
                this.invariantGenerationRunning = false;
            }
            catch (InterruptedException e) {
                this.shutdownNotifier.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Invariant generation was cancelled."});
                this.logger.logDebugException((Throwable)e);
                this.invariantGenerationRunning = false;
            }
        }
        return InvariantSupplier.TrivialInvariantSupplier.INSTANCE;
    }

    private CandidateInvariant getCurrentInvariant(TotalTransitionRelation pTotalTransitionRelation) throws InterruptedException {
        BooleanFormula invariant = this.bfmgr.makeTrue();
        for (CFANode location : pTotalTransitionRelation.getPredecessorLocations()) {
            BooleanFormula locationInvariant = this.getCurrentInvariantSupplier().getInvariantFor(location, Optional.empty(), this.fmgr, this.pmgr, null);
            if (this.bfmgr.isTrue(locationInvariant)) continue;
            invariant = this.bfmgr.and(invariant, this.fmgr.uninstantiate(this.bfmgr.implication(TotalTransitionRelation.getUnprimedLocationFormula(this.fmgr, location), locationInvariant)));
        }
        return SymbolicCandiateInvariant.makeSymbolicInvariant(pTotalTransitionRelation.getPredecessorLocations(), pTotalTransitionRelation.getCandidateInvariantStatePredicate(), invariant, this.fmgr);
    }

    private FrontierExtensionResult extendFrontier(CandidateInvariant pRootCandidateInvariant, FrameSet pFrameSet, TotalTransitionRelation pTransitionRelation) throws InterruptedException, CPATransferException, SolverException {
        int oldFrontierIndex = pFrameSet.getFrontierIndex(pRootCandidateInvariant);
        Sets.SetView predecessorAssertions = pFrameSet.getInvariants(oldFrontierIndex);
        predecessorAssertions = Sets.union(predecessorAssertions, Collections.singleton(this.getCurrentInvariant(pTransitionRelation)));
        ProverEnvironmentWithFallback prover = pFrameSet.getFrameProver(oldFrontierIndex);
        boolean eagerLiftingRefinement = oldFrontierIndex == 0 || this.basicPdrOptions.liftingAbstractionFailureThreshold <= 0;
        DetectingLiftingAbstractionFailureStrategy lafs = new DetectingLiftingAbstractionFailureStrategy(eagerLiftingRefinement);
        InductionResult inductionResult = this.checkInduction(prover, (Set<CandidateInvariant>)predecessorAssertions, pTransitionRelation, pRootCandidateInvariant, InvariantStrengthenings.noStrengthening(), this.basicPdrOptions.getLiftingStrategy().createLifting(this.abstractionStrategy, lafs));
        if (inductionResult.isSuccessful()) {
            pFrameSet.pushFrontier(oldFrontierIndex + 1, pRootCandidateInvariant);
            return FrontierExtensionResult.getSuccess();
        }
        Set<SymbolicCandiateInvariant> model = inductionResult.getBadStateBlockingClauses();
        assert (model.size() == 1);
        SymbolicCandiateInvariant blockedAbstractCti = model.iterator().next();
        Optional<SymbolicCandiateInvariant> blockedConcreteCti = lafs.getBlockedConcreteCtiForSpuriousAbstraction(blockedAbstractCti);
        assert (!eagerLiftingRefinement || !blockedConcreteCti.isPresent());
        return FrontierExtensionResult.getFailure(ProofObligation.createObligation(blockedAbstractCti, blockedConcreteCti, oldFrontierIndex - 1, 0, pTransitionRelation.getInitiationRelation().getDesiredK(), pRootCandidateInvariant));
    }

    private <S extends CandidateInvariant, T extends CandidateInvariant> InductionResult<T> checkInduction(ProverEnvironmentWithFallback pProver, Set<CandidateInvariant> pPredecessorAssertions, TotalTransitionRelation pTransitionRelation, S pCandidateInvariant, InvariantStrengthening<S, T> pInvariantRefinement, Lifting pLifting) throws SolverException, InterruptedException, CPATransferException {
        SymbolicCandiateInvariant.BlockedCounterexampleToInductivity blockedConcreteCti;
        assert (pProver.isEmpty());
        AssertCandidate assertSinglePredecessor = p -> BMCHelper.assertAt(Collections.singleton(pTransitionRelation.getInitiationRelation().getReachedSet().getReachedSet().getFirstState()), p, this.fmgr, this.pmgr, true);
        Object transitionAssertionId = pProver.push(pTransitionRelation.getTransitionFormula());
        Object predecessorAssertionId = pProver.push(pTransitionRelation.getPredecessorAssertions(pPredecessorAssertions));
        Object candidateAssertionId = pProver.push(pTransitionRelation.getPredecessorAssertion(pCandidateInvariant));
        Multimap<BooleanFormula, BooleanFormula> successorViolationAssertions = pTransitionRelation.getSuccessorViolationAssertions(pCandidateInvariant);
        BooleanFormula successorViolation = BMCHelper.disjoinStateViolationAssertions(this.bfmgr, successorViolationAssertions);
        pProver.push(successorViolation);
        boolean success = pProver.isUnsat();
        if (success) {
            AssertCandidate assertKPredecessors = p -> pTransitionRelation.getPredecessorAssertion(p);
            AssertCandidate assertSuccessorViolation = candidate -> {
                Multimap<BooleanFormula, BooleanFormula> succViolationAssertions = pTransitionRelation.getSuccessorViolationAssertions(pCandidateInvariant);
                BooleanFormula succViolation = BMCHelper.disjoinStateViolationAssertions(this.bfmgr, succViolationAssertions);
                return succViolation;
            };
            InvariantStrengthening.NextCti nextCti = () -> {
                ImmutableList<Model.ValueAssignment> modelAssignments = pProver.getModelAssignments();
                PartialTransitionRelation violatedPartialTransition = pTransitionRelation.getViolatedPartialTransition((List<Model.ValueAssignment>)modelAssignments);
                PartialTransitionRelation.CtiWithInputs ctiWithInputs = violatedPartialTransition.getCtiWithInputs((List<Model.ValueAssignment>)modelAssignments);
                return Optional.of(ctiWithInputs.getCti());
            };
            T refinedInvariant = pInvariantRefinement.strengthenInvariant(pProver, this.fmgr, this.pam, pCandidateInvariant, assertKPredecessors, assertSuccessorViolation, assertSinglePredecessor, successorViolationAssertions, Optional.empty(), nextCti);
            pProver.pop();
            pProver.pop();
            pProver.pop();
            pProver.pop();
            assert (pProver.isEmpty());
            return InductionResult.getSuccessful(refinedInvariant);
        }
        ImmutableList<Model.ValueAssignment> modelAssignments = pProver.getModelAssignments();
        PartialTransitionRelation violatedPartialTransition = pTransitionRelation.getViolatedPartialTransition((List<Model.ValueAssignment>)modelAssignments);
        PartialTransitionRelation.CtiWithInputs ctiWithInputs = violatedPartialTransition.getCtiWithInputs((List<Model.ValueAssignment>)modelAssignments);
        SymbolicCandiateInvariant blockedAbstractCti = blockedConcreteCti = SymbolicCandiateInvariant.blockCti(pTransitionRelation.getPredecessorLocations(), pTransitionRelation.getCandidateInvariantStatePredicate(), ctiWithInputs.getCti(), this.fmgr);
        BooleanFormula inputs = ctiWithInputs.getInputs();
        pProver.pop();
        if (pLifting.canLift()) {
            assert (!pProver.isUnsat());
            Object successorAssertionId = pProver.push(pTransitionRelation.getSuccessorAssertion(pCandidateInvariant));
            Object inputAssertionId = pProver.push(inputs);
            blockedAbstractCti = pLifting.lift(this.fmgr, this.pam, pProver, blockedConcreteCti, assertSinglePredecessor, Arrays.asList(transitionAssertionId, predecessorAssertionId, candidateAssertionId, successorAssertionId, inputAssertionId));
            pProver.pop();
            pProver.pop();
        }
        pProver.pop();
        pProver.pop();
        pProver.pop();
        assert (pProver.isEmpty());
        return InductionResult.getFailed(Collections.singleton(blockedAbstractCti), violatedPartialTransition.getDesiredK());
    }

    private Optional<Algorithm.AlgorithmStatus> handleConfirmedCandidates(CandidateGenerator pCandidateGenerator, FrameSet pFrameSet, ReachedSet pReachedSet) {
        Iterator<CandidateInvariant> rootInvariantIterator = pCandidateGenerator.iterator();
        while (rootInvariantIterator.hasNext()) {
            CandidateInvariant rootInvariant = rootInvariantIterator.next();
            if (!pFrameSet.isConfirmed(rootInvariant)) continue;
            rootInvariantIterator.remove();
            this.confirmedCandidates.add(rootInvariant);
            if (rootInvariant != TargetLocationCandidateInvariant.INSTANCE) continue;
            rootInvariant.assumeTruth(pReachedSet);
            return Optional.of(Algorithm.AlgorithmStatus.SOUND_AND_PRECISE);
        }
        return Optional.empty();
    }

    private Optional<Algorithm.AlgorithmStatus> initialPush(CandidateGenerator pCandidateGenerator, UnrolledReachedSet pBmcReachedSet, FrameSet pFrameSet) throws CPATransferException, InterruptedException, SolverException {
        Iterator<CandidateInvariant> rootInvariantIterator = pCandidateGenerator.iterator();
        while (rootInvariantIterator.hasNext()) {
            CandidateInvariant rootInvariant = rootInvariantIterator.next();
            boolean bmcSafe = this.boundedModelCheck(pBmcReachedSet, pFrameSet.getFrameProver(0), rootInvariant);
            if (bmcSafe) {
                pFrameSet.pushFrontier(1, rootInvariant);
                continue;
            }
            rootInvariantIterator.remove();
            if (rootInvariant != TargetLocationCandidateInvariant.INSTANCE) continue;
            return Optional.of(Algorithm.AlgorithmStatus.SOUND_AND_PRECISE);
        }
        return Optional.empty();
    }

    private PartialTransitionRelation createPartialTransitionRelation(CFANode predecessorLocation) {
        return this.createPartialTransitionRelation(predecessorLocation, this.reachedSetFactory.create(this.cpa));
    }

    private PartialTransitionRelation createPartialTransitionRelation(CFANode predecessorLocation, ReachedSet pReachedSet) {
        PartialTransitionRelation partialTransitionRelation = new PartialTransitionRelation(predecessorLocation, this.algorithm, this.cpa, this.fmgr, this.pmgr, this.logger, pReachedSet, this.getLoopHeads());
        return partialTransitionRelation;
    }

    protected Collection<CFANode> getTargetLocations() {
        return this.targetLocationProvider.tryGetAutomatonTargetLocations(this.cfa.getMainFunction(), this.specification);
    }

    private Set<CFANode> getLoopHeads() {
        return BMCHelper.getLoopHeads(this.cfa, this.targetLocationProvider);
    }

    private Stream<CFANode> getNonTrivialLoopHeads() {
        Set<CFANode> loopHeads = this.getLoopHeads();
        if (!this.cfa.getLoopStructure().isPresent()) {
            return loopHeads.stream();
        }
        return this.cfa.getLoopStructure().orElseThrow().getAllLoops().stream().filter(loop -> !BMCHelper.isTrivialSelfLoop(loop)).map(LoopStructure.Loop::getLoopHeads).flatMap(Collection::stream).filter(this.getLoopHeads()::contains).distinct();
    }

    private boolean checkAbstractionFree(ReachedSet pBmcReachedSet) {
        Optional<AbstractState> abstractionState = FluentIterable.from((Iterable)pBmcReachedSet).stream().skip(1L).filter(Predicates.not(AbstractStates::isTargetState)).filter(PredicateAbstractState::containsAbstractionState).findAny();
        if (abstractionState.isPresent()) {
            this.logger.log(Level.WARNING, new Object[]{"PDR algorithm and its derivatives do not work with PredicateCPA abstractions. Could not check for satisfiability."});
            return false;
        }
        return true;
    }

    private boolean boundedModelCheck(ProofObligation pObligation, UnrolledReachedSet pBmcReachedSet, ProverEnvironmentWithFallback pCexProver) throws InterruptedException, CPAException, SolverException {
        Preconditions.checkArgument((pObligation.getFrameIndex() == 0 ? 1 : 0) != 0, (Object)"Bounded model check should only be called for obligations at frame index zero.");
        CandidateInvariant violatedCandidate = pObligation.getViolatedInvariant();
        ReachedSet reached = pBmcReachedSet.getReachedSet();
        int previousK = pBmcReachedSet.getDesiredK();
        int k = 0;
        BooleanFormula program = this.bfmgr.makeTrue();
        for (ProofObligation currentObligation : pObligation) {
            pBmcReachedSet.setDesiredK((k += currentObligation.getLength()) + 1);
            pBmcReachedSet.ensureK();
        }
        pBmcReachedSet.setDesiredK(previousK);
        Iterable<AbstractState> violationStates = violatedCandidate.filterApplicable(reached);
        violationStates = BMCHelper.filterIterationsUpTo(violationStates, k, this.getLoopHeads());
        BooleanFormula candidateAssertion = violatedCandidate.getAssertion(violationStates, this.fmgr, this.pmgr);
        BooleanFormula violationAssertion = this.bfmgr.not(candidateAssertion);
        program = this.bfmgr.and(program, violationAssertion);
        pCexProver.push(program);
        this.logger.log(Level.INFO, new Object[]{"Starting satisfiability check..."});
        this.stats.satCheck.start();
        boolean safe = pCexProver.isUnsat();
        this.stats.satCheck.stop();
        if (!safe && violatedCandidate == TargetLocationCandidateInvariant.INSTANCE) {
            this.analyzeCounterexample(program, reached, pCexProver);
        } else if (safe && pBmcReachedSet.getCurrentMaxK() <= k) {
            violatedCandidate.assumeTruth(reached);
        }
        pCexProver.pop();
        return safe;
    }

    private boolean boundedModelCheck(UnrolledReachedSet pReachedSet, ProverEnvironmentWithFallback pProver, CandidateInvariant pInductionProblem) throws CPATransferException, InterruptedException, SolverException {
        ReachedSet reached = pReachedSet.getReachedSet();
        BooleanFormula program = this.bfmgr.not(pInductionProblem.getAssertion(reached, this.fmgr, this.pmgr));
        this.logger.log(Level.INFO, new Object[]{"Starting satisfiability check..."});
        this.stats.satCheck.start();
        pProver.push(program);
        boolean safe = pProver.isUnsat();
        this.stats.satCheck.stop();
        if (safe) {
            pInductionProblem.assumeTruth(reached);
        } else if (pInductionProblem == TargetLocationCandidateInvariant.INSTANCE) {
            this.analyzeCounterexample(program, reached, pProver);
        }
        pProver.pop();
        return safe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeCounterexample(BooleanFormula pCounterexampleFormula, ReachedSet pReachedSet, ProverEnvironmentWithFallback pProver) throws CPATransferException, InterruptedException {
        if (!(this.cpa instanceof ARGCPA)) {
            this.logger.log(Level.INFO, new Object[]{"Error found, but error path cannot be created without ARGCPA"});
            return;
        }
        this.stats.errorPathCreation.start();
        Solver cexAnalysisSolver = this.solver;
        PathFormulaManager cexAnalysisPmgr = this.pmgr;
        try {
            PathChecker pathChecker;
            ARGPath targetPath;
            this.logger.log(Level.INFO, new Object[]{"Error found, creating error path"});
            ImmutableSet targetStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates::isTargetState).filter(ARGState.class).toSet();
            Set<ARGState> redundantStates = BMCHelper.filterAncestors((Iterable<ARGState>)targetStates, AbstractStates::isTargetState);
            redundantStates.forEach(state -> state.removeFromARG());
            pReachedSet.removeAll(redundantStates);
            try {
                Model model;
                block24: {
                    model = pProver.getModel();
                    ARGState root222222 = (ARGState)pReachedSet.getFirstState();
                    try {
                        targetPath = this.pmgr.getARGPathFromModel(model, root222222);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not create error path");
                        if (model != null) {
                            model.close();
                        }
                        this.stats.errorPathCreation.stop();
                        if (cexAnalysisSolver == this.solver) return;
                        cexAnalysisSolver.close();
                        return;
                    }
                    if (targetPath.getLastState().isTarget()) break block24;
                    this.logger.log(Level.WARNING, new Object[]{"Could not create error path: path ends without target state!"});
                    if (model == null) return;
                    {
                        catch (Throwable root222222) {
                            if (model == null) throw root222222;
                            try {
                                model.close();
                                throw root222222;
                            }
                            catch (Throwable e) {
                                root222222.addSuppressed(e);
                            }
                            throw root222222;
                        }
                    }
                    model.close();
                    return;
                }
                if (model != null) {
                    model.close();
                }
            }
            catch (SolverException e) {
                this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, cannot create error path."});
                this.logger.logDebugException((Throwable)e);
                return;
            }
            BooleanFormula cexFormula = pCounterexampleFormula;
            try {
                if (cexAnalysisSolver.getVersion().toLowerCase().contains("smtinterpol")) {
                    cexAnalysisSolver = Solver.create(this.config, this.logger, this.shutdownNotifier);
                    FormulaManagerView formulaManager = cexAnalysisSolver.getFormulaManager();
                    cexAnalysisPmgr = new PathFormulaManagerImpl(formulaManager, this.config, this.logger, this.shutdownNotifier, this.cfa, AnalysisDirection.FORWARD);
                    cexFormula = cexAnalysisSolver.getFormulaManager().getBooleanFormulaManager().makeTrue();
                }
                pathChecker = new PathChecker(this.config, this.logger, cexAnalysisPmgr, cexAnalysisSolver, this.assignmentToPathAllocator);
            }
            catch (InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path to get a more precise model");
                this.stats.errorPathCreation.stop();
                if (cexAnalysisSolver == this.solver) return;
                cexAnalysisSolver.close();
                return;
            }
            CounterexampleTraceInfo cexInfo = CounterexampleTraceInfo.feasible((List<BooleanFormula>)ImmutableList.of((Object)cexFormula), targetPath);
            CounterexampleInfo counterexample = pathChecker.handleFeasibleCounterexample(cexInfo, targetPath);
            counterexample.getTargetState().addCounterexampleInformation(counterexample);
            return;
        }
        finally {
            this.stats.errorPathCreation.stop();
            if (cexAnalysisSolver != this.solver) {
                cexAnalysisSolver.close();
            }
        }
    }

    private CandidateGenerator getCandidateInvariants() {
        if (this.getTargetLocations().isEmpty() || !this.cfa.getAllLoopHeads().isPresent()) {
            return CandidateGenerator.EMPTY_GENERATOR;
        }
        return new StaticCandidateProvider(Collections.singleton(TargetLocationCandidateInvariant.INSTANCE));
    }

    private static class DetectingLiftingAbstractionFailureStrategy
    implements AbstractionBasedLifting.LiftingAbstractionFailureStrategy {
        private final boolean eager;
        private final Map<SymbolicCandiateInvariant, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity> spuriousAbstractions = new HashMap<SymbolicCandiateInvariant, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity>();

        public DetectingLiftingAbstractionFailureStrategy(boolean pEager) {
            this.eager = pEager;
        }

        @Override
        public SymbolicCandiateInvariant handleLAF(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, SymbolicCandiateInvariant pBlockedAbstractCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds, AbstractionStrategy pAbstractionStrategy) throws CPATransferException, InterruptedException, SolverException {
            if (this.eager) {
                return AbstractionBasedLifting.RefinementLAFStrategies.EAGER.handleLAF(pFMGR, pPam, pProver, pBlockedConcreteCti, pBlockedAbstractCti, pAssertPredecessor, pAssertionIds, pAbstractionStrategy);
            }
            this.spuriousAbstractions.put(pBlockedAbstractCti, pBlockedConcreteCti);
            return pBlockedAbstractCti;
        }

        Optional<SymbolicCandiateInvariant> getBlockedConcreteCtiForSpuriousAbstraction(SymbolicCandiateInvariant pBlockedAbstractCti) {
            return Optional.ofNullable((SymbolicCandiateInvariant)this.spuriousAbstractions.get(pBlockedAbstractCti));
        }
    }

    private static enum ConditionAdjustmentCriterion {
        NEVER{

            @Override
            boolean shouldAdjustConditions() {
                return false;
            }
        }
        ,
        ALWAYS{

            @Override
            boolean shouldAdjustConditions() {
                return true;
            }
        };


        abstract boolean shouldAdjustConditions();
    }

    static enum InvariantStrengtheningStrategies {
        NO_STRENGTHENING{

            @Override
            InvariantStrengthening<SymbolicCandiateInvariant, SymbolicCandiateInvariant> createRefinementStrategy(AbstractionStrategy pAbstractionStrategy) {
                return InvariantStrengthenings.noStrengthening();
            }
        }
        ,
        UNSAT_CORE_BASED_STRENGTHENING{

            @Override
            InvariantStrengthening<SymbolicCandiateInvariant, SymbolicCandiateInvariant> createRefinementStrategy(AbstractionStrategy pAbstractionStrategy) {
                return InvariantStrengthenings.unsatCoreBasedStrengthening();
            }
        };


        abstract InvariantStrengthening<SymbolicCandiateInvariant, SymbolicCandiateInvariant> createRefinementStrategy(AbstractionStrategy var1);
    }

    private static enum AbstractionStrategyFactories {
        NO_ABSTRACTION{

            @Override
            AbstractionStrategy createAbstractionStrategy(Optional<VariableClassification> pVariableClassification) {
                return AbstractionStrategy.NoAbstraction.INSTANCE;
            }

            @Override
            Set<SolverContext.ProverOptions> getRequiredProverOptions() {
                return EnumSet.noneOf(SolverContext.ProverOptions.class);
            }
        }
        ,
        ALLSAT_BASED_PREDICATE_ABSTRACTION{

            @Override
            AbstractionStrategy createAbstractionStrategy(Optional<VariableClassification> pVariableClassification) {
                return new PredicateAbstractionStrategy(pVariableClassification);
            }

            @Override
            Set<SolverContext.ProverOptions> getRequiredProverOptions() {
                return EnumSet.of(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            }
        };


        abstract AbstractionStrategy createAbstractionStrategy(Optional<VariableClassification> var1);

        abstract Set<SolverContext.ProverOptions> getRequiredProverOptions();
    }

    private static enum LiftingStrategyFactories {
        NO_LIFTING{

            @Override
            Lifting createLifting(AbstractionStrategy pAbstractionStrategy, AbstractionBasedLifting.LiftingAbstractionFailureStrategy pLAFStrategy) {
                return StandardLiftings.NO_LIFTING;
            }

            @Override
            Set<SolverContext.ProverOptions> getRequiredProverOptions() {
                return EnumSet.noneOf(SolverContext.ProverOptions.class);
            }
        }
        ,
        UNSAT_CORE_BASED_LIFTING{

            @Override
            Lifting createLifting(AbstractionStrategy pAbstractionStrategy, AbstractionBasedLifting.LiftingAbstractionFailureStrategy pLAFStrategy) {
                return StandardLiftings.UNSAT_BASED_LIFTING;
            }

            @Override
            Set<SolverContext.ProverOptions> getRequiredProverOptions() {
                return EnumSet.of(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            }
        }
        ,
        ABSTRACTION_BASED_LIFTING{

            @Override
            Lifting createLifting(AbstractionStrategy pAbstractionStrategy, AbstractionBasedLifting.LiftingAbstractionFailureStrategy pLAFStrategy) {
                return new AbstractionBasedLifting(pAbstractionStrategy, pLAFStrategy);
            }

            @Override
            Set<SolverContext.ProverOptions> getRequiredProverOptions() {
                return EnumSet.of(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            }
        };


        abstract Lifting createLifting(AbstractionStrategy var1, AbstractionBasedLifting.LiftingAbstractionFailureStrategy var2);

        abstract Set<SolverContext.ProverOptions> getRequiredProverOptions();
    }

    @Options(prefix="pdr")
    protected static class BasicPdrOptions {
        @Option(secure=true, description="Maximum number of accepted spurious transitions within a proof-obligation trace before a consecution abstraction failure triggers a refinement.")
        private int spuriousTransitionCountThreshold = 0;
        @Option(secure=true, description="Maximum number of ignored lifting abstraction failures within a proof-obligation trace.")
        private int liftingAbstractionFailureThreshold = 0;
        @Option(secure=true, description="Which strategy to use to abstract counterexamples to inductivity.")
        private LiftingStrategyFactories liftingStrategy = LiftingStrategyFactories.NO_LIFTING;
        @Option(secure=true, name="abstractionStrategy", description="Which strategy to use to perform abstraction of successful proof results or when lifting with the lifting strategy ABSTRACTION_BASED_LIFTING.")
        private AbstractionStrategyFactories abstractionStrategyFactory = AbstractionStrategyFactories.NO_ABSTRACTION;
        @Option(secure=true, name="invariantRefinementStrategy", description="Which strategy to use to perform invariant refinement on successful proof results.")
        private InvariantStrengtheningStrategies invariantRefinementStrategy = InvariantStrengtheningStrategies.NO_STRENGTHENING;
        @Option(secure=true, description="Whether to adjust conditions (i.e. increment k) after frontier extension.")
        private ConditionAdjustmentCriterion conditionAdjustmentCriterion = ConditionAdjustmentCriterion.NEVER;

        private BasicPdrOptions(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        public int getSpuriousTransitionCountThreshold() {
            return this.spuriousTransitionCountThreshold;
        }

        public int getLiftingAbstractionFailureThreshold() {
            return this.liftingAbstractionFailureThreshold;
        }

        public LiftingStrategyFactories getLiftingStrategy() {
            return this.liftingStrategy;
        }

        public AbstractionStrategyFactories getAbstractionStrategyFactory() {
            return this.abstractionStrategyFactory;
        }

        public InvariantStrengtheningStrategies getInvariantRefinementStrategy() {
            return this.invariantRefinementStrategy;
        }

        public ConditionAdjustmentCriterion getConditionAdjustmentCriterion() {
            return this.conditionAdjustmentCriterion;
        }
    }

    private static class PdrStatistics
    implements Statistics {
        private final Timer satCheck = new Timer();
        private final Timer errorPathCreation = new Timer();

        private PdrStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (this.satCheck.getNumberOfIntervals() > 0) {
                pOut.println("Time for final sat check:            " + this.satCheck);
            }
            if (this.errorPathCreation.getNumberOfIntervals() > 0) {
                pOut.println("Time for error path creation:        " + this.errorPathCreation);
            }
        }

        @Override
        public @Nullable String getName() {
            return "PDR algorithm";
        }
    }
}

