/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.pdr;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;

abstract class ProofObligation
implements Iterable<ProofObligation>,
Comparable<ProofObligation> {
    private final SymbolicCandiateInvariant blockedAbstractCti;
    private final Optional<SymbolicCandiateInvariant> blockedConcreteCti;
    private final int frameIndex;
    private final int nSpuriousTransitions;
    private final int length;

    private ProofObligation(SymbolicCandiateInvariant pAbstractBlockingClause, Optional<SymbolicCandiateInvariant> pConcreteBlockingClause, int pFrameIndex, int pNSpuriousTransitions, int pLength) {
        this.blockedAbstractCti = Objects.requireNonNull(pAbstractBlockingClause);
        this.blockedConcreteCti = Objects.requireNonNull(pConcreteBlockingClause);
        Preconditions.checkArgument((pFrameIndex >= 0 ? 1 : 0) != 0, (String)"Frame index must not be negative, but is %s", (int)pFrameIndex);
        this.frameIndex = pFrameIndex;
        Preconditions.checkArgument((pNSpuriousTransitions >= 0 ? 1 : 0) != 0, (String)"Number of spurious transitions must not be negative, but is %s", (int)pNSpuriousTransitions);
        this.nSpuriousTransitions = pNSpuriousTransitions;
        Preconditions.checkArgument((pLength >= 1 ? 1 : 0) != 0, (String)"Length must be positive but is %s", (int)pLength);
        this.length = pLength;
    }

    public SymbolicCandiateInvariant getBlockedAbstractCti() {
        return this.blockedAbstractCti;
    }

    public Optional<SymbolicCandiateInvariant> getBlockedConcreteCti() {
        return this.blockedConcreteCti;
    }

    @Override
    public int compareTo(ProofObligation pOther) {
        ComparisonChain compChain = ComparisonChain.start().compare(this.getFrameIndex(), pOther.frameIndex).compareFalseFirst(this.getCause().isPresent(), pOther.getCause().isPresent());
        if (this.getCause().isPresent()) {
            compChain = compChain.compare((Comparable)this.getCause().orElseThrow(), (Comparable)pOther.getCause().orElseThrow());
        }
        return compChain.compare(this.getNSpuriousTransitions(), pOther.getNSpuriousTransitions()).compare(this.getLiftingAbstractionFailureCount(), pOther.getLiftingAbstractionFailureCount()).result();
    }

    public abstract Optional<ProofObligation> getCause();

    public abstract CandidateInvariant getViolatedInvariant();

    public abstract ProofObligation incrementFrameIndex();

    public abstract int getLiftingAbstractionFailureCount();

    public abstract Optional<ProofObligation> find(Predicate<? super ProofObligation> var1);

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getNSpuriousTransitions() {
        return this.nSpuriousTransitions;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof ProofObligation) {
            ProofObligation other = (ProofObligation)pOther;
            return this.frameIndex == other.frameIndex && this.nSpuriousTransitions == other.nSpuriousTransitions && this.blockedConcreteCti.equals(other.blockedConcreteCti) && this.blockedAbstractCti.equals(other.blockedAbstractCti) && this.length == other.length && this.getViolatedInvariant().equals(other.getViolatedInvariant());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.frameIndex, this.nSpuriousTransitions, this.blockedConcreteCti, this.blockedAbstractCti, this.length, this.getViolatedInvariant());
    }

    public String toString() {
        return String.format("(%s, [%s], %d, %d)", this.blockedAbstractCti, this.blockedConcreteCti.isPresent() ? this.blockedConcreteCti.toString() : "", this.frameIndex, this.nSpuriousTransitions);
    }

    public abstract ProofObligation addSpuriousTransition();

    public ProofObligation causeProofObligation(SymbolicCandiateInvariant pBlockedAbstractCti, Optional<SymbolicCandiateInvariant> pBlockedConcreteCti, int pNSpuriousTransitions, int pLength) {
        return new NonLeafProofObligation(pBlockedAbstractCti, pBlockedConcreteCti, pNSpuriousTransitions, pLength, this);
    }

    public static ProofObligation createObligation(SymbolicCandiateInvariant pBlockedAbstractCti, Optional<SymbolicCandiateInvariant> pBlockedConcreteCti, int pFrameIndex, int pNSpuriousTransitions, int pLength, CandidateInvariant pViolatedInvariant) {
        return new LeafProofObligation(pBlockedAbstractCti, pBlockedConcreteCti, pFrameIndex, pNSpuriousTransitions, pLength, pViolatedInvariant);
    }

    private static class LeafProofObligation
    extends ProofObligation {
        private final CandidateInvariant violatedInvariant;

        private LeafProofObligation(SymbolicCandiateInvariant pBlockedAbstractCti, Optional<SymbolicCandiateInvariant> pBlockedConcreteCti, int pFrameIndex, int pNSpuriousTransitions, int pLength, CandidateInvariant pViolatedInvariant) {
            super(pBlockedAbstractCti, pBlockedConcreteCti, pFrameIndex, pNSpuriousTransitions, pLength);
            this.violatedInvariant = Objects.requireNonNull(pViolatedInvariant);
        }

        @Override
        public Optional<ProofObligation> getCause() {
            return Optional.empty();
        }

        @Override
        public CandidateInvariant getViolatedInvariant() {
            return this.violatedInvariant;
        }

        @Override
        public ProofObligation addSpuriousTransition() {
            return new LeafProofObligation(this.getBlockedAbstractCti(), this.getBlockedConcreteCti(), this.getFrameIndex(), this.getNSpuriousTransitions() + 1, this.getLength(), this.violatedInvariant);
        }

        @Override
        public ProofObligation incrementFrameIndex() {
            return new LeafProofObligation(this.getBlockedAbstractCti(), this.getBlockedConcreteCti(), this.getFrameIndex() + 1, this.getNSpuriousTransitions(), this.getLength(), this.getViolatedInvariant());
        }

        @Override
        public int getLiftingAbstractionFailureCount() {
            return this.getBlockedConcreteCti().isPresent() ? 1 : 0;
        }

        @Override
        public Iterator<ProofObligation> iterator() {
            return Iterators.singletonIterator((Object)this);
        }

        @Override
        public Optional<ProofObligation> find(Predicate<? super ProofObligation> pFilter) {
            if (pFilter.test(this)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }

    private static class NonLeafProofObligation
    extends ProofObligation {
        private final ProofObligation cause;

        private NonLeafProofObligation(SymbolicCandiateInvariant pAbstractBlockingClause, Optional<SymbolicCandiateInvariant> pConcreteBlockingClause, int pNSpuriousTransitions, int pLength, ProofObligation pCause) {
            super(pAbstractBlockingClause, pConcreteBlockingClause, pCause.getFrameIndex() - 1, pNSpuriousTransitions, pLength);
            this.cause = Objects.requireNonNull(pCause);
        }

        @Override
        public Optional<ProofObligation> getCause() {
            return Optional.of(this.cause);
        }

        @Override
        public CandidateInvariant getViolatedInvariant() {
            return ((ProofObligation)this.aggregateOverTrace(Function.identity(), (a, b) -> b)).getViolatedInvariant();
        }

        @Override
        public int getLiftingAbstractionFailureCount() {
            return this.aggregateOverTrace(o -> o.getBlockedConcreteCti().isPresent() ? 1 : 0, Integer::sum);
        }

        private <T> T aggregateOverTrace(Function<ProofObligation, T> pMap, BinaryOperator<T> pAccumulator) {
            ProofObligation current = this;
            Object accumulated = pMap.apply(current);
            while (((ProofObligation)current).getCause().isPresent()) {
                current = ((ProofObligation)current).getCause().orElseThrow();
                accumulated = pAccumulator.apply(accumulated, pMap.apply(current));
            }
            return accumulated;
        }

        @Override
        public Iterator<ProofObligation> iterator() {
            return new Iterator<ProofObligation>(){
                private Optional<ProofObligation> current;
                {
                    this.current = Optional.of(this);
                }

                @Override
                public boolean hasNext() {
                    return this.current.isPresent();
                }

                @Override
                public ProofObligation next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ProofObligation result = this.current.orElseThrow();
                    this.current = result.getCause();
                    return result;
                }
            };
        }

        @Override
        public ProofObligation addSpuriousTransition() {
            return new NonLeafProofObligation(this.getBlockedAbstractCti(), this.getBlockedConcreteCti(), this.getNSpuriousTransitions() + 1, this.getLength(), this.cause);
        }

        @Override
        public ProofObligation incrementFrameIndex() {
            return new NonLeafProofObligation(this.getBlockedAbstractCti(), this.getBlockedConcreteCti(), this.getNSpuriousTransitions(), this.getLength(), this.cause.incrementFrameIndex());
        }

        @Override
        public Optional<ProofObligation> find(Predicate<? super ProofObligation> pFilter) {
            return StreamSupport.stream(this.spliterator(), false).filter(pFilter).findFirst();
        }
    }
}

