/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.pdr;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.PartialTransitionRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;

public class TotalTransitionRelation {
    private static final String LOCATION_VARIABLE_NAME = "__CPAchecker_location";
    private final Map<Integer, PartialTransitionRelation> totalTransitionRelation = new TreeMap<Integer, PartialTransitionRelation>();
    private final Set<CFANode> predecessorLocations;
    private final CFANode initialLocation;
    private final FormulaManagerView fmgr;

    public TotalTransitionRelation(FormulaManagerView pFmgr, CFANode pInitialLocation, Iterator<CFANode> pLoopHeadIterator, Function<CFANode, PartialTransitionRelation> pCreatePartialTransitionRelation) {
        this.fmgr = Objects.requireNonNull(pFmgr);
        this.initialLocation = Objects.requireNonNull(pInitialLocation);
        this.totalTransitionRelation.put(pInitialLocation.getNodeNumber(), (PartialTransitionRelation)pCreatePartialTransitionRelation.apply((Object)pInitialLocation));
        while (pLoopHeadIterator.hasNext()) {
            CFANode predecessorLocation = pLoopHeadIterator.next();
            PartialTransitionRelation partialTransitionRelation = (PartialTransitionRelation)pCreatePartialTransitionRelation.apply((Object)predecessorLocation);
            this.totalTransitionRelation.put(predecessorLocation.getNodeNumber(), partialTransitionRelation);
        }
        this.predecessorLocations = Collections3.transformedImmutableSetCopy(this.totalTransitionRelation.values(), PartialTransitionRelation::getStartLocation);
    }

    public CFANode getInitialLocation() {
        return this.initialLocation;
    }

    public PartialTransitionRelation getInitiationRelation() {
        return this.totalTransitionRelation.get(this.initialLocation.getNodeNumber());
    }

    public Set<CFANode> getPredecessorLocations() {
        return this.predecessorLocations;
    }

    public FluentIterable<AbstractState> getPredecessorStates() {
        return FluentIterable.from(this.totalTransitionRelation.values()).transformAndConcat(partialTransitionRelation -> {
            ReachedSet reached = partialTransitionRelation.getReachedSet().getReachedSet();
            if (reached.size() <= 1) {
                return reached;
            }
            return Collections.singleton(reached.getFirstState());
        });
    }

    public Algorithm.AlgorithmStatus ensureK() throws InterruptedException, CPAException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        for (PartialTransitionRelation partialTransitionRelation : this.totalTransitionRelation.values()) {
            Algorithm.AlgorithmStatus partialStatus = partialTransitionRelation.ensureK();
            if (!partialTransitionRelation.getStartLocation().equals(this.initialLocation)) continue;
            status = partialStatus;
        }
        return status;
    }

    public BooleanFormula getTransitionFormula() {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        BooleanFormula transitionFormula = bfmgr.makeTrue();
        for (PartialTransitionRelation partialTransitionRelation : this.totalTransitionRelation.values()) {
            transitionFormula = bfmgr.and(transitionFormula, bfmgr.implication(partialTransitionRelation.getStartLocationFormula(), partialTransitionRelation.getFormula()));
        }
        return transitionFormula;
    }

    public BooleanFormula getPredecessorAssertion(CandidateInvariant pCandidateInvariant) throws CPATransferException, InterruptedException {
        return this.getPredecessorAssertions(Collections.singleton(pCandidateInvariant));
    }

    public BooleanFormula getPredecessorAssertions(Iterable<CandidateInvariant> pPredecessorAssertions) throws CPATransferException, InterruptedException {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        BooleanFormula assertions = bfmgr.makeTrue();
        for (PartialTransitionRelation partialTransitionRelation : this.totalTransitionRelation.values()) {
            assertions = bfmgr.and(assertions, partialTransitionRelation.getPredecessorAssertions(pPredecessorAssertions));
        }
        return assertions;
    }

    public BooleanFormula getSuccessorAssertion(CandidateInvariant pCandidateInvariant) throws CPATransferException, InterruptedException {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        BooleanFormula assertions = bfmgr.makeTrue();
        for (PartialTransitionRelation partialTransitionRelation : this.totalTransitionRelation.values()) {
            assertions = bfmgr.and(assertions, partialTransitionRelation.getSuccessorAssertion(pCandidateInvariant));
        }
        return assertions;
    }

    public Multimap<BooleanFormula, BooleanFormula> getSuccessorViolationAssertions(CandidateInvariant pCandidateInvariant) throws CPATransferException, InterruptedException {
        HashMultimap successorViolationAssertions = HashMultimap.create();
        for (PartialTransitionRelation partialTransitionRelation : this.totalTransitionRelation.values()) {
            partialTransitionRelation.collectSuccessorViolationAssertions(pCandidateInvariant, (Multimap<BooleanFormula, BooleanFormula>)successorViolationAssertions);
        }
        return successorViolationAssertions;
    }

    public PartialTransitionRelation getViolatedPartialTransition(List<Model.ValueAssignment> pModelAssignments) {
        for (Model.ValueAssignment valueAssignment : pModelAssignments) {
            Object value;
            String fullName = valueAssignment.getName();
            Pair<String, OptionalInt> varNameWithIndex = FormulaManagerView.parseName(fullName);
            String varName = varNameWithIndex.getFirst();
            OptionalInt index = varNameWithIndex.getSecond();
            if (!index.isPresent() || index.orElseThrow() != 1 || !varName.equals(LOCATION_VARIABLE_NAME) || !((value = valueAssignment.getValue()) instanceof Number)) continue;
            PartialTransitionRelation result = this.totalTransitionRelation.get(((Number)value).intValue());
            Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Unknown location: %s", (Object)value);
            return result;
        }
        throw new IllegalArgumentException("No location information: " + pModelAssignments);
    }

    public Iterable<BooleanFormula> getPredecessorLocationFormulas() {
        return Iterables.transform(this.getPredecessorLocations(), l -> TotalTransitionRelation.getUnprimedLocationFormula(this.fmgr, l));
    }

    public SymbolicCandiateInvariant getInitiationAssertion() {
        return SymbolicCandiateInvariant.makeSymbolicInvariant(this.predecessorLocations, this.getCandidateInvariantStatePredicate(), this.fmgr.uninstantiate(this.getInitiationRelation().getStartLocationFormula()), this.fmgr);
    }

    public Predicate<? super AbstractState> getCandidateInvariantStatePredicate() {
        return s -> FluentIterable.from(AbstractStates.extractLocations(s)).stream().anyMatch(this.predecessorLocations::contains);
    }

    public static String getLocationVariableName() {
        return LOCATION_VARIABLE_NAME;
    }

    static BooleanFormula getUnprimedLocationFormula(FormulaManagerView pFmgr, CFANode pLocation) {
        IntegerFormulaManagerView ifmgr = pFmgr.getIntegerFormulaManager();
        NumeralFormula.IntegerFormula variable = (NumeralFormula.IntegerFormula)pFmgr.makeVariable(ifmgr.getFormulaType(), TotalTransitionRelation.getLocationVariableName(), 1);
        return ifmgr.equal((NumeralFormula)variable, (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(pLocation.getNodeNumber())));
    }

    static BooleanFormula getPrimedLocationFormula(FormulaManagerView pFmgr, CFANode pLocation) {
        IntegerFormulaManagerView ifmgr = pFmgr.getIntegerFormulaManager();
        NumeralFormula.IntegerFormula variable = (NumeralFormula.IntegerFormula)pFmgr.makeVariable(ifmgr.getFormulaType(), TotalTransitionRelation.getLocationVariableName(), 2);
        return ifmgr.equal((NumeralFormula)variable, (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(pLocation.getNodeNumber())));
    }

    static String getVariableName(FormulaManagerView pFmgr, Formula pVariable) {
        Set<String> variableNames = pFmgr.extractVariableNames(pVariable);
        Preconditions.checkArgument((variableNames.size() == 1 ? 1 : 0) != 0, (String)"Not a variable: %s", (Object)pVariable);
        return variableNames.iterator().next();
    }
}

