/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.composition;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmContext;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.CPAs;

public abstract class AlgorithmCompositionStrategy {
    protected LogManager logger;
    protected ImmutableList<AlgorithmContext> algorithmContexts;

    protected AlgorithmCompositionStrategy(LogManager pLogger) {
        this.logger = pLogger;
    }

    protected void initializeAlgorithmContexts(List<AnnotatedValue<Path>> pConfigFiles) {
        ImmutableList.Builder contextBuilder = ImmutableList.builder();
        for (AnnotatedValue<Path> configFile : pConfigFiles) {
            contextBuilder.add((Object)new AlgorithmContext(configFile));
        }
        this.algorithmContexts = contextBuilder.build();
    }

    public abstract boolean hasNextAlgorithm();

    public abstract AlgorithmContext getNextAlgorithm();

    public void finalCleanUp(AlgorithmContext pLastContextRun) {
        for (AlgorithmContext context : this.algorithmContexts) {
            if (context == pLastContextRun || context == null || context.getCPA() == null || !context.reuseCPA()) continue;
            CPAs.closeCpaIfPossible(context.getCPA(), this.logger);
        }
    }

    static interface Factory {
        public AlgorithmCompositionStrategy create(Configuration var1, LogManager var2, ShutdownNotifier var3, CFA var4, Specification var5) throws InvalidConfigurationException;
    }
}

