/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.composition;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;

public class AlgorithmContext {
    public static final int DEFAULT_TIME_LIMIT = 10;
    private final Path configFile;
    private int timeLimit;
    private final REPETITIONMODE mode;
    private final Timer timer;
    private @Nullable ConfigurableProgramAnalysis cpa;
    private @Nullable Configuration config;
    private ReachedSet reached;
    private double progress = -1.0;

    public AlgorithmContext(AnnotatedValue<Path> pConfigFile) {
        this.configFile = (Path)pConfigFile.value();
        this.timer = new Timer();
        this.timeLimit = this.extractLimitFromAnnotation(pConfigFile.annotation());
        this.mode = this.extractModeFromAnnotation(pConfigFile.annotation());
    }

    private int extractLimitFromAnnotation(Optional<String> annotation) {
        String str;
        if (annotation.isPresent() && (str = annotation.orElseThrow()).contains("_")) {
            try {
                int limit = Integer.parseInt(str.substring(str.indexOf("_") + 1));
                if (limit > 0) {
                    return limit;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 10;
    }

    private REPETITIONMODE extractModeFromAnnotation(Optional<String> annotation) {
        String val = "";
        if (annotation.isPresent()) {
            val = annotation.orElseThrow();
            if (val.contains("_")) {
                val = val.substring(0, val.indexOf("_"));
            }
            val = val.toLowerCase(Locale.ROOT);
        }
        switch (val) {
            case "continue": {
                return REPETITIONMODE.CONTINUE;
            }
            case "reuse-own-precision": {
                return REPETITIONMODE.REUSEOWNPRECISION;
            }
            case "reuse-pred-precision": {
                return REPETITIONMODE.REUSEPREDPRECISION;
            }
            case "reuse-precisions": {
                return REPETITIONMODE.REUSEOWNANDPREDPRECISION;
            }
            case "reuse-cpa-own-precision": {
                return REPETITIONMODE.REUSECPA_OWNPRECISION;
            }
            case "reuse-cpa-pred-precision": {
                return REPETITIONMODE.REUSECPA_PREDPRECISION;
            }
            case "reuse-cpa-precisions": {
                return REPETITIONMODE.REUSECPA_OWNANDPREDPRECISION;
            }
        }
        return REPETITIONMODE.NOREUSE;
    }

    public boolean reuseCPA() {
        return this.mode == REPETITIONMODE.CONTINUE || this.mode == REPETITIONMODE.REUSECPA_OWNPRECISION || this.mode == REPETITIONMODE.REUSECPA_PREDPRECISION || this.mode == REPETITIONMODE.REUSECPA_OWNANDPREDPRECISION;
    }

    public boolean reusePrecision() {
        return this.reuseOwnPrecision() || this.reusePredecessorPrecision();
    }

    public boolean reuseOwnPrecision() {
        return this.mode == REPETITIONMODE.REUSEOWNPRECISION || this.mode == REPETITIONMODE.REUSEOWNANDPREDPRECISION || this.mode == REPETITIONMODE.REUSECPA_OWNPRECISION || this.mode == REPETITIONMODE.REUSECPA_OWNANDPREDPRECISION;
    }

    public boolean reusePredecessorPrecision() {
        return this.mode == REPETITIONMODE.REUSEPREDPRECISION || this.mode == REPETITIONMODE.REUSEOWNANDPREDPRECISION || this.mode == REPETITIONMODE.REUSECPA_PREDPRECISION || this.mode == REPETITIONMODE.REUSECPA_OWNANDPREDPRECISION;
    }

    public void resetProgress() {
        this.progress = -1.0;
    }

    public void adaptTimeLimit(int newTimeLimit) {
        this.timeLimit = Math.max(10, newTimeLimit);
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setProgress(double pProgress) {
        this.progress = pProgress;
    }

    public double getProgress() {
        return this.progress;
    }

    public @Nullable Configuration getConfig() {
        return this.config;
    }

    public @Nullable Configuration getAndCreateConfigIfNecessary(Configuration pGlobalConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        if (this.config != null) {
            return this.config;
        }
        ConfigurationBuilder singleConfigBuilder = Configuration.builder();
        singleConfigBuilder.copyFrom(pGlobalConfig);
        singleConfigBuilder.clearOption("compositionAlgorithm.configFiles");
        singleConfigBuilder.clearOption("analysis.useCompositionAnalysis");
        try {
            singleConfigBuilder.loadFromFile(this.configFile);
            pLogger.logf(Level.INFO, "Loading analysis %s ...", new Object[]{this.configFile});
            this.config = singleConfigBuilder.build();
        }
        catch (InvalidConfigurationException e) {
            pLogger.logUserException(Level.WARNING, (Throwable)e, "Configuration file " + this.configFile + " is invalid");
        }
        catch (IOException e) {
            String message = "Failed to read " + this.configFile + ".";
            if (pShutdownNotifier.shouldShutdown() && e instanceof ClosedByInterruptException) {
                pLogger.log(Level.WARNING, new Object[]{message});
            }
            pLogger.logUserException(Level.WARNING, (Throwable)e, message);
        }
        return this.config;
    }

    public ReachedSet getReachedSet() {
        return this.reached;
    }

    public void setReachedSet(ReachedSet pReached) {
        this.reached = pReached;
    }

    public @Nullable ConfigurableProgramAnalysis getCPA() {
        return this.cpa;
    }

    public void setCPA(@Nullable ConfigurableProgramAnalysis pCpa) {
        this.cpa = pCpa;
    }

    public String configToString() {
        return this.configFile.toString();
    }

    public void startTimer() {
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    public TimeSpan getTotalTimeSpent() {
        return this.timer.getSumTime();
    }

    private static enum REPETITIONMODE {
        CONTINUE,
        NOREUSE,
        REUSEOWNPRECISION,
        REUSEPREDPRECISION,
        REUSEOWNANDPREDPRECISION,
        REUSECPA_OWNPRECISION,
        REUSECPA_PREDPRECISION,
        REUSECPA_OWNANDPREDPRECISION;

    }
}

