/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.composition;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmCompositionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmContext;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

@Options(prefix="compositionAlgorithm.circular")
public class CircularCompositionStrategy
extends AlgorithmCompositionStrategy
implements Statistics {
    @Option(secure=true, description="If adaptTimeLimits is set and all configurations support progress reports, in each cycle the time limits per configuration are newly calculated based on the progress")
    private boolean adaptTimeLimits = false;
    private int inCycleCount;
    private int noOfRounds;
    protected Iterator<AlgorithmContext> algorithmContextCycle;

    public CircularCompositionStrategy(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        super(pLogger);
        pConfig.inject((Object)this);
    }

    @Override
    protected void initializeAlgorithmContexts(List<AnnotatedValue<Path>> pConfigFiles) {
        super.initializeAlgorithmContexts(pConfigFiles);
        this.algorithmContextCycle = Iterables.cycle((Iterable)this.algorithmContexts).iterator();
        this.inCycleCount = 1;
        this.noOfRounds = 0;
    }

    private void computeAndSetNewTimeLimits() {
        long totalDistributableTimeBudget = 0L;
        double totalRelativeProgress = 0.0;
        boolean mayAdapt = true;
        for (AlgorithmContext context : this.algorithmContexts) {
            totalDistributableTimeBudget += (long)(context.getTimeLimit() - 10);
            totalRelativeProgress += context.getProgress() / (double)context.getTimeLimit();
            mayAdapt &= context.getProgress() >= 0.0;
        }
        if (totalDistributableTimeBudget <= (long)this.algorithmContexts.size() || totalRelativeProgress <= 0.0) {
            mayAdapt = false;
        }
        for (AlgorithmContext context : this.algorithmContexts) {
            if (!mayAdapt) continue;
            context.adaptTimeLimit(10 + (int)Math.round(context.getProgress() / (double)context.getTimeLimit() / totalRelativeProgress * (double)totalDistributableTimeBudget));
        }
    }

    @Override
    public boolean hasNextAlgorithm() {
        return this.algorithmContextCycle.hasNext();
    }

    @Override
    public AlgorithmContext getNextAlgorithm() {
        if (this.inCycleCount == this.algorithmContexts.size()) {
            this.inCycleCount = 0;
            ++this.noOfRounds;
            this.logger.log(Level.INFO, new Object[]{"Circular composition strategy starts next iteration..."});
            if (this.adaptTimeLimits) {
                this.computeAndSetNewTimeLimits();
            }
            for (AlgorithmContext tempContext : this.algorithmContexts) {
                tempContext.resetProgress();
            }
        }
        ++this.inCycleCount;
        return this.algorithmContextCycle.next();
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        pOut.println("Number of analyses per round: " + this.algorithmContexts.size());
        pOut.println("Number of completed rounds:  " + this.noOfRounds);
        pOut.println("Stopped in analysis:         " + this.inCycleCount);
        for (int i = 0; i < this.algorithmContexts.size(); ++i) {
            pOut.println("Time spent in analysis " + (i + 1) + ":    " + ((AlgorithmContext)this.algorithmContexts.get(i)).getTotalTimeSpent().asSeconds());
        }
    }

    @Override
    public @Nullable String getName() {
        return "Circular Composition";
    }
}

