/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.composition;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.management.JMException;
import javax.xml.transform.TransformerException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ProgressReportingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmCompositionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmCompositionStrategyBuilder;
import org.sosy_lab.cpachecker.core.algorithm.composition.AlgorithmContext;
import org.sosy_lab.cpachecker.core.defaults.precision.ConfigurablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.HistoryForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.FullConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.RefinableConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundPrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTimeLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.java_smt.api.Formula;

@Options(prefix="compositionAlgorithm")
public class CompositionAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, required=true, description="list of files with configurations to use, which are optionally suffixed according to one of the followig schemes:either ::MODE or ::MODE_LIMIT, where MODE and LIMIT are place holders.MODE may take one of the following values continue (i.e., continue analysis with same CPA and reached set), reuse-precision (i.e., reuse the aggregation of the precisions from the previous analysis run), noreuse (i.e., start from scratch).LIMIT is a positive integer number specifying the time limit of the analysis in each round.If no (correct) limit is given a default limit is used.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<AnnotatedValue<Path>> configFiles;
    @Option(secure=true, description="print the statistics of each component of the composition algorithm directly after the component's computation is finished")
    private INTERMEDIATESTATSOPT intermediateStatistics = INTERMEDIATESTATSOPT.NONE;
    @Option(secure=true, description="let each analysis part of the composition algorithm write output files and not only the last one that is executed")
    private boolean writeIntermediateOutputFiles = true;
    @Option(secure=true, name="initCondition", description="Whether or not to create an initial condition, that excludes no paths, before first analysis is run.Required when first analysis uses condition from conditional model checking")
    private boolean generateInitialFalseCondition = false;
    @Option(secure=true, name="propertyChecked", description="Enable when composition algorithm is used to check a specification")
    private boolean isPropertyChecked = true;
    @Option(secure=true, name="condition.file", description="where to store initial condition, when generated")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path initialCondition = Path.of("AssumptionAutomaton.txt", new String[0]);
    private AlgorithmCompositionStrategy selectionStrategy;
    private final CFA cfa;
    private final Configuration globalConfig;
    private final LogManager logger;
    private final ShutdownNotifier.ShutdownRequestListener logShutdownListener;
    private final ShutdownNotifier shutdownNotifier;
    private final Specification specification;
    private final CompositionAlgorithmStatistics stats;

    public CompositionAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        if (this.configFiles.isEmpty()) {
            throw new InvalidConfigurationException("Need at least one configuration for composition algorithm!");
        }
        this.cfa = pCfa;
        this.globalConfig = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.stats = new CompositionAlgorithmStatistics();
        this.selectionStrategy = AlgorithmCompositionStrategyBuilder.buildStrategy(pConfig, this.logger, this.shutdownNotifier, this.cfa, this.specification);
        this.logShutdownListener = reason -> this.logger.logf(Level.WARNING, "Shutdown of analysis run %d requested (%s).", new Object[]{this.stats.noOfRuns, reason});
        if (this.generateInitialFalseCondition) {
            this.generateInitialFalseCondition();
        }
    }

    private void generateInitialFalseCondition() {
        String condition = "OBSERVER AUTOMATON AssumptionAutomaton\n\nINITIAL STATE __FALSE;\n\nSTATE __FALSE :\n    TRUE -> GOTO __FALSE;\n\nEND AUTOMATON\n";
        try (Writer w = IO.openOutputFile((Path)this.initialCondition, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            w.write(condition);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write initial condition to file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReached) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReached instanceof ForwardingReachedSet), (Object)"CompositionAlgorithm needs ForwardingReachedSet");
        Preconditions.checkArgument((pReached.size() <= 1 ? 1 : 0) != 0, (Object)"CompositionAlgorithm does not support being called several times with the same reached set");
        Preconditions.checkArgument((!pReached.isEmpty() ? 1 : 0) != 0, (Object)"CompositionAlgorithm needs non-empty reached set");
        this.stats.totalTimer.start();
        try {
            Algorithm.AlgorithmStatus algorithmStatus;
            ForwardingReachedSet fReached = (ForwardingReachedSet)pReached;
            Iterable<CFANode> initialNodes = AbstractStates.extractLocations(pReached.getFirstState());
            CFANode mainFunction = (CFANode)Iterables.getOnlyElement(initialNodes);
            this.selectionStrategy.initializeAlgorithmContexts(this.configFiles);
            Algorithm.AlgorithmStatus status = this.isPropertyChecked ? Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE : Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
            AlgorithmContext previousContext = null;
            AlgorithmContext currentContext = null;
            while (!this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                block60: {
                    Pair<Algorithm, ShutdownManager> currentRun;
                    boolean analysisFinishedWithResult;
                    block58: {
                        block59: {
                            block56: {
                                block57: {
                                    block54: {
                                        block55: {
                                            block52: {
                                                block53: {
                                                    analysisFinishedWithResult = false;
                                                    currentRun = null;
                                                    previousContext = currentContext;
                                                    currentContext = this.selectionStrategy.getNextAlgorithm();
                                                    currentContext.resetProgress();
                                                    Preconditions.checkState((currentContext != null ? 1 : 0) != 0, (Object)"Retrieved invalid algorithm context.");
                                                    currentContext.startTimer();
                                                    ++this.stats.noOfRuns;
                                                    Configuration currentConfig = currentContext.getAndCreateConfigIfNecessary(this.globalConfig, this.logger, this.shutdownNotifier);
                                                    if (currentConfig != null) break block52;
                                                    this.logger.log(Level.WARNING, new Object[]{"Skip current analysis because no configuration is available."});
                                                    if (currentRun == null) break block53;
                                                    this.tidyUpShutdownManager(currentRun.getSecond());
                                                    if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                                        this.printIntermediateStatistics(pReached, currentContext);
                                                        if (!currentContext.reuseCPA()) {
                                                            CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                                        }
                                                        if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                                            currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                                        }
                                                        CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                                                    }
                                                }
                                                currentContext.stopTimer();
                                                continue;
                                            }
                                            currentRun = this.createNextAlgorithm(currentContext, mainFunction, previousContext);
                                            if (currentRun != null) break block54;
                                            this.logger.log(Level.WARNING, new Object[]{"Skip current analysis because analysis could not be set up."});
                                            if (currentRun == null) break block55;
                                            this.tidyUpShutdownManager(currentRun.getSecond());
                                            if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                                this.printIntermediateStatistics(pReached, currentContext);
                                                if (!currentContext.reuseCPA()) {
                                                    CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                                }
                                                if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                                    currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                                }
                                                CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                                            }
                                        }
                                        currentContext.stopTimer();
                                        continue;
                                    }
                                    if (fReached instanceof HistoryForwardingReachedSet) {
                                        ((HistoryForwardingReachedSet)fReached).saveCPA(currentContext.getCPA());
                                    }
                                    fReached.setDelegate(currentContext.getReachedSet());
                                    this.shutdownNotifier.shutdownIfNecessary();
                                    this.logger.logf(Level.INFO, "Starting component analysis %s in run %d ...", new Object[]{currentContext.configToString(), this.stats.noOfRuns});
                                    status = currentRun.getFirst().run(currentContext.getReachedSet());
                                    if (status.wasPropertyChecked() != this.isPropertyChecked) {
                                        this.logger.logf(Level.WARNING, "Component algorithm and composition algorithm do not agree on property checking (%b, %b).", new Object[]{status.wasPropertyChecked(), this.isPropertyChecked});
                                    }
                                    if (!FluentIterable.from((Iterable)currentContext.getReachedSet()).anyMatch(AbstractStates::isTargetState) || !status.isPrecise()) break block56;
                                    analysisFinishedWithResult = true;
                                    algorithmStatus = status;
                                    if (currentRun == null) break block57;
                                    this.tidyUpShutdownManager(currentRun.getSecond());
                                    if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                        this.printIntermediateStatistics(pReached, currentContext);
                                        if (!currentContext.reuseCPA()) {
                                            CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                        }
                                        if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                            currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                        }
                                        CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                                    }
                                }
                                currentContext.stopTimer();
                                return algorithmStatus;
                            }
                            if (status.wasPropertyChecked() && !status.isSound()) {
                                this.logger.logf(Level.FINE, "Analysis %s in run %d terminated, but result is unsound.", new Object[]{currentContext.configToString(), this.stats.noOfRuns});
                                break block58;
                            }
                            if (currentContext.getReachedSet().hasWaitingState()) {
                                this.logger.logf(Level.FINE, "Analysis %s in run %d terminated but did not finish: There are still states to be processed.", new Object[]{currentContext.configToString(), this.stats.noOfRuns});
                                break block58;
                            }
                            if (FluentIterable.from((Iterable)currentContext.getReachedSet()).anyMatch(AbstractStates::isTargetState) && !status.isPrecise()) break block58;
                            analysisFinishedWithResult = true;
                            algorithmStatus = status;
                            if (currentRun == null) break block59;
                            this.tidyUpShutdownManager(currentRun.getSecond());
                            if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                this.printIntermediateStatistics(pReached, currentContext);
                                if (!currentContext.reuseCPA()) {
                                    CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                }
                                if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                    currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                }
                                CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                            }
                        }
                        currentContext.stopTimer();
                        return algorithmStatus;
                    }
                    try {
                        this.shutdownNotifier.shutdownIfNecessary();
                        if (currentRun == null) break block60;
                        this.tidyUpShutdownManager(currentRun.getSecond());
                    }
                    catch (CPAException e) {
                        block61: {
                            if (e instanceof CounterexampleAnalysisFailed || e instanceof RefinementFailedException) {
                                status = status.withPrecise(false);
                            }
                            this.logger.logUserException(Level.WARNING, (Throwable)e, "Analysis " + currentContext.configToString() + "in run " + this.stats.noOfRuns + " not completed.");
                            if (currentRun == null) break block61;
                            this.tidyUpShutdownManager(currentRun.getSecond());
                            if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                this.printIntermediateStatistics(pReached, currentContext);
                                if (!currentContext.reuseCPA()) {
                                    CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                }
                                if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                    currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                }
                                CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                            }
                        }
                        currentContext.stopTimer();
                        continue;
                    }
                    catch (InterruptedException e2) {
                        block62: {
                            this.logger.logUserException(Level.FINE, (Throwable)e2, "Analysis " + currentContext.configToString() + "in run " + this.stats.noOfRuns + " stopped.");
                            this.shutdownNotifier.shutdownIfNecessary();
                            if (currentRun == null) break block62;
                            this.tidyUpShutdownManager(currentRun.getSecond());
                            {
                                catch (Throwable throwable) {
                                    if (currentRun != null) {
                                        this.tidyUpShutdownManager((ShutdownManager)currentRun.getSecond());
                                        if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                            this.printIntermediateStatistics(pReached, currentContext);
                                            if (!currentContext.reuseCPA()) {
                                                CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                            }
                                            if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                                currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                            }
                                            CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                                        }
                                    }
                                    currentContext.stopTimer();
                                    throw throwable;
                                }
                            }
                            if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                                this.printIntermediateStatistics(pReached, currentContext);
                                if (!currentContext.reuseCPA()) {
                                    CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                                }
                                if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                                    currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                                }
                                CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                            }
                        }
                        currentContext.stopTimer();
                        continue;
                    }
                    if (!analysisFinishedWithResult && !this.shutdownNotifier.shouldShutdown() && this.selectionStrategy.hasNextAlgorithm()) {
                        this.printIntermediateStatistics(pReached, currentContext);
                        if (!currentContext.reuseCPA()) {
                            CPAs.closeCpaIfPossible(currentContext.getCPA(), this.logger);
                        }
                        if (currentRun.getFirst() instanceof ProgressReportingAlgorithm) {
                            currentContext.setProgress(((ProgressReportingAlgorithm)currentRun.getFirst()).getProgress());
                        }
                        CPAs.closeIfPossible(currentRun.getFirst(), this.logger);
                    }
                }
                currentContext.stopTimer();
            }
            this.selectionStrategy.finalCleanUp(currentContext);
            this.logger.log(Level.INFO, new Object[]{"Shutdown of composition algorithm, analysis not finished yet."});
            algorithmStatus = status;
            return algorithmStatus;
        }
        catch (RuntimeException e2) {
            if (e2.getCause() instanceof TransformerException || e2 instanceof IllegalStateException) {
                Algorithm.AlgorithmStatus algorithmStatus;
                this.logger.logUserException(Level.FINE, (Throwable)e2, "Problem with one one the analysis, try to save result");
                if (this.isPropertyChecked) {
                    algorithmStatus = Algorithm.AlgorithmStatus.UNSOUND_AND_IMPRECISE;
                    return algorithmStatus;
                }
                algorithmStatus = Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
                return algorithmStatus;
            }
            throw e2;
        }
        finally {
            this.stats.totalTimer.stop();
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Encoding is irrelevant for null output stream")
    @SuppressForbidden(value="System.out is correct for statistics")
    private void printIntermediateStatistics(ReachedSet pReached, AlgorithmContext currentContext) {
        switch (this.intermediateStatistics) {
            case PRINT: {
                this.stats.printIntermediateStatistics(System.out, CPAcheckerResult.Result.UNKNOWN, currentContext.getReachedSet());
                break;
            }
            case EXECUTE: {
                PrintStream dummyStream = new PrintStream(ByteStreams.nullOutputStream());
                this.stats.printIntermediateStatistics(dummyStream, CPAcheckerResult.Result.UNKNOWN, currentContext.getReachedSet());
                break;
            }
        }
        if (this.writeIntermediateOutputFiles) {
            this.stats.writeOutputFiles(CPAcheckerResult.Result.UNKNOWN, pReached);
        }
        this.stats.resetSubStatistics();
    }

    private void tidyUpShutdownManager(ShutdownManager pShutdownManager) {
        pShutdownManager.getNotifier().unregister(this.logShutdownListener);
        pShutdownManager.requestShutdown("Analysis terminated.");
    }

    private @Nullable Pair<Algorithm, ShutdownManager> createNextAlgorithm(AlgorithmContext pCurrentContext, CFANode pMainFunction, AlgorithmContext pPreviousContext) {
        ShutdownManager localShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
        ArrayList<ResourceLimit> limits = new ArrayList<ResourceLimit>();
        try {
            limits.add(ProcessCpuTimeLimit.fromNowOn(TimeSpan.ofSeconds((long)pCurrentContext.getTimeLimit())));
        }
        catch (JMException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Your Java VM does not support measuring the cpu time. Ignore time limit.", e});
        }
        ResourceLimitChecker singleLimits = new ResourceLimitChecker(localShutdownManager, limits);
        singleLimits.start();
        localShutdownManager.getNotifier().register(this.logShutdownListener);
        ConfigurableProgramAnalysis cpa = null;
        try {
            AggregatedReachedSets aggregateReached = AggregatedReachedSets.empty();
            CoreComponentsFactory localCoreComponents = new CoreComponentsFactory(pCurrentContext.getConfig(), this.logger, localShutdownManager.getNotifier(), aggregateReached);
            boolean newReachedSet = false;
            if (pCurrentContext.reuseCPA()) {
                cpa = pCurrentContext.getCPA();
                if (cpa == null) {
                    CoreComponentsFactory globalCoreComponents = new CoreComponentsFactory(pCurrentContext.getConfig(), this.logger, this.shutdownNotifier, aggregateReached);
                    cpa = globalCoreComponents.createCPA(this.cfa, this.specification);
                    pCurrentContext.setCPA(cpa);
                    if (!pCurrentContext.reusePrecision()) {
                        newReachedSet = true;
                    }
                }
            } else {
                try {
                    cpa = localCoreComponents.createCPA(this.cfa, this.specification);
                    pCurrentContext.setCPA(cpa);
                    newReachedSet = true;
                }
                catch (InvalidConfigurationException e) {
                    pCurrentContext.setCPA(null);
                    this.tidyUpShutdownManager(localShutdownManager);
                    return null;
                }
            }
            if (pCurrentContext.reusePrecision()) {
                ArrayList<ReachedSet> previousResults = new ArrayList<ReachedSet>(2);
                FormulaManagerView fmgr = null;
                if (pCurrentContext.reuseOwnPrecision()) {
                    previousResults.add(pCurrentContext.getReachedSet());
                }
                if (pCurrentContext.reusePredecessorPrecision() && pPreviousContext != null) {
                    previousResults.add(pPreviousContext.getReachedSet());
                    PredicateCPA predCPA = CPAs.retrieveCPA(pPreviousContext.getCPA(), PredicateCPA.class);
                    if (predCPA != null) {
                        fmgr = predCPA.getSolver().getFormulaManager();
                    }
                }
                pCurrentContext.setReachedSet(this.createInitialReachedSet(cpa, pMainFunction, localCoreComponents, previousResults, fmgr, pCurrentContext.getConfig()));
            } else if (newReachedSet) {
                pCurrentContext.setReachedSet(this.createInitialReachedSet(cpa, pMainFunction, localCoreComponents, null, null, pCurrentContext.getConfig()));
            }
            Algorithm algorithm = localCoreComponents.createAlgorithm(cpa, this.cfa, this.specification);
            if (algorithm instanceof CompositionAlgorithm) {
                this.logger.log(Level.SEVERE, new Object[]{"Component analyses mus not be composition analyses themselves."});
                this.tidyUpShutdownManager(localShutdownManager);
                if (pCurrentContext.reuseCPA() && cpa != null) {
                    CPAs.closeCpaIfPossible(cpa, this.logger);
                }
                return null;
            }
            if (algorithm instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)algorithm)).collectStatistics(this.stats.getSubStatistics());
            }
            if (pCurrentContext.getCPA() instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)pCurrentContext.getCPA())).collectStatistics(this.stats.getSubStatistics());
            }
            return Pair.of(algorithm, localShutdownManager);
        }
        catch (InterruptedException | InvalidConfigurationException | CPAException e) {
            this.tidyUpShutdownManager(localShutdownManager);
            if (pCurrentContext.reuseCPA() && cpa != null) {
                CPAs.closeCpaIfPossible(cpa, this.logger);
            }
            this.logger.logUserException(Level.WARNING, e, "Problem during creation of analysis " + pCurrentContext.configToString());
            return null;
        }
    }

    private ReachedSet createInitialReachedSet(ConfigurableProgramAnalysis pCpa, CFANode pMainFunction, CoreComponentsFactory pFactory, @Nullable List<ReachedSet> previousReachedSets, @Nullable FormulaManagerView pFMgr, Configuration pConfig) throws InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractState initialState = pCpa.getInitialState(pMainFunction, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = pCpa.getInitialPrecision(pMainFunction, StateSpacePartition.getDefaultPartition());
        if (previousReachedSets != null && !previousReachedSets.isEmpty()) {
            initialPrecision = this.aggregatePrecisionsForReuse(previousReachedSets, initialPrecision, pFMgr, pConfig);
        }
        ReachedSet reached = pFactory.createReachedSet(pCpa);
        reached.add(initialState, initialPrecision);
        return reached;
    }

    private Precision aggregatePrecisionsForReuse(List<ReachedSet> pPreviousReachedSets, Precision pInitialPrecision, @Nullable FormulaManagerView pFMgr, Configuration pConfig) {
        PredicatePrecision predPrec;
        LoopBoundPrecision loopPrec;
        ConstraintsPrecision constrPrec;
        Preconditions.checkArgument((!pPreviousReachedSets.isEmpty() ? 1 : 0) != 0);
        Precision resultPrec = pInitialPrecision;
        VariableTrackingPrecision varPrec = Precisions.extractPrecisionByType(resultPrec, VariableTrackingPrecision.class);
        if (varPrec != null) {
            try {
                if (varPrec instanceof ConfigurablePrecision) {
                    varPrec = VariableTrackingPrecision.createRefineablePrecision(pConfig, varPrec);
                }
                boolean changed = false;
                for (ReachedSet reachedSet : pPreviousReachedSets) {
                    if (reachedSet == null) continue;
                    for (Precision prec : reachedSet.getPrecisions()) {
                        PredicatePrecision predPrec2;
                        VariableTrackingPrecision varPrecInter = Precisions.extractPrecisionByType(prec, VariableTrackingPrecision.class);
                        if (varPrecInter != null && !(varPrecInter instanceof ConfigurablePrecision)) {
                            varPrec = varPrec.join(varPrecInter);
                            changed = true;
                        }
                        if ((predPrec2 = Precisions.extractPrecisionByType(resultPrec, PredicatePrecision.class)) == null || pFMgr == null) continue;
                        varPrec = varPrec.withIncrement(this.convertPredPrecToVariableTrackingPrec(predPrec2, pFMgr));
                        changed = true;
                    }
                }
                if (changed) {
                    resultPrec = Precisions.replaceByType(resultPrec, varPrec, (Predicate<? super Precision>)Predicates.instanceOf(VariableTrackingPrecision.class));
                }
            }
            catch (InvalidConfigurationException e) {
                this.logger.logException(Level.INFO, (Throwable)e, "Reuse of precision failed. Continue without reuse");
            }
        }
        if ((constrPrec = Precisions.extractPrecisionByType(resultPrec, ConstraintsPrecision.class)) != null) {
            try {
                if (!(constrPrec instanceof RefinableConstraintsPrecision)) {
                    constrPrec = new RefinableConstraintsPrecision(pConfig);
                }
                boolean changed = false;
                for (ReachedSet previousReached : pPreviousReachedSets) {
                    if (previousReached == null) continue;
                    for (Precision prec : previousReached.getPrecisions()) {
                        ConstraintsPrecision constrPrecInter = Precisions.extractPrecisionByType(prec, ConstraintsPrecision.class);
                        if (constrPrecInter == null || constrPrecInter instanceof FullConstraintsPrecision) continue;
                        constrPrec = constrPrec.join(constrPrecInter);
                        changed = true;
                    }
                }
                if (changed) {
                    resultPrec = Precisions.replaceByType(resultPrec, constrPrec, (Predicate<? super Precision>)Predicates.instanceOf(ConstraintsPrecision.class));
                }
            }
            catch (InvalidConfigurationException e) {
                this.logger.logException(Level.INFO, (Throwable)e, "Reuse of precision failed. Continue without reuse");
            }
        }
        if ((loopPrec = Precisions.extractPrecisionByType(resultPrec, LoopBoundPrecision.class)) != null && pPreviousReachedSets.get(0) != null) {
            resultPrec = Precisions.replaceByType(resultPrec, loopPrec, (Predicate<? super Precision>)Predicates.instanceOf(LoopBoundPrecision.class));
        }
        if ((predPrec = Precisions.extractPrecisionByType(resultPrec, PredicatePrecision.class)) != null && pPreviousReachedSets.get(0) != null) {
            FluentIterable fluentIterable = FluentIterable.from((Iterable)ImmutableList.of((Object)resultPrec)).append(pPreviousReachedSets.get(0).getPrecisions());
            resultPrec = Precisions.replaceByType(resultPrec, PredicatePrecision.unionOf((Iterable<Precision>)fluentIterable), (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
        }
        return resultPrec;
    }

    private Multimap<CFANode, MemoryLocation> convertPredPrecToVariableTrackingPrec(PredicatePrecision pPredPrec, FormulaManagerView pFMgr) {
        HashSet<AbstractionPredicate> predicates = new HashSet<AbstractionPredicate>();
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getGlobalPredicates());
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getFunctionPredicates().values());
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getLocalPredicates().values());
        HashMultimap trackedVariables = HashMultimap.create();
        CFANode dummyNode = CFANode.newDummyCFANode();
        for (AbstractionPredicate pred : predicates) {
            for (String var : pFMgr.extractVariables((Formula)pred.getSymbolicAtom()).keySet()) {
                trackedVariables.put((Object)dummyNode, (Object)MemoryLocation.parseExtendedQualifiedName(var));
            }
        }
        return trackedVariables;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        if (this.selectionStrategy instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.selectionStrategy)).collectStatistics(pStatsCollection);
        }
        if (this.selectionStrategy instanceof Statistics) {
            pStatsCollection.add((Statistics)((Object)this.selectionStrategy));
        }
    }

    public static enum INTERMEDIATESTATSOPT {
        EXECUTE,
        NONE,
        PRINT;

    }

    private class CompositionAlgorithmStatistics
    implements Statistics {
        private final Timer totalTimer = new Timer();
        private final Collection<Statistics> currentSubStat = new ArrayList<Statistics>();
        private int noOfRuns = 0;

        @Override
        public @Nullable String getName() {
            return "Composition Algorithm";
        }

        private void printIntermediateStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            String text = "Statistics for " + this.noOfRuns + ". execution of composition algorithm";
            pOut.println(text);
            pOut.println("=".repeat(text.length()));
            this.printSubStatistics(pOut, pResult, pReached);
            pOut.println();
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println("Number of algorithms provided:    " + CompositionAlgorithm.this.configFiles.size());
            pOut.println("Number of composite analysis runs:        " + this.noOfRuns);
            pOut.println("Total time: " + this.totalTimer);
            this.printSubStatistics(pOut, pResult, pReached);
        }

        private void printSubStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println();
            pOut.println("Statistics for the component analysis in run " + this.noOfRuns + " of " + this.getName());
            for (Statistics s : this.currentSubStat) {
                StatisticsUtils.printStatistics(s, pOut, CompositionAlgorithm.this.logger, pResult, pReached);
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            for (Statistics s : this.currentSubStat) {
                StatisticsUtils.writeOutputFiles(s, CompositionAlgorithm.this.logger, pResult, pReached);
            }
        }

        public Collection<Statistics> getSubStatistics() {
            return this.currentSubStat;
        }

        public void resetSubStatistics() {
            this.currentSubStat.clear();
        }
    }
}

