/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CBMCExecutor;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;

@Options
public class CBMCChecker
implements CounterexampleChecker,
Statistics {
    private final LogManager logger;
    private final Timer cbmcTime = new Timer();
    @Option(secure=true, name="cbmc.dumpCBMCfile", description="File name where to put the path program that is generated as input for CBMC. A temporary file is used if this is unspecified. If specified, the file name should end with '.i' because otherwise CBMC runs the pre-processor on the file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private @Nullable Path cbmcFile;
    @Option(secure=true, name="cbmc.timelimit", description="maximum time limit for CBMC (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private TimeSpan timelimit = TimeSpan.ofMillis((long)0L);
    private final MachineModel machineModel;

    public CBMCChecker(Configuration config, LogManager logger, CFA cfa) throws InvalidConfigurationException {
        this.logger = logger;
        if (cfa.getLanguage() == Language.JAVA) {
            throw new UnsupportedOperationException("CBMC can't be used with the language Java");
        }
        config.inject((Object)this);
        this.machineModel = cfa.getMachineModel();
    }

    @Override
    public boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates) throws CPAException, InterruptedException {
        boolean bl;
        block9: {
            if (this.cbmcFile != null) {
                return this.checkCounterexample(pRootState, pErrorPathStates, this.cbmcFile);
            }
            TempFile.DeleteOnCloseFile tempFile = TempFile.builder().prefix("path").suffix(".i").createDeleteOnClose();
            try {
                bl = this.checkCounterexample(pRootState, pErrorPathStates, tempFile.toPath());
                if (tempFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CounterexampleAnalysisFailed("Could not create temporary file " + e.getMessage(), e);
                }
            }
            tempFile.close();
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCounterexample(ARGState pRootState, Set<ARGState> pErrorPathStates, Path cFile) throws CPAException, InterruptedException {
        int exitCode;
        CBMCExecutor cbmc;
        assert (cFile != null);
        Appender pathProgram = PathToCTranslator.translatePaths(pRootState, pErrorPathStates);
        try (Writer w = IO.openOutputFile((Path)cFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            pathProgram.appendTo((Appendable)w);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed("Could not write path program to file " + e.getMessage(), e);
        }
        String mainFunctionName = AbstractStates.extractLocation(pRootState).getFunctionName();
        this.logger.log(Level.FINE, new Object[]{"Starting CBMC verification."});
        this.cbmcTime.start();
        try {
            ArrayList<String> cbmcArgs = new ArrayList<String>(this.getParamForMachineModel());
            cbmcArgs.add("--stop-on-fail");
            cbmcArgs.add("--no-built-in-assertions");
            cbmcArgs.add("--unwind");
            cbmcArgs.add("100");
            cbmcArgs.add("--partial-loops");
            cbmcArgs.add("--no-unwinding-assertions");
            cbmcArgs.add("--function");
            cbmcArgs.add(mainFunctionName + "_0");
            cbmcArgs.add(cFile.toAbsolutePath().toString());
            cbmc = new CBMCExecutor(this.logger, cbmcArgs);
            exitCode = cbmc.join(this.timelimit.asMillis());
        }
        catch (IOException e) {
            try {
                throw new CounterexampleAnalysisFailed(e.getMessage(), e);
                catch (TimeoutException e2) {
                    throw new CounterexampleAnalysisFailed("CBMC took too long to verify the counterexample.");
                }
            }
            catch (Throwable throwable) {
                this.cbmcTime.stop();
                this.logger.log(Level.FINER, new Object[]{"CBMC finished."});
                throw throwable;
            }
        }
        this.cbmcTime.stop();
        this.logger.log(Level.FINER, new Object[]{"CBMC finished."});
        if (cbmc.producedErrorOutput()) {
            this.logger.log(Level.WARNING, new Object[]{"CBMC returned successfully, but printed warnings, ignoring the result. Please check the log above!"});
            throw new CounterexampleAnalysisFailed("CBMC could not verify the program (CBMC exit code was " + exitCode + ")!");
        }
        switch (exitCode) {
            case 0: {
                return false;
            }
            case 10: {
                return true;
            }
        }
        throw new CounterexampleAnalysisFailed("CBMC could not verify the program (CBMC exit code was " + exitCode + ")!");
    }

    private List<String> getParamForMachineModel() {
        switch (this.machineModel) {
            case LINUX32: {
                return ImmutableList.of((Object)"--i386-linux");
            }
            case LINUX64: {
                return ImmutableList.of((Object)"--i386-linux", (Object)"--arch", (Object)"x86_64");
            }
            case ARM: {
                return ImmutableList.of((Object)"--i386-linux", (Object)"--arch", (Object)"arm");
            }
        }
        throw new AssertionError((Object)("Unknown machine model value " + this.machineModel));
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        out.println("Time for running CBMC:              " + this.cbmcTime);
    }

    @Override
    public String getName() {
        return "CBMC Counterexample Check";
    }
}

