/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.cwriter.PathToConcreteProgramTranslator;

@Options(prefix="counterexample.concrete")
@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class ConcretePathExecutionChecker
implements CounterexampleChecker,
Statistics {
    @Option(secure=false, description="Path to the compiler. Can be absolute or only the name of the program if it is in the PATH")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path pathToCompiler = Path.of("/usr/bin/gcc", new String[0]);
    @Option(secure=true, description="The file in which the generated C code is saved.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private @Nullable Path dumpFile = null;
    @Option(secure=true, description="Maximum time limit for the concrete execution checker.\nThis limit is used for compilation as well as execution so overall, twice the time of this limit may be consumed.\n(use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private TimeSpan timelimit = TimeSpan.ofMillis((long)0L);
    private final LogManager logger;
    private final Timer timer = new Timer();

    public ConcretePathExecutionChecker(Configuration config, LogManager logger, CFA cfa) throws InvalidConfigurationException {
        if (cfa.getLanguage() != Language.C) {
            throw new UnsupportedOperationException("Concrete execution checker can only be used with C.");
        }
        config.inject((Object)this);
        this.logger = logger;
    }

    @Override
    public boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates) throws CPAException, InterruptedException {
        boolean bl;
        block9: {
            if (this.dumpFile != null) {
                return this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, this.dumpFile);
            }
            TempFile.DeleteOnCloseFile tempFile = TempFile.builder().prefix("concretePath").suffix(".c").createDeleteOnClose();
            try {
                bl = this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, tempFile.toPath());
                if (tempFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CounterexampleAnalysisFailed("Could not create temporary file " + e.getMessage(), e);
                }
            }
            tempFile.close();
        }
        return bl;
    }

    private void compilePathProgram(String absFilePath) throws CounterexampleAnalysisFailed, InterruptedException, IOException, TimeoutException {
        this.logger.log(Level.FINE, new Object[]{"Compiling concrete error path."});
        String[] cmdLine = new String[]{this.pathToCompiler.toAbsolutePath().toString(), absFilePath, "-o", absFilePath + ".exe", "-w"};
        ProcessExecutor exec = new ProcessExecutor(this.logger, CounterexampleAnalysisFailed.class, System.getenv(), cmdLine);
        int exitCode = exec.join(this.timelimit.asMillis());
        if (exitCode != 0) {
            StringBuilder errorOut = new StringBuilder();
            for (String str : exec.getErrorOutput()) {
                errorOut.append(str);
            }
            throw new CounterexampleAnalysisFailed("Could not compile the concrete error path. The compiler finished with exitCode " + exitCode + "\n The output was: \n" + errorOut);
        }
    }

    private boolean runConcretePathProgram(String absFilePath) throws CounterexampleAnalysisFailed, InterruptedException, IOException, TimeoutException {
        String[] cmdLine = new String[]{absFilePath + ".exe"};
        ProcessExecutor exec = new ProcessExecutor(this.logger, CounterexampleAnalysisFailed.class, System.getenv(), cmdLine);
        int exitCode = exec.join(this.timelimit.asMillis());
        switch (exitCode) {
            case 0: {
                this.logger.log(Level.FINER, new Object[]{"Concrete path program was executed, the error location was infeasible."});
                return false;
            }
            case 1: {
                this.logger.log(Level.FINER, new Object[]{"Concrete path program was executed, the error location was reached."});
                return true;
            }
        }
        throw new CounterexampleAnalysisFailed("Executing the concrete path program lead to invalid exitcode: " + exitCode);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates, Path cFile) throws CPAException, InterruptedException {
        boolean bl;
        assert (cFile != null);
        this.timer.start();
        CounterexampleInfo ceInfo = pErrorState.getCounterexampleInformation().orElseThrow();
        Appender pathProgram = PathToConcreteProgramTranslator.translatePaths(pRootState, pErrorPathStates, ceInfo.getCFAPathWithAssignments());
        try (Writer w = IO.openOutputFile((Path)cFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            pathProgram.appendTo((Appendable)w);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed("Could not write path program to file " + e.getMessage(), e);
        }
        String absFile = cFile.toAbsolutePath().toString();
        try {
            this.compilePathProgram(absFile);
            bl = this.runConcretePathProgram(absFile);
        }
        catch (IOException e) {
            try {
                throw new CounterexampleAnalysisFailed(e.getMessage(), e);
                catch (TimeoutException e2) {
                    throw new CounterexampleAnalysisFailed("Execution of concrete counterexample path program took too long.");
                }
            }
            catch (Throwable throwable) {
                this.timer.stop();
                this.logger.log(Level.FINER, new Object[]{"Execution of concrete error path program finished."});
                throw throwable;
            }
        }
        this.timer.stop();
        this.logger.log(Level.FINER, new Object[]{"Execution of concrete error path program finished."});
        return bl;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        out.println("Time for running concrete path check: " + this.timer);
    }

    @Override
    public String getName() {
        return "Concrete-Execution Counterexample Check";
    }
}

