/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessToOutputFormatsUtils;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

@Options(prefix="counterexample.checker")
public class CounterexampleCPAchecker
implements CounterexampleChecker {
    private static final ImmutableSet<String> OVERWRITE_OPTIONS = ImmutableSet.of((Object)"analysis.machineModel", (Object)"cpa.predicate.handlePointerAliasing", (Object)"cpa.predicate.memoryAllocationsAlwaysSucceed", (Object)"testcase.targets.type", (Object)"testcase.targets.optimization.strategy", (Object)"testcase.generate.parallel", (Object[])new String[0]);
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final Specification specification;
    private final CFA cfa;
    @Option(secure=true, name="path.file", description="File name where to put the path specification that is generated as input for the counterexample check. A temporary file is used if this is unspecified.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private @Nullable Path specFile;
    @Option(secure=true, name="config", required=true, description="configuration file for counterexample checks with CPAchecker")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private @Nullable Path configFile;
    @Option(secure=true, name="changeCEXInfo", description="counterexample information should provide more precise information from counterexample check, if available")
    private boolean provideCEXInfoFromCEXCheck = false;
    @Option(secure=true, name="forceCEXChange", description="counterexample check should fully replace existing counterexamples with own ones, if available")
    private boolean replaceCexWithCexFromCheck = false;
    private final Function<ARGState, Optional<CounterexampleInfo>> getCounterexampleInfo;
    private WitnessExporter witnessExporter;

    public CounterexampleCPAchecker(Configuration config, Specification pSpecification, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Function<ARGState, Optional<CounterexampleInfo>> pGetCounterexampleInfo) throws InvalidConfigurationException {
        this.logger = logger;
        this.config = config;
        this.specification = pSpecification;
        config.inject((Object)this);
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.getCounterexampleInfo = Objects.requireNonNull(pGetCounterexampleInfo);
        this.witnessExporter = new WitnessExporter(config, logger, this.specification, this.cfa);
    }

    @Override
    public boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates) throws CPAException, InterruptedException {
        boolean bl;
        block9: {
            if (this.specFile != null) {
                return this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, this.specFile);
            }
            TempFile.DeleteOnCloseFile automatonFile = TempFile.builder().prefix("counterexample-automaton").suffix(".graphml").createDeleteOnClose();
            try {
                bl = this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, automatonFile.toPath());
                if (automatonFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (automatonFile != null) {
                        try {
                            automatonFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CounterexampleAnalysisFailed("Could not write path automaton to file " + e.getMessage(), e);
                }
            }
            automatonFile.close();
        }
        return bl;
    }

    private boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates, Path automatonFile) throws IOException, CPAException, InterruptedException {
        Predicate relevantState = Predicates.in(pErrorPathStates);
        Witness witness = this.witnessExporter.generateErrorWitness(pRootState, (Predicate<? super ARGState>)relevantState, BiPredicates.bothSatisfy(relevantState), this.getCounterexampleInfo.apply(pErrorState).orElse(null));
        try (Writer w = IO.openOutputFile((Path)automatonFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            WitnessToOutputFormatsUtils.writeToGraphMl(witness, w);
        }
        CFANode entryNode = (CFANode)Iterables.getOnlyElement(AbstractStates.extractLocations(pRootState));
        LogManager lLogger = this.logger.withComponentName("CounterexampleCheck");
        try {
            Optional counterexampleFromCheck;
            ConfigurationBuilder lConfigBuilder = Configuration.builder().loadFromFile(this.configFile);
            for (String option : OVERWRITE_OPTIONS) {
                lConfigBuilder.copyOptionFromIfPresent(this.config, option);
            }
            if (this.provideCEXInfoFromCEXCheck) {
                CFAEdge targetEdge = pErrorState.getParents().iterator().next().getEdgeToChild(pErrorState);
                lConfigBuilder.setOption("testcase.targets.edge", targetEdge.getPredecessor().getNodeNumber() + "#" + System.identityHashCode(targetEdge));
            }
            Configuration lConfig = lConfigBuilder.build();
            ShutdownManager lShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
            ResourceLimitChecker.fromConfiguration(lConfig, lLogger, lShutdownManager).start();
            Specification lSpecification = this.specification.withAdditionalSpecificationFile((Set<Path>)ImmutableSet.of((Object)automatonFile), this.cfa, lConfig, lLogger, this.shutdownNotifier);
            CoreComponentsFactory factory = new CoreComponentsFactory(lConfig, lLogger, lShutdownManager.getNotifier(), AggregatedReachedSets.empty());
            ConfigurableProgramAnalysis lCpas = factory.createCPA(this.cfa, lSpecification);
            Algorithm lAlgorithm = factory.createAlgorithm(lCpas, this.cfa, lSpecification);
            ReachedSet lReached = factory.createReachedSet(lCpas);
            lReached.add(lCpas.getInitialState(entryNode, StateSpacePartition.getDefaultPartition()), lCpas.getInitialPrecision(entryNode, StateSpacePartition.getDefaultPartition()));
            lAlgorithm.run(lReached);
            lShutdownManager.requestShutdown("Analysis terminated");
            CPAs.closeCpaIfPossible(lCpas, lLogger);
            CPAs.closeIfPossible(lAlgorithm, lLogger);
            if ((this.provideCEXInfoFromCEXCheck || this.replaceCexWithCexFromCheck) && (counterexampleFromCheck = Collections3.filterByClass(lReached.stream(), ARGState.class).filter(AbstractStates::isTargetState).findFirst().flatMap(ARGState::getCounterexampleInformation)).isPresent()) {
                if (this.replaceCexWithCexFromCheck) {
                    this.replaceCounterexampleInformation(pRootState, pErrorState, (CounterexampleInfo)((Object)counterexampleFromCheck.orElseThrow()));
                } else if (this.provideCEXInfoFromCEXCheck) {
                    this.improveCounterexampleInformation(pErrorState, (CounterexampleInfo)((Object)counterexampleFromCheck.orElseThrow()));
                    assert (pErrorPathStates.containsAll((Collection<?>)pErrorState.getCounterexampleInformation().orElseThrow().getTargetPath().asStatesList()));
                }
            }
            return lReached.wasTargetReached();
        }
        catch (InvalidConfigurationException e) {
            throw new CounterexampleAnalysisFailed("Invalid configuration in counterexample-check config: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.shutdownNotifier.shutdownIfNecessary();
            throw new CounterexampleAnalysisFailed("Counterexample check aborted", e);
        }
    }

    private ARGPath reconstructArgPath(ARGState pRoot, ARGPath pPath) {
        List<CFAEdge> pathEdges = pPath.getFullPath();
        ArrayList<ARGState> argStates = new ArrayList<ARGState>();
        ARGState argCurrent = pRoot;
        int pathIndex = 0;
        while (pathIndex < pathEdges.size()) {
            CFAEdge pathEdge = pathEdges.get(pathIndex);
            boolean found = false;
            for (ARGState argChild : argCurrent.getChildren()) {
                List<CFAEdge> argEdges = argCurrent.getEdgesToChild(argChild);
                List<CFAEdge> subPathEdges = pathEdges.subList(pathIndex, Math.min(pathEdges.size(), pathIndex + argEdges.size()));
                if (argEdges.isEmpty() || !argEdges.equals(subPathEdges)) continue;
                argStates.add(argCurrent);
                argCurrent = argChild;
                pathIndex += argEdges.size();
                found = true;
                break;
            }
            assert (found) : "Next ARG-state not found for edge: " + pathEdge;
        }
        argStates.add(argCurrent);
        assert (argCurrent.isTarget()) : "Last state of counterexample-path is not a target state: " + argCurrent;
        return new ARGPath(argStates);
    }

    private void replaceCounterexampleInformation(ARGState pRootState, ARGState pStateForCounterexample, CounterexampleInfo pNewInfo) {
        CounterexampleInfo newInfo;
        if (pNewInfo.isPreciseCounterExample()) {
            ARGPath strippedDownPath = this.getExchangeableTargetPath(pNewInfo.getTargetPath());
            assert (strippedDownPath.getLastState().isTarget()) : "Last state of exchangeable target path is no target: " + strippedDownPath.getLastState();
            ARGPath reconstructedPath = this.reconstructArgPath(pRootState, strippedDownPath);
            newInfo = CounterexampleInfo.feasiblePrecise(reconstructedPath, pNewInfo.getCFAPathWithAssignments());
        } else {
            newInfo = pNewInfo;
        }
        Optional<CounterexampleInfo> counterexampleFromArg = pStateForCounterexample.getCounterexampleInformation();
        if (counterexampleFromArg.isPresent()) {
            pStateForCounterexample.replaceCounterexampleInformation(newInfo);
        } else {
            pStateForCounterexample.addCounterexampleInformation(newInfo);
        }
    }

    private ARGPath getExchangeableTargetPath(ARGPath pTargetPath) {
        ARGPathBuilder pathBuilder = ARGPath.builder();
        PathIterator it = pTargetPath.fullPathIterator();
        ARGState previousState = null;
        do {
            it.advance();
            ARGState currentState = it.getPreviousAbstractState();
            CFAEdge edgeLeavingCurrentState = it.getIncomingEdge();
            assert (previousState != null || currentState.getParents().isEmpty()) : "Iterator didn't start at first state, but at " + currentState;
            ARGState currentDummy = this.getStateWithIndependentInformation(currentState, previousState);
            pathBuilder.add(currentDummy, edgeLeavingCurrentState);
            if (!it.hasNext()) {
                return pathBuilder.build(it.getAbstractState());
            }
            previousState = currentDummy;
        } while (it.hasNext());
        throw new AssertionError((Object)"This location shouldn't be reachable");
    }

    private ARGState getStateWithIndependentInformation(ARGState pOriginal, @Nullable ARGState pParent) {
        LocationState currentLocation = AbstractStates.extractStateByType(pOriginal, LocationState.class);
        FluentIterable automatonStates = AbstractStates.asIterable(pOriginal).filter(AutomatonState.class);
        ImmutableList allWrappedStates = ImmutableList.builder().add((Object)currentLocation).addAll((Iterable)automatonStates).build();
        CompositeState composition = new CompositeState((List<AbstractState>)allWrappedStates);
        return new ARGState(composition, pParent);
    }

    private void improveCounterexampleInformation(ARGState pStateWithCounterexample, CounterexampleInfo pNewInfo) {
        if (!pNewInfo.isSpurious() && pNewInfo.isPreciseCounterExample()) {
            pStateWithCounterexample.replaceCounterexampleInformation(CounterexampleInfo.feasiblePrecise(pStateWithCounterexample.getCounterexampleInformation().isPresent() ? pStateWithCounterexample.getCounterexampleInformation().orElseThrow().getTargetPath() : ARGUtils.getOnePathTo(pStateWithCounterexample), pNewInfo.getCFAPathWithAssignments()));
        }
    }
}

