/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CBMCChecker;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.ConcretePathExecutionChecker;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleCPAchecker;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InfeasibleCounterexampleException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="counterexample")
public class CounterexampleCheckAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics,
ParallelAlgorithm.ReachedSetUpdater {
    private final Algorithm algorithm;
    private final CounterexampleChecker checker;
    private final LogManager logger;
    private final Timer checkTime = new Timer();
    private int numberOfInfeasiblePaths = 0;
    private final Set<ARGState> checkedTargetStates = Collections.newSetFromMap(new WeakHashMap());
    @Option(secure=true, name="checker", description="Which model checker to use for verifying counterexamples as a second check.\nCurrently CBMC or CPAchecker with a different config or the concrete execution \nchecker can be used.")
    private CounterexampleCheckerType checkerType = CounterexampleCheckerType.CBMC;
    @Option(secure=true, name="ambigiousARG", description="True if the path to the error state can not always be uniquely determined from the ARG.\nThis is the case e.g. for Slicing Abstractions, where the abstraction states in the ARG\ndo not form a tree!")
    private boolean ambigiousARG = false;
    @Option(secure=true, name="skipCounterexampleForUnsupportedCode", description="If true, the counterexample checker will not assume a counterexample as infeasible because of unsupported code. But will try different paths anyway.")
    private boolean skipCounterexampleForUnsupportedCode = false;

    public CounterexampleCheckAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, Specification pSpecification, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        this.algorithm = algorithm;
        this.logger = logger;
        config.inject((Object)this, CounterexampleCheckAlgorithm.class);
        if (!(pCpa instanceof ARGCPA) && !(pCpa instanceof BAMCPA)) {
            throw new InvalidConfigurationException("ARG CPA needed for counterexample check");
        }
        switch (this.checkerType) {
            case CBMC: {
                this.checker = new CBMCChecker(config, logger, cfa);
                break;
            }
            case CPACHECKER: {
                AssumptionToEdgeAllocator assumptionToEdgeAllocator = AssumptionToEdgeAllocator.create(config, logger, cfa.getMachineModel());
                this.checker = new CounterexampleCPAchecker(config, pSpecification, logger, pShutdownNotifier, cfa, s -> ARGUtils.tryGetOrCreateCounterexampleInformation(s, pCpa, assumptionToEdgeAllocator));
                break;
            }
            case CONCRETE_EXECUTION: {
                this.checker = new ConcretePathExecutionChecker(config, logger, cfa);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled case statement: " + this.checkerType));
            }
        }
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        if (reached.hasWaitingState()) {
            status = status.update(this.algorithm.run(reached));
            assert (ARGUtils.checkARG(reached));
            ImmutableList errorStates = FluentIterable.from((Iterable)reached).transform(AbstractStates.toState(ARGState.class)).filter(AbstractStates::isTargetState).filter(Predicates.not((Predicate)Predicates.in(this.checkedTargetStates))).toList();
            if (!errorStates.isEmpty()) {
                this.checkTime.start();
                try {
                    ArrayList<ARGState> infeasibleErrorPaths = new ArrayList<ARGState>();
                    boolean foundCounterexample = false;
                    for (ARGState errorState : errorStates) {
                        boolean counterexampleProvedFeasible = this.checkCounterexample(errorState, reached);
                        if (counterexampleProvedFeasible) {
                            this.checkedTargetStates.add(errorState);
                            foundCounterexample = true;
                            status = status.withPrecise(true);
                            continue;
                        }
                        infeasibleErrorPaths.add(errorState);
                        status = status.withSound(false);
                    }
                    if (!foundCounterexample) {
                        assert (!infeasibleErrorPaths.isEmpty());
                        throw new InfeasibleCounterexampleException("Error path found, but identified as infeasible by counterexample check with " + this.checkerType + ".", (List<ARGPath>)Collections3.transformedImmutableListCopy(infeasibleErrorPaths, ARGUtils::getOnePathTo));
                    }
                }
                finally {
                    this.checkTime.stop();
                }
            }
        }
        return status;
    }

    private boolean checkCounterexample(ARGState errorState, ReachedSet reached) throws InterruptedException {
        boolean feasibility;
        this.logger.log(Level.INFO, new Object[]{"Error path found, starting counterexample check with " + this.checkerType + "."});
        try {
            feasibility = this.checkErrorPaths(this.checker, errorState, reached);
        }
        catch (UnsupportedCodeException e) {
            if (this.skipCounterexampleForUnsupportedCode) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Counterexample could not be verified due to unsupported features.");
                return true;
            }
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Counterexample found, but feasibility could not be verified");
            return false;
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Counterexample found, but feasibility could not be verified");
            return false;
        }
        if (feasibility) {
            this.logger.log(Level.INFO, new Object[]{"Error path found and confirmed by counterexample check with " + this.checkerType + "."});
        } else {
            ++this.numberOfInfeasiblePaths;
            this.logger.log(Level.INFO, new Object[]{"Error path found but identified as infeasible."});
        }
        return feasibility;
    }

    protected boolean checkErrorPaths(CounterexampleChecker pChecker, ARGState errorState, ReachedSet reached) throws CPAException, InterruptedException {
        ARGState rootState = (ARGState)reached.getFirstState();
        Set<ARGState> statesOnErrorPath = this.ambigiousARG ? SlicingAbstractionsUtils.getStatesOnErrorPath(errorState) : ARGUtils.getAllStatesOnPathsTo(errorState);
        return pChecker.checkCounterexample(rootState, errorState, statesOnErrorPath);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this);
        if (this.checker instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.checker)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        out.println("Number of counterexample checks:    " + this.checkTime.getNumberOfIntervals());
        if (this.checkTime.getNumberOfIntervals() > 0) {
            out.println("Number of infeasible paths:         " + this.numberOfInfeasiblePaths + " (" + StatisticsUtils.toPercent(this.numberOfInfeasiblePaths, this.checkTime.getNumberOfIntervals()) + ")");
            out.println("Time for counterexample checks:     " + this.checkTime);
        }
    }

    @Override
    public String getName() {
        return "Counterexample-Check Algorithm";
    }

    @Override
    public void register(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).register(pReachedSetUpdateListener);
        }
    }

    @Override
    public void unregister(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).unregister(pReachedSetUpdateListener);
        }
    }

    static enum CounterexampleCheckerType {
        CBMC,
        CPACHECKER,
        CONCRETE_EXECUTION;

    }
}

