/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockOperatorDecomposer;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.CFADecomposer;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.GivenSizeDecomposer;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.SingleBlockDecomposer;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummarySortedMessageQueue;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.memory.InMemoryBlockSummaryConnectionProvider;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryActor;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryObserverWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorkerBuilder;
import org.sosy_lab.cpachecker.core.defaults.DummyTargetState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

@Options(prefix="distributedSummaries")
public class DistributedSummaryAnalysis
implements Algorithm {
    private final Configuration configuration;
    private final LogManager logger;
    private final CFA cfa;
    private final ShutdownManager shutdownManager;
    private final Specification specification;
    private final BlockSummaryAnalysisOptions options;
    private final StatInt numberWorkers = new StatInt(StatKind.MAX, "number of workers");
    @Option(description="Allows to set the algorithm for decomposing the CFA. BLOCK_OPERATOR creates blocks from each merge/branching point to the next merge/branching point. GIVEN_SIZE merges blocks obtained by BLOCK_OPERATOR until distributedSummaries.desiredNumberOfBlocks blocks are present. SINGLE_BLOCK creates one block around the complete CFA.")
    private DecompositionType decompositionType = DecompositionType.BLOCK_OPERATOR;
    @Option(description="Choose the workers that are spawned for each block. Contrary to DEFAULT workers, SMART workers consume multiple messages at once.")
    private WorkerType workerType = WorkerType.DEFAULT;
    @Option(description="desired number of BlockNodes")
    private int desiredNumberOfBlocks = 5;
    @Option(description="Whether to spawn util workers. Util workers listen to every message and create visual output for debugging. Workers consume resources and should not be used for benchmarks.")
    private boolean spawnUtilWorkers = true;

    public DistributedSummaryAnalysis(Configuration pConfig, LogManager pLogger, CFA pCfa, ShutdownManager pShutdownManager, Specification pSpecification) throws InvalidConfigurationException {
        this.configuration = pConfig;
        this.configuration.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownManager = pShutdownManager;
        this.specification = pSpecification;
        this.options = new BlockSummaryAnalysisOptions(this.configuration);
    }

    private CFADecomposer getDecomposer() throws InvalidConfigurationException {
        switch (this.decompositionType) {
            case BLOCK_OPERATOR: {
                return new BlockOperatorDecomposer(this.configuration, this.shutdownManager.getNotifier());
            }
            case GIVEN_SIZE: {
                return new GivenSizeDecomposer(new BlockOperatorDecomposer(this.configuration, this.shutdownManager.getNotifier()), this.desiredNumberOfBlocks);
            }
            case SINGLE_BLOCK: {
                return new SingleBlockDecomposer(this.shutdownManager.getNotifier());
            }
        }
        throw new AssertionError((Object)("Unknown DecompositionType: " + this.decompositionType));
    }

    private BlockSummaryWorkerBuilder analysisWorker(BlockSummaryWorkerBuilder pBuilder, BlockNode pNode) {
        switch (this.workerType) {
            case DEFAULT: {
                return pBuilder.addAnalysisWorker(pNode, this.options);
            }
            case SMART: {
                return pBuilder.addSmartAnalysisWorker(pNode, this.options);
            }
        }
        throw new AssertionError((Object)("Unknown WorkerType: " + this.workerType));
    }

    /*
     * Loose catch block
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus algorithmStatus;
        BlockSummaryConnection mainThreadConnection;
        block19: {
            this.logger.log(Level.INFO, new Object[]{"Starting block analysis..."});
            CFADecomposer decomposer = this.getDecomposer();
            BlockGraph blockGraph = decomposer.cut(this.cfa);
            this.logger.logf(Level.INFO, "Decomposed CFA in %d blocks using the %s.", new Object[]{blockGraph.getDistinctNodes().size(), decomposer.getClass().getCanonicalName()});
            ImmutableSet<BlockNode> blocks = blockGraph.getDistinctNodes();
            BlockSummaryWorkerBuilder builder = new BlockSummaryWorkerBuilder(this.cfa, new InMemoryBlockSummaryConnectionProvider(() -> new BlockSummarySortedMessageQueue()), this.specification, this.configuration, this.shutdownManager);
            builder = builder.createAdditionalConnections(1);
            for (Object distinctNode : blocks) {
                if (((BlockNode)distinctNode).isRoot()) {
                    builder = builder.addRootWorker((BlockNode)distinctNode, this.options);
                    continue;
                }
                builder = this.analysisWorker(builder, (BlockNode)distinctNode);
            }
            builder = builder.addResultCollectorWorker((Collection<BlockNode>)blocks, this.options);
            if (this.spawnUtilWorkers) {
                builder = builder.addVisualizationWorker(blockGraph, this.options);
            }
            BlockSummaryWorkerBuilder.Components components = builder.build();
            this.numberWorkers.setNextValue(components.getWorkers().size());
            for (BlockSummaryActor worker : components.getWorkers()) {
                Thread thread = new Thread((Runnable)worker, worker.getId());
                thread.setDaemon(true);
                thread.start();
            }
            mainThreadConnection = components.getAdditionalConnections().get(0);
            BlockSummaryObserverWorker observer = new BlockSummaryObserverWorker("observer", mainThreadConnection, this.options);
            Pair<Algorithm.AlgorithmStatus, CPAcheckerResult.Result> resultPair = observer.observe();
            CPAcheckerResult.Result result = resultPair.getSecond();
            if (result == CPAcheckerResult.Result.FALSE) {
                ARGState state = (ARGState)reachedSet.getFirstState();
                assert (state != null);
                CompositeState cState = (CompositeState)state.getWrappedState();
                Precision initialPrecision = reachedSet.getPrecision(state);
                assert (cState != null);
                ArrayList<AbstractState> states = new ArrayList<AbstractState>((Collection<AbstractState>)cState.getWrappedStates());
                states.add(DummyTargetState.withoutTargetInformation());
                reachedSet.add(new ARGState(new CompositeState(states), null), initialPrecision);
            } else if (result == CPAcheckerResult.Result.TRUE) {
                reachedSet.clear();
            }
            algorithmStatus = resultPair.getFirst();
            if (mainThreadConnection == null) break block19;
            mainThreadConnection.close();
        }
        this.logger.log(Level.INFO, new Object[]{"Block analysis finished."});
        return algorithmStatus;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (mainThreadConnection != null) {
                            try {
                                mainThreadConnection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | InvalidConfigurationException pE) {
                        this.logger.logException(Level.SEVERE, pE, "Block analysis stopped unexpectedly.");
                        throw new CPAException("Component Analysis run into an error.", pE);
                    }
                }
                catch (Throwable throwable3) {
                    this.logger.log(Level.INFO, new Object[]{"Block analysis finished."});
                    throw throwable3;
                }
            }
        }
    }

    private static enum WorkerType {
        DEFAULT,
        SMART;

    }

    private static enum DecompositionType {
        BLOCK_OPERATOR,
        GIVEN_SIZE,
        SINGLE_BLOCK;

    }
}

