/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis;

import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.block.BlockCPA;
import org.sosy_lab.cpachecker.cpa.block.BlockCPABackward;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

public class AlgorithmFactory {
    public static Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createAlgorithm(LogManager logger, Specification specification, CFA cfa, Configuration globalConfig, ShutdownManager singleShutdownManager, BlockNode node) throws InvalidConfigurationException, CPAException, InterruptedException {
        LogManager singleLogger = logger.withComponentName("Analysis " + node);
        ResourceLimitChecker singleLimits = ResourceLimitChecker.fromConfiguration(globalConfig, singleLogger, singleShutdownManager);
        singleLimits.start();
        CoreComponentsFactory coreComponents = new CoreComponentsFactory(globalConfig, singleLogger, singleShutdownManager.getNotifier(), AggregatedReachedSets.empty());
        ConfigurableProgramAnalysis cpa = coreComponents.createCPA(cfa, specification);
        Optional.ofNullable(CPAs.retrieveCPA(cpa, BlockCPA.class)).ifPresent(b -> b.init(node));
        Optional.ofNullable(CPAs.retrieveCPA(cpa, BlockCPABackward.class)).ifPresent(b -> b.init(node));
        GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
        Algorithm algorithm = coreComponents.createAlgorithm(cpa, cfa, specification);
        ReachedSet reached = AlgorithmFactory.createInitialReachedSet(cpa, node.getStartNode(), coreComponents, singleLogger);
        return Triple.of(algorithm, cpa, reached);
    }

    private static ReachedSet createInitialReachedSet(ConfigurableProgramAnalysis cpa, CFANode mainFunction, CoreComponentsFactory pFactory, LogManager singleLogger) throws InterruptedException {
        singleLogger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractState initialState = cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition());
        ReachedSet reached = pFactory.createReachedSet(cpa);
        reached.add(initialState, initialPrecision);
        return reached;
    }
}

