/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.composite.DistributedCompositeCPA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryMessagePayload;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.java_smt.api.SolverException;

public class BackwardBlockAnalysis
extends BlockAnalysis {
    private final ReachedSet reachedSet = this.getReachedSet();
    private final BlockNode block;
    private final LogManager logger;
    private final DistributedCompositeCPA distributedCompositeCPA;

    public BackwardBlockAnalysis(LogManager pLogger, BlockNode pBlock, CFA pCFA, Specification pSpecification, Configuration pConfiguration, ShutdownManager pShutdownManager, BlockSummaryAnalysisOptions pOptions) throws CPAException, InterruptedException, InvalidConfigurationException {
        super(pLogger, pBlock, pCFA, AnalysisDirection.BACKWARD, pSpecification, pConfiguration, pShutdownManager, pOptions);
        this.block = pBlock;
        this.logger = pLogger;
        this.distributedCompositeCPA = this.getDistributedCompositeCPA();
    }

    @Override
    public Collection<BlockSummaryMessage> analyze(Collection<BlockSummaryMessage> messages) throws CPAException, InterruptedException, SolverException {
        ARGState startState = this.getStartState(messages);
        ImmutableSet<ARGState> targetStates = this.findReachableTargetStatesInBlock(startState);
        ImmutableList states = Collections3.transformedImmutableListCopy(targetStates, state -> AbstractStates.extractStateByType(state, CompositeState.class));
        if (states.isEmpty()) {
            this.logger.log(Level.ALL, new Object[]{"Cannot reach block start?", this.reachedSet});
            return ImmutableSet.of((Object)BlockSummaryMessage.newErrorConditionUnreachableMessage(this.block.getId(), "backwards analysis cannot reach target at block entry"));
        }
        ImmutableSet.Builder responses = ImmutableSet.builder();
        for (AbstractState state2 : states) {
            BlockSummaryMessagePayload payload = this.distributedCompositeCPA.getSerializeOperator().serialize(state2);
            payload = this.appendStatus(this.getStatus(), payload);
            responses.add((Object)BlockSummaryMessage.newErrorConditionMessage(this.block.getId(), this.block.getStartNode().getNodeNumber(), payload, false, this.visitedBlocks(messages)));
        }
        return responses.build();
    }

    @Override
    public Collection<BlockSummaryMessage> performInitialAnalysis() throws InterruptedException, CPAException {
        throw new AssertionError((Object)"Initial backward analysis is not implemented yet.");
    }
}

