/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.AlgorithmFactory;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BlockAnalyzer;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.DCPAHandler;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.composite.DistributedCompositeCPA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryMessagePayload;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryObserverWorker;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.block.BlockEntryReachedTargetInformation;
import org.sosy_lab.cpachecker.cpa.block.BlockState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Triple;

public abstract class BlockAnalysis
implements BlockAnalyzer {
    private final Algorithm algorithm;
    private final ReachedSet reachedSet;
    private final DistributedCompositeCPA distributedCompositeCPA;
    private final Precision initialPrecision;
    private final AbstractState top;
    private final ConfigurableProgramAnalysis cpa;
    private final BlockNode block;
    private Algorithm.AlgorithmStatus status;

    public BlockAnalysis(LogManager pLogger, BlockNode pBlock, CFA pCFA, AnalysisDirection pDirection, Specification pSpecification, Configuration pConfiguration, ShutdownManager pShutdownManager, BlockSummaryAnalysisOptions pOptions) throws CPAException, InterruptedException, InvalidConfigurationException {
        Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> parts = AlgorithmFactory.createAlgorithm(pLogger, pSpecification, pCFA, pConfiguration, pShutdownManager, pBlock);
        this.algorithm = parts.getFirst();
        this.cpa = parts.getSecond();
        this.reachedSet = parts.getThird();
        this.status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        Preconditions.checkNotNull((Object)this.reachedSet, (Object)"BlockAnalysis requires the initial reachedSet");
        this.initialPrecision = this.reachedSet.getPrecision(Objects.requireNonNull(this.reachedSet.getFirstState()));
        this.block = pBlock;
        DCPAHandler builder = new DCPAHandler(pOptions);
        CompositeCPA compositeCPA = CPAs.retrieveCPAOrFail(this.cpa, CompositeCPA.class, BlockAnalysis.class);
        for (ConfigurableProgramAnalysis wrappedCPA : compositeCPA.getWrappedCPAs()) {
            builder.registerDCPA(wrappedCPA, this.block, pDirection);
        }
        this.distributedCompositeCPA = new DistributedCompositeCPA(compositeCPA, this.block, pDirection, builder.getRegisteredAnalyses());
        this.top = this.cpa.getInitialState(pDirection == AnalysisDirection.FORWARD ? this.block.getStartNode() : this.block.getLastNode(), StateSpacePartition.getDefaultPartition());
    }

    Optional<CFANode> abstractStateToLocation(AbstractState state) {
        LocationState locState = AbstractStates.extractStateByType(state, LocationState.class);
        if (locState != null) {
            return Optional.of(locState.getLocationNode());
        }
        BlockState blockState = AbstractStates.extractStateByType(state, BlockState.class);
        if (blockState != null) {
            return Optional.of(blockState.getLocationNode());
        }
        return Optional.empty();
    }

    ARGState getStartState(Collection<BlockSummaryMessage> receivedPostConditions) throws InterruptedException, CPAException {
        ArrayList<AbstractState> states = new ArrayList<AbstractState>();
        for (BlockSummaryMessage receivedPostCondition : receivedPostConditions) {
            states.add(this.distributedCompositeCPA.getDeserializeOperator().deserialize(receivedPostCondition));
        }
        return new ARGState((AbstractState)Iterables.getOnlyElement(this.distributedCompositeCPA.getCombineOperator().combine(states, this.top, this.initialPrecision)), null);
    }

    public DistributedCompositeCPA getDistributedCPA() {
        return this.distributedCompositeCPA;
    }

    ImmutableSet<String> visitedBlocks(Collection<BlockSummaryMessage> pMessages) {
        ImmutableSet.Builder visitedBlocks = ImmutableSet.builder();
        for (BlockSummaryMessage message : pMessages) {
            Object visited = ImmutableSet.of();
            if (message.getType() == BlockSummaryMessage.MessageType.BLOCK_POSTCONDITION) {
                visited = ((BlockSummaryPostConditionMessage)message).visitedBlockIds();
            } else if (message.getType() == BlockSummaryMessage.MessageType.ERROR_CONDITION) {
                visited = ((BlockSummaryErrorConditionMessage)message).visitedBlockIds();
            }
            Iterator iterator = visited.iterator();
            while (iterator.hasNext()) {
                String part = (String)iterator.next();
                if (part.isBlank()) continue;
                visitedBlocks.add((Object)part);
            }
        }
        visitedBlocks.add((Object)this.block.getId());
        return visitedBlocks.build();
    }

    ImmutableSet<ARGState> findReachableTargetStatesInBlock(AbstractState startState) throws CPAException, InterruptedException {
        this.reachedSet.clear();
        this.reachedSet.add(startState, this.initialPrecision);
        while (this.reachedSet.hasWaitingState()) {
            this.status = this.status.update(this.algorithm.run(this.reachedSet));
            AbstractStates.getTargetStates(this.reachedSet).forEach(this.reachedSet::removeOnlyFromWaitlist);
        }
        ImmutableSet targets = FluentIterable.from((Iterable)this.reachedSet).transform(s -> AbstractStates.extractStateByType(s, ARGState.class)).filter(AbstractStates::isTargetState).filter(s -> !startState.equals(s)).toSet();
        return targets;
    }

    ImmutableSet<ARGState> extractBlockTargetStates(Set<ARGState> targetStates) {
        ImmutableSet.Builder blockTargetStates = ImmutableSet.builder();
        block0: for (ARGState targetState : targetStates) {
            for (Targetable.TargetInformation targetInformation : targetState.getTargetInformation()) {
                if (!(targetInformation instanceof BlockEntryReachedTargetInformation)) continue;
                blockTargetStates.add((Object)targetState);
                continue block0;
            }
        }
        return blockTargetStates.build();
    }

    ImmutableSet<ARGState> extractViolations(Set<ARGState> targetStates) {
        ImmutableSet.Builder violationStates = ImmutableSet.builder();
        block0: for (ARGState targetState : targetStates) {
            for (Targetable.TargetInformation targetInformation : targetState.getTargetInformation()) {
                if (targetInformation instanceof BlockEntryReachedTargetInformation) continue;
                violationStates.add((Object)targetState);
                continue block0;
            }
        }
        return violationStates.build();
    }

    BlockSummaryMessagePayload appendStatus(Algorithm.AlgorithmStatus pStatus, BlockSummaryMessagePayload pCurrentPayload) {
        return new BlockSummaryMessagePayload.Builder().addAllEntries((Map<String, Object>)((Object)pCurrentPayload)).addEntry("property", pStatus.wasPropertyChecked() ? BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked.CHECKED.name() : BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked.UNCHECKED.name()).addEntry("sound", pStatus.isSound() ? BlockSummaryObserverWorker.StatusObserver.StatusSoundness.SOUND.name() : BlockSummaryObserverWorker.StatusObserver.StatusSoundness.UNSOUND.name()).addEntry("precise", pStatus.isPrecise() ? BlockSummaryObserverWorker.StatusObserver.StatusPrecise.PRECISE.name() : BlockSummaryObserverWorker.StatusObserver.StatusPrecise.IMPRECISE.name()).buildPayload();
    }

    ReachedSet getReachedSet() {
        return this.reachedSet;
    }

    AbstractState getTop() {
        return this.top;
    }

    Precision getInitialPrecision() {
        return this.initialPrecision;
    }

    Algorithm.AlgorithmStatus getStatus() {
        return this.status;
    }

    DistributedCompositeCPA getDistributedCompositeCPA() {
        return this.distributedCompositeCPA;
    }

    ConfigurableProgramAnalysis getCPA() {
        return this.cpa;
    }
}

