/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.composite.DistributedCompositeCPA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryMessagePayload;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ForwardBlockAnalysis
extends BlockAnalysis {
    private final DistributedCompositeCPA distributedCompositeCPA;
    private final BlockNode block;
    private final ReachedSet reachedSet;
    private final AbstractState top;
    private Precision precision;
    private boolean alreadyReportedError;
    private final boolean containsLoops;

    public ForwardBlockAnalysis(LogManager pLogger, BlockNode pBlock, CFA pCFA, Specification pSpecification, Configuration pConfiguration, ShutdownManager pShutdownManager, BlockSummaryAnalysisOptions pOptions) throws CPAException, InterruptedException, InvalidConfigurationException {
        super(pLogger, pBlock, pCFA, AnalysisDirection.FORWARD, pSpecification, pConfiguration, pShutdownManager, pOptions);
        this.alreadyReportedError = this.containsLoops = pCFA.getAllLoopHeads().isPresent() || pOptions.shouldSendEveryErrorMessage();
        this.reachedSet = this.getReachedSet();
        this.precision = this.getInitialPrecision();
        this.top = this.getTop();
        this.distributedCompositeCPA = this.getDistributedCompositeCPA();
        this.block = pBlock;
    }

    @Override
    public Collection<BlockSummaryMessage> analyze(Collection<BlockSummaryMessage> messages) throws CPAException, InterruptedException {
        ARGState startState = this.getStartState(messages);
        ImmutableSet<ARGState> targetStates = this.findReachableTargetStatesInBlock(startState);
        if (targetStates.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder answers = ImmutableSet.builder();
        ImmutableSet<ARGState> violations = this.extractViolations((Set<ARGState>)targetStates);
        if (!(violations.isEmpty() || this.alreadyReportedError && !this.containsLoops)) {
            answers.addAll(this.createErrorConditionMessages((Set<ARGState>)violations));
            this.alreadyReportedError = true;
        }
        ImmutableSet<ARGState> blockEntries = this.extractBlockTargetStates((Set<ARGState>)targetStates);
        answers.addAll(this.createBlockPostConditionMessage(messages, (Set<ARGState>)blockEntries));
        return answers.build();
    }

    @Override
    public Collection<BlockSummaryMessage> performInitialAnalysis() throws InterruptedException, CPAException {
        BlockSummaryMessage initial = BlockSummaryMessage.newBlockPostCondition(this.block.getId(), this.block.getStartNode().getNodeNumber(), BlockSummaryMessagePayload.empty(), false, true, (Set<String>)ImmutableSet.of());
        Collection<BlockSummaryMessage> result = this.analyze((Collection<BlockSummaryMessage>)ImmutableSet.of((Object)initial));
        if (this.reachedSet.getLastState() != null) {
            this.precision = this.reachedSet.getPrecision(this.reachedSet.getLastState());
        }
        if (result.isEmpty()) {
            return ImmutableSet.of((Object)BlockSummaryMessage.newBlockPostCondition(this.block.getId(), this.block.getStartNode().getNodeNumber(), BlockSummaryMessagePayload.empty(), true, false, (Set<String>)ImmutableSet.of()));
        }
        return result;
    }

    private Collection<BlockSummaryMessage> createBlockPostConditionMessage(Collection<BlockSummaryMessage> messages, Set<ARGState> blockEntries) throws CPAException, InterruptedException {
        ImmutableList compositeStates = Collections3.transformedImmutableListCopy(blockEntries, state -> AbstractStates.extractStateByType(state, CompositeState.class));
        if (this.reachedSet.getLastState() != null) {
            this.precision = this.reachedSet.getPrecision(this.reachedSet.getLastState());
        }
        ImmutableSet.Builder answers = ImmutableSet.builder();
        if (!compositeStates.isEmpty()) {
            boolean fullPath = messages.size() == this.block.getPredecessors().size() && messages.stream().allMatch(m -> ((BlockSummaryPostConditionMessage)m).representsFullPath());
            ImmutableSet<String> visited = this.visitedBlocks(messages);
            AbstractState combined = (AbstractState)Iterables.getOnlyElement(this.distributedCompositeCPA.getCombineOperator().combine((List<AbstractState>)compositeStates, this.top, this.precision));
            BlockSummaryMessagePayload result = this.distributedCompositeCPA.getSerializeOperator().serialize(combined);
            result = this.appendStatus(this.getStatus(), result);
            BlockSummaryPostConditionMessage response = (BlockSummaryPostConditionMessage)BlockSummaryMessage.newBlockPostCondition(this.block.getId(), this.block.getLastNode().getNodeNumber(), result, fullPath, true, visited);
            this.distributedCompositeCPA.getProceedOperator().update(response);
            answers.add((Object)response);
        }
        return answers.build();
    }

    private Collection<BlockSummaryMessage> createErrorConditionMessages(Set<ARGState> violations) throws InterruptedException {
        ImmutableSet.Builder answers = ImmutableSet.builder();
        for (ARGState targetState : violations) {
            Optional<CFANode> targetNode = this.abstractStateToLocation(targetState);
            if (targetNode.isEmpty()) {
                throw new AssertionError((Object)("States need to have a location but this one does not:" + targetState));
            }
            BlockSummaryMessagePayload initial = this.distributedCompositeCPA.getSerializeOperator().serialize(this.distributedCompositeCPA.getInitialState(targetNode.orElseThrow(), StateSpacePartition.getDefaultPartition()));
            initial = this.appendStatus(this.getStatus(), initial);
            answers.add((Object)BlockSummaryMessage.newErrorConditionMessage(this.block.getId(), targetNode.orElseThrow().getNodeNumber(), initial, true, (Set<String>)ImmutableSet.of((Object)this.block.getId())));
        }
        return answers.build();
    }
}

