/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.util.Pair;

public class BlockGraph {
    private final BlockNode root;
    private final BlockGraphFactory factory;

    public BlockGraph(BlockNode pRoot, BlockGraphFactory pFactory) {
        this.root = pRoot;
        this.factory = pFactory;
    }

    public BlockNode getRoot() {
        return this.root;
    }

    public ImmutableSet<BlockNode> getDistinctNodes() {
        LinkedHashSet<BlockNode> nodes = new LinkedHashSet<BlockNode>();
        ArrayDeque<BlockNode> waiting = new ArrayDeque<BlockNode>();
        waiting.add(this.root);
        while (!waiting.isEmpty()) {
            BlockNode top = (BlockNode)waiting.pop();
            if (!nodes.add(top)) continue;
            waiting.addAll(top.getSuccessors());
        }
        return ImmutableSet.copyOf(nodes);
    }

    public static BlockGraph merge(BlockGraph pBlockGraph, int pDesiredNumberOfBlocks) throws InterruptedException {
        return pBlockGraph.factory.merge(pDesiredNumberOfBlocks);
    }

    public static class BlockGraphFactory {
        private int blockCount;
        private final Map<Integer, CFANode> idToNodeMap;
        private final Multimap<BlockNode.BlockNodeMetaData, BlockNode.BlockNodeMetaData> successors;
        private final Multimap<BlockNode.BlockNodeMetaData, BlockNode.BlockNodeMetaData> predecessors;
        private final Set<BlockNode.BlockNodeMetaData> blocks;
        private final ShutdownNotifier shutdownNotifier;
        private BlockNode.BlockNodeMetaData root;

        public BlockGraphFactory(CFA pCfa, ShutdownNotifier pShutdownNotifier) {
            this.idToNodeMap = Maps.uniqueIndex(pCfa.getAllNodes(), CFANode::getNodeNumber);
            this.successors = ArrayListMultimap.create();
            this.predecessors = ArrayListMultimap.create();
            this.blocks = new LinkedHashSet<BlockNode.BlockNodeMetaData>();
            this.shutdownNotifier = pShutdownNotifier;
        }

        public void setRoot(BlockNode.BlockNodeMetaData pRoot) {
            this.root = pRoot;
        }

        public BlockNode.BlockNodeMetaData makeBlock(CFANode pStartNode, CFANode pEndNode, Set<CFANode> pNodesInBlock, Set<CFAEdge> pEdges) {
            BlockNode.BlockNodeMetaData blockNodeMetaData = new BlockNode.BlockNodeMetaData("B" + this.blockCount++, pStartNode, pEndNode, pNodesInBlock, pEdges, (Map<Integer, CFANode>)ImmutableMap.copyOf(this.idToNodeMap));
            this.blocks.add(blockNodeMetaData);
            return blockNodeMetaData;
        }

        public void linkSuccessor(BlockNode.BlockNodeMetaData pNode, BlockNode.BlockNodeMetaData pNodeSuccessor) {
            this.successors.put((Object)pNode, (Object)pNodeSuccessor);
            this.predecessors.put((Object)pNodeSuccessor, (Object)pNode);
        }

        public void unlinkSuccessor(BlockNode.BlockNodeMetaData pNode, BlockNode.BlockNodeMetaData pNodeSuccessor) {
            this.successors.remove((Object)pNode, (Object)pNodeSuccessor);
            this.predecessors.remove((Object)pNodeSuccessor, (Object)pNode);
        }

        public void removeNode(BlockNode.BlockNodeMetaData pNode) {
            this.removeFromMultimap(this.successors, pNode);
            this.removeFromMultimap(this.predecessors, pNode);
            this.blocks.remove(pNode);
        }

        private void removeFromMultimap(Multimap<BlockNode.BlockNodeMetaData, BlockNode.BlockNodeMetaData> pMultimap, BlockNode.BlockNodeMetaData pNode) {
            pMultimap.removeAll((Object)pNode);
            Set keys = pMultimap.keySet();
            for (BlockNode.BlockNodeMetaData key : keys) {
                pMultimap.remove((Object)key, (Object)pNode);
            }
        }

        public BlockNode.BlockNodeMetaData mergeSameStartAndEnd(BlockNode.BlockNodeMetaData pNode1, BlockNode.BlockNodeMetaData pNode2) {
            if (!pNode1.getStartNode().equals(pNode2.getStartNode()) || !pNode1.getLastNode().equals(pNode2.getLastNode())) {
                throw new AssertionError((Object)("Nodes must start and end on the same CFANode: " + pNode1 + " " + pNode2));
            }
            LinkedHashSet<CFANode> nodesInBlock = new LinkedHashSet<CFANode>(pNode1.getNodesInBlock());
            nodesInBlock.addAll(pNode2.getNodesInBlock());
            LinkedHashSet<CFAEdge> edgesInBlock = new LinkedHashSet<CFAEdge>(pNode1.getEdgesInBlock());
            edgesInBlock.addAll(pNode2.getEdgesInBlock());
            BlockNode.BlockNodeMetaData merged = this.makeBlock(pNode1.getStartNode(), pNode2.getLastNode(), nodesInBlock, edgesInBlock);
            this.predecessors.get((Object)pNode1).forEach(n -> this.linkSuccessor((BlockNode.BlockNodeMetaData)n, merged));
            this.predecessors.get((Object)pNode2).forEach(n -> this.linkSuccessor((BlockNode.BlockNodeMetaData)n, merged));
            this.successors.get((Object)pNode1).forEach(n -> this.linkSuccessor(merged, (BlockNode.BlockNodeMetaData)n));
            this.successors.get((Object)pNode2).forEach(n -> this.linkSuccessor(merged, (BlockNode.BlockNodeMetaData)n));
            this.removeNode(pNode1);
            this.removeNode(pNode2);
            return merged;
        }

        public BlockNode.BlockNodeMetaData mergeSingleSuccessors(BlockNode.BlockNodeMetaData pNode1, BlockNode.BlockNodeMetaData pNode2) {
            if (this.successors.get((Object)pNode1).size() == 1 && this.predecessors.get((Object)pNode2).size() == 1 && this.predecessors.get((Object)pNode2).contains(pNode1)) {
                LinkedHashSet<CFANode> nodesInBlock = new LinkedHashSet<CFANode>(pNode1.getNodesInBlock());
                nodesInBlock.addAll(pNode2.getNodesInBlock());
                LinkedHashSet<CFAEdge> edgesInBlock = new LinkedHashSet<CFAEdge>(pNode1.getEdgesInBlock());
                edgesInBlock.addAll(pNode2.getEdgesInBlock());
                BlockNode.BlockNodeMetaData merged = this.makeBlock(pNode1.getStartNode(), pNode2.getLastNode(), nodesInBlock, edgesInBlock);
                this.predecessors.get((Object)pNode1).forEach(n -> this.linkSuccessor((BlockNode.BlockNodeMetaData)n, merged));
                this.predecessors.get((Object)pNode2).forEach(n -> this.linkSuccessor(merged, (BlockNode.BlockNodeMetaData)n));
                this.removeNode(pNode1);
                this.removeNode(pNode2);
                return merged;
            }
            throw new AssertionError((Object)"Blocks must be in one line to be merged");
        }

        public void removeEmptyBlocks() {
            for (BlockNode.BlockNodeMetaData node : this.blocks) {
                if (this.predecessors.get((Object)node).isEmpty() || !node.getEdgesInBlock().isEmpty()) continue;
                ImmutableSet pred = ImmutableSet.copyOf((Collection)this.predecessors.get((Object)node));
                ImmutableSet succ = ImmutableSet.copyOf((Collection)this.successors.get((Object)node));
                for (BlockNode.BlockNodeMetaData predecessor : pred) {
                    for (BlockNode.BlockNodeMetaData successor : succ) {
                        this.linkSuccessor(predecessor, successor);
                    }
                }
                this.removeNode(node);
            }
        }

        public BlockGraph build() throws InterruptedException {
            Objects.requireNonNull(this.root, "Root has to be set manually in advance");
            this.removeEmptyBlocks();
            HashMap<BlockNode.BlockNodeMetaData, BlockNode> nodes = new HashMap<BlockNode.BlockNodeMetaData, BlockNode>();
            for (BlockNode.BlockNodeMetaData data : this.blocks) {
                BlockNode blockNode = new BlockNode(data, () -> Collections3.transformedImmutableSetCopy((Collection)this.predecessors.get((Object)data), nodes::get), () -> Collections3.transformedImmutableSetCopy((Collection)this.successors.get((Object)data), nodes::get), this.idToNodeMap, this.shutdownNotifier);
                nodes.put(data, blockNode);
            }
            return new BlockGraph((BlockNode)nodes.get(this.root), this);
        }

        public BlockGraph merge(int desiredNumberOfBlocks) throws InterruptedException {
            Optional<BlockNode.BlockNodeMetaData> potentialNode;
            LinkedHashSet<BlockNode.BlockNodeMetaData> nodes = new LinkedHashSet<BlockNode.BlockNodeMetaData>(this.blocks);
            nodes.remove(this.root);
            ArrayListMultimap compatibleBlocks = ArrayListMultimap.create();
            nodes.forEach(arg_0 -> BlockGraphFactory.lambda$merge$8((Multimap)compatibleBlocks, arg_0));
            for (Pair key : ImmutableSet.copyOf((Collection)compatibleBlocks.keySet())) {
                ArrayList mergeNodes = new ArrayList(compatibleBlocks.removeAll((Object)key));
                if (nodes.size() <= desiredNumberOfBlocks) break;
                if (mergeNodes.size() <= 1) continue;
                BlockNode.BlockNodeMetaData current = (BlockNode.BlockNodeMetaData)mergeNodes.remove(0);
                nodes.remove(current);
                for (int i = mergeNodes.size() - 1; i >= 0; --i) {
                    BlockNode.BlockNodeMetaData remove = (BlockNode.BlockNodeMetaData)mergeNodes.remove(i);
                    nodes.remove(remove);
                    current = this.mergeSameStartAndEnd(current, remove);
                }
                nodes.add(current);
                compatibleBlocks.put((Object)key, (Object)current);
            }
            LinkedHashSet<BlockNode.BlockNodeMetaData> alreadyFound = new LinkedHashSet<BlockNode.BlockNodeMetaData>();
            while (desiredNumberOfBlocks < nodes.size() && !(potentialNode = nodes.stream().filter(n -> this.successors.get(n).size() == 1 && !alreadyFound.contains(n)).findAny()).isEmpty()) {
                BlockNode.BlockNodeMetaData singleSuccessor;
                BlockNode.BlockNodeMetaData node = potentialNode.orElseThrow();
                alreadyFound.add(node);
                if (node.equals(this.root) || this.predecessors.get((Object)(singleSuccessor = (BlockNode.BlockNodeMetaData)Iterables.getOnlyElement((Iterable)this.successors.get((Object)node)))).size() != 1) continue;
                BlockNode.BlockNodeMetaData merged = this.mergeSingleSuccessors(node, singleSuccessor);
                nodes.remove(node);
                nodes.remove(singleSuccessor);
                nodes.add(merged);
            }
            return this.build();
        }

        private static /* synthetic */ void lambda$merge$8(Multimap compatibleBlocks, BlockNode.BlockNodeMetaData n) {
            compatibleBlocks.put(Pair.of(n.getStartNode(), n.getLastNode()), (Object)n);
        }
    }
}

