/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class BlockNode {
    private final BlockNodeMetaData metaData;
    private final Supplier<Set<BlockNode>> predecessors;
    private final Supplier<Set<BlockNode>> successors;
    private final Map<Integer, CFANode> idToNodeMap;
    private final String code;

    BlockNode(@NonNull BlockNodeMetaData pMetaData, @NonNull Supplier<Set<BlockNode>> pPredecessors, @NonNull Supplier<Set<BlockNode>> pSuccessors, @NonNull Map<Integer, CFANode> pIdToNodeMap, @NonNull ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        Preconditions.checkArgument((boolean)CFAUtils.existsPath(pMetaData.getStartNode(), pMetaData.getLastNode(), node -> CFAUtils.leavingEdges(node).toSet(), pShutdownNotifier), (String)"pNodesInBlock (%s) must list all nodes but misses either the root node (%s) or the last node (%s).", pMetaData.getNodesInBlock(), (Object)pMetaData.getStartNode(), (Object)pMetaData.getLastNode());
        Preconditions.checkArgument((boolean)this.isBlockNodeValid(pMetaData.getStartNode(), pMetaData.getEdgesInBlock()), (Object)"BlockNodes require to have exactly one exit node.");
        this.metaData = pMetaData;
        this.predecessors = pPredecessors;
        this.successors = pSuccessors;
        this.idToNodeMap = pIdToNodeMap;
        this.code = this.getCodeRepresentation();
    }

    private boolean isBlockNodeValid(CFANode pStartNode, Set<CFAEdge> pEdgesInBlock) {
        ArrayDeque<CFANode> waiting = new ArrayDeque<CFANode>();
        waiting.push(pStartNode);
        LinkedHashSet<CFANode> covered = new LinkedHashSet<CFANode>();
        int count = 0;
        while (!waiting.isEmpty()) {
            CFANode curr = (CFANode)waiting.pop();
            boolean hasSuccessor = false;
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(curr)) {
                if (!pEdgesInBlock.contains(leavingEdge)) continue;
                if (covered.contains(leavingEdge.getSuccessor())) {
                    waiting.push(leavingEdge.getSuccessor());
                }
                hasSuccessor = true;
            }
            if (!hasSuccessor) {
                ++count;
            }
            covered.add(curr);
        }
        return count <= 1;
    }

    public CFANode getNodeWithNumber(int number) {
        return this.idToNodeMap.get(number);
    }

    private String getCodeRepresentation() {
        StringBuilder codeLines = new StringBuilder();
        for (CFAEdge leavingEdge : this.metaData.getEdgesInBlock()) {
            if (leavingEdge.getCode().isBlank()) continue;
            if (leavingEdge.getEdgeType().equals((Object)CFAEdgeType.AssumeEdge)) {
                codeLines.append("[").append(leavingEdge.getCode()).append("]\n");
                continue;
            }
            codeLines.append(leavingEdge.getCode()).append("\n");
        }
        return codeLines.toString();
    }

    public boolean isSelfCircular() {
        return this.metaData.getLastNode().equals(this.metaData.getStartNode()) && !this.isEmpty() && !this.isRoot();
    }

    public boolean isEmpty() {
        return this.metaData.getEdgesInBlock().isEmpty();
    }

    public Set<BlockNode> getPredecessors() {
        return ImmutableSet.copyOf((Collection)this.predecessors.get());
    }

    public Set<BlockNode> getSuccessors() {
        return ImmutableSet.copyOf((Collection)this.successors.get());
    }

    public CFANode getStartNode() {
        return this.metaData.getStartNode();
    }

    public CFANode getLastNode() {
        return this.metaData.getLastNode();
    }

    public Set<CFANode> getNodesInBlock() {
        return ImmutableSet.copyOf(this.metaData.getNodesInBlock());
    }

    public Set<CFAEdge> getEdgesInBlock() {
        return ImmutableSet.copyOf(this.metaData.getEdgesInBlock());
    }

    public boolean equals(Object pO) {
        if (!(pO instanceof BlockNode)) {
            return false;
        }
        BlockNode blockNode = (BlockNode)pO;
        return this.getId().equals(blockNode.getId());
    }

    public int hashCode() {
        return Objects.hash(this.metaData.getId());
    }

    public String toString() {
        return "BlockNode{id='" + this.getId() + "', startNode=" + this.getStartNode() + ", lastNode=" + this.getLastNode() + ", size=" + this.getNodesInBlock().size() + ", code='" + this.code.replaceAll("\n", "") + "'}";
    }

    public String getCode() {
        return this.code;
    }

    public String getId() {
        return this.metaData.getId();
    }

    public boolean isRoot() {
        return this.predecessors.get().isEmpty();
    }

    static class BlockNodeMetaData {
        private final String id;
        private final CFANode startNode;
        private final CFANode lastNode;
        private final Set<CFANode> nodesInBlock;
        private final Set<CFAEdge> edgesInBlock;
        private final Map<Integer, CFANode> idToNodeMap;

        BlockNodeMetaData(String pId, CFANode pStartNode, CFANode pLastNode, Set<CFANode> pNodesInBlock, Set<CFAEdge> pEdgesInBlock, Map<Integer, CFANode> pIdToNodeMap) {
            this.id = pId;
            this.startNode = pStartNode;
            this.lastNode = pLastNode;
            this.nodesInBlock = pNodesInBlock;
            this.edgesInBlock = pEdgesInBlock;
            this.idToNodeMap = pIdToNodeMap;
        }

        public CFANode getLastNode() {
            return this.lastNode;
        }

        public CFANode getStartNode() {
            return this.startNode;
        }

        public Map<Integer, CFANode> getIdToNodeMap() {
            return this.idToNodeMap;
        }

        public Set<CFAEdge> getEdgesInBlock() {
            return this.edgesInBlock;
        }

        public Set<CFANode> getNodesInBlock() {
            return this.nodesInBlock;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object pO) {
            if (!(pO instanceof BlockNodeMetaData)) {
                return false;
            }
            BlockNodeMetaData that = (BlockNodeMetaData)pO;
            return Objects.equals(this.id, that.id) && Objects.equals(this.startNode, that.startNode) && Objects.equals(this.lastNode, that.lastNode) && Objects.equals(this.nodesInBlock, that.nodesInBlock) && Objects.equals(this.edgesInBlock, that.edgesInBlock) && Objects.equals(this.idToNodeMap, that.idToNodeMap);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.startNode, this.lastNode, this.nodesInBlock, this.edgesInBlock, this.idToNodeMap);
        }
    }
}

