/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.CFADecomposer;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;

public class BlockOperatorDecomposer
implements CFADecomposer {
    private final BlockOperator operator = new BlockOperator();
    private final ShutdownNotifier shutdownNotifier;

    public BlockOperatorDecomposer(Configuration pConfiguration, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this.operator);
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public BlockGraph cut(CFA cfa) throws InterruptedException {
        this.operator.setCFA(cfa);
        FunctionEntryNode startNode = cfa.getMainFunction();
        BlockGraph.BlockGraphFactory factory = new BlockGraph.BlockGraphFactory(cfa, this.shutdownNotifier);
        BlockNode.BlockNodeMetaData root = factory.makeBlock(startNode, startNode, (Set<CFANode>)ImmutableSet.of((Object)startNode), (Set<CFAEdge>)ImmutableSet.of());
        factory.setRoot(root);
        ArrayDeque<CFANode> blockEnds = new ArrayDeque<CFANode>();
        blockEnds.push(startNode);
        ArrayListMultimap lastNodeMap = ArrayListMultimap.create();
        lastNodeMap.put((Object)startNode, (Object)root);
        ArrayListMultimap startNodeMap = ArrayListMultimap.create();
        startNodeMap.put((Object)startNode, (Object)root);
        LinkedHashSet<CFANode> coveredBlockEnds = new LinkedHashSet<CFANode>();
        ArrayDeque<Entry> toSearch = new ArrayDeque<Entry>();
        while (!blockEnds.isEmpty()) {
            CFANode lastCFANode = (CFANode)blockEnds.pop();
            if (coveredBlockEnds.contains(lastCFANode)) continue;
            coveredBlockEnds.add(lastCFANode);
            CFANode currentRootNode = lastCFANode;
            CFAUtils.leavingEdges(lastCFANode).transform(edge -> new Entry(edge.getSuccessor(), new LinkedHashSet<CFANode>((Collection<CFANode>)ImmutableList.of((Object)currentRootNode, (Object)edge.getSuccessor())), new LinkedHashSet<CFAEdge>((Collection<CFAEdge>)ImmutableList.of((Object)edge)), 0)).copyInto(toSearch);
            while (!toSearch.isEmpty()) {
                Entry nodeEntry = (Entry)toSearch.pop();
                CFANode successorOfCurrNode = nodeEntry.getNode();
                if (this.operator.isBlockEnd(successorOfCurrNode, nodeEntry.getThreshold())) {
                    blockEnds.push(successorOfCurrNode);
                    BlockNode.BlockNodeMetaData childBlockNode = factory.makeBlock(lastCFANode, successorOfCurrNode, nodeEntry.getSeen(), nodeEntry.getSeenEdges());
                    lastNodeMap.get((Object)lastCFANode).forEach(contained -> factory.linkSuccessor((BlockNode.BlockNodeMetaData)contained, childBlockNode));
                    startNodeMap.get((Object)successorOfCurrNode).forEach(contained -> factory.linkSuccessor(childBlockNode, (BlockNode.BlockNodeMetaData)contained));
                    if (childBlockNode.getStartNode().equals(childBlockNode.getLastNode())) {
                        factory.linkSuccessor(childBlockNode, childBlockNode);
                    }
                    lastNodeMap.put((Object)successorOfCurrNode, (Object)childBlockNode);
                    startNodeMap.put((Object)lastCFANode, (Object)childBlockNode);
                    continue;
                }
                for (CFANode successor : CFAUtils.successorsOf(successorOfCurrNode)) {
                    LinkedHashSet<CFANode> seen = new LinkedHashSet<CFANode>(nodeEntry.getSeen());
                    LinkedHashSet<CFAEdge> seenEdge = new LinkedHashSet<CFAEdge>(nodeEntry.getSeenEdges());
                    seen.add(successor);
                    for (CFAEdge leavingEdge : CFAUtils.leavingEdges(successorOfCurrNode)) {
                        if (!leavingEdge.getSuccessor().equals(successor)) continue;
                        seenEdge.add(leavingEdge);
                        break;
                    }
                    toSearch.add(new Entry(successor, seen, seenEdge, nodeEntry.getThreshold() + 1));
                }
            }
        }
        return factory.build();
    }

    private static class Entry {
        private final CFANode node;
        private final Set<CFANode> seen;
        private final Set<CFAEdge> seenEdges;
        private final int threshold;

        public Entry(CFANode pNode, Set<CFANode> pSeen, Set<CFAEdge> pSeenEdges, int pThreshold) {
            this.node = pNode;
            this.seen = new LinkedHashSet<CFANode>(pSeen);
            this.seenEdges = new LinkedHashSet<CFAEdge>(pSeenEdges);
            this.threshold = pThreshold;
        }

        public boolean equals(Object pO) {
            if (pO instanceof Entry) {
                Entry entry = (Entry)pO;
                return Objects.equals(this.node, entry.getNode()) && Objects.equals(this.seen, entry.getSeen());
            }
            return false;
        }

        public Set<CFANode> getSeen() {
            return this.seen;
        }

        public CFANode getNode() {
            return this.node;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public Set<CFAEdge> getSeenEdges() {
            return this.seenEdges;
        }

        public int hashCode() {
            return Objects.hash(this.node, this.seen);
        }
    }
}

