/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition;

import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.CFADecomposer;

public class GivenSizeDecomposer
implements CFADecomposer {
    private final CFADecomposer decomposer;
    private final int desiredNumberOfBlocks;

    public GivenSizeDecomposer(CFADecomposer pDecomposer, int pDesiredNumber) throws InvalidConfigurationException {
        this.decomposer = pDecomposer;
        this.desiredNumberOfBlocks = pDesiredNumber;
    }

    @Override
    public BlockGraph cut(CFA cfa) throws InterruptedException {
        int newSize;
        BlockGraph blockGraph = this.decomposer.cut(cfa);
        int oldSize = blockGraph.getDistinctNodes().size();
        while (oldSize >= this.desiredNumberOfBlocks && (newSize = (blockGraph = BlockGraph.merge(blockGraph, this.desiredNumberOfBlocks)).getDistinctNodes().size()) != oldSize) {
            oldSize = newSize;
        }
        return blockGraph;
    }
}

