/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.CFADecomposer;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SingleBlockDecomposer
implements CFADecomposer {
    private final ShutdownNotifier shutdownNotifier;

    public SingleBlockDecomposer(ShutdownNotifier pShutdownNotifier) {
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public BlockGraph cut(CFA cfa) throws InterruptedException {
        BlockGraph.BlockGraphFactory builder = new BlockGraph.BlockGraphFactory(cfa, this.shutdownNotifier);
        FunctionEntryNode startNode = cfa.getMainFunction();
        CFANode lastNode = CFANode.newDummyCFANode();
        LinkedHashSet<CFAEdge> edges = new LinkedHashSet<CFAEdge>();
        for (CFANode allNode : cfa.getAllNodes()) {
            CFAUtils.leavingEdges(allNode).copyInto(edges);
            CFAUtils.enteringEdges(allNode).copyInto(edges);
        }
        LinkedHashSet<CFANode> nodes = new LinkedHashSet<CFANode>(cfa.getAllNodes());
        nodes.add(lastNode);
        BlockNode.BlockNodeMetaData root = builder.makeBlock(startNode, startNode, (Set<CFANode>)ImmutableSet.of((Object)startNode), (Set<CFAEdge>)ImmutableSet.of());
        BlockNode.BlockNodeMetaData workerBlock = builder.makeBlock(startNode, lastNode, nodes, edges);
        builder.setRoot(root);
        builder.linkSuccessor(root, workerBlock);
        return builder.build();
    }
}

