/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;

public class BlockSummaryMessageProcessing
extends ForwardingCollection<BlockSummaryMessage> {
    private final Collection<BlockSummaryMessage> messages;
    private final boolean end;
    private static final BlockSummaryMessageProcessing EMPTY_PROCEED = new BlockSummaryMessageProcessing((Collection<BlockSummaryMessage>)ImmutableList.of(), false);
    private static final BlockSummaryMessageProcessing EMPTY_STOP = new BlockSummaryMessageProcessing((Collection<BlockSummaryMessage>)ImmutableList.of(), true);

    private BlockSummaryMessageProcessing(Collection<BlockSummaryMessage> pMessages, boolean pEnd) {
        this.messages = pMessages;
        this.end = pEnd;
    }

    public static BlockSummaryMessageProcessing proceed() {
        return EMPTY_PROCEED;
    }

    public static BlockSummaryMessageProcessing stop() {
        return EMPTY_STOP;
    }

    public static BlockSummaryMessageProcessing proceedWith(Collection<BlockSummaryMessage> pMessages) {
        return new BlockSummaryMessageProcessing(pMessages, false);
    }

    public static BlockSummaryMessageProcessing stopWith(Collection<BlockSummaryMessage> pMessages) {
        return new BlockSummaryMessageProcessing(pMessages, true);
    }

    public static BlockSummaryMessageProcessing proceedWith(BlockSummaryMessage ... pMessages) {
        return new BlockSummaryMessageProcessing((Collection<BlockSummaryMessage>)ImmutableList.copyOf((Object[])pMessages), false);
    }

    public static BlockSummaryMessageProcessing stopWith(BlockSummaryMessage ... pMessages) {
        return new BlockSummaryMessageProcessing((Collection<BlockSummaryMessage>)ImmutableList.copyOf((Object[])pMessages), true);
    }

    public boolean end() {
        return this.end;
    }

    public BlockSummaryMessageProcessing merge(BlockSummaryMessageProcessing pProcessing, boolean removeDuplicates) {
        AbstractCollection copy = removeDuplicates ? new LinkedHashSet<BlockSummaryMessage>(this.messages) : new ArrayList<BlockSummaryMessage>(this.messages);
        copy.addAll((Collection<BlockSummaryMessage>)((Object)pProcessing));
        return new BlockSummaryMessageProcessing(copy, this.end || pProcessing.end);
    }

    protected Collection<BlockSummaryMessage> delegate() {
        return this.messages;
    }
}

