/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.callstack;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.operators.DeserializeOperator;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;

public class DeserializeCallstackStateOperator
implements DeserializeOperator {
    private final CallstackCPA parentCPA;
    private final BlockNode block;

    public DeserializeCallstackStateOperator(CallstackCPA pParentCPA, BlockNode pBlockNode) {
        this.parentCPA = pParentCPA;
        this.block = pBlockNode;
    }

    @Override
    public AbstractState deserialize(BlockSummaryMessage pMessage) {
        Optional<String> state = pMessage.getAbstractStateString(this.parentCPA.getClass());
        if (state.isEmpty()) {
            return this.parentCPA.getInitialState(this.block.getNodeWithNumber(pMessage.getTargetNodeNumber()), StateSpacePartition.getDefaultPartition());
        }
        String callstackJSON = state.orElse("");
        if (callstackJSON.isBlank()) {
            return this.parentCPA.getInitialState(this.block.getNodeWithNumber(pMessage.getTargetNodeNumber()), StateSpacePartition.getDefaultPartition());
        }
        List parts = Splitter.on((String)",  ").splitToList((CharSequence)callstackJSON);
        CallstackState previous = null;
        for (String part : parts) {
            List properties = Splitter.on((String)".").limit(2).splitToList((CharSequence)part);
            previous = new CallstackState(previous, (String)properties.get(1), this.block.getNodeWithNumber(Integer.parseInt((String)properties.get(0))));
        }
        return previous;
    }
}

