/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.function_pointer;

import com.google.common.base.Splitter;
import java.util.List;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.operators.DeserializeOperator;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerCPA;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerState;

public class DeserializeFunctionPointerStateOperator
implements DeserializeOperator {
    private final BlockNode block;
    private final FunctionPointerCPA functionPointerCPA;

    public DeserializeFunctionPointerStateOperator(FunctionPointerCPA pFunctionPointerCPA, BlockNode pBlockNode) {
        this.block = pBlockNode;
        this.functionPointerCPA = pFunctionPointerCPA;
    }

    @Override
    public AbstractState deserialize(BlockSummaryMessage pMessage) {
        String serialized = pMessage.getAbstractStateString(this.functionPointerCPA.getClass()).orElse("");
        if (serialized.isBlank()) {
            return this.functionPointerCPA.getInitialState(this.block.getNodeWithNumber(pMessage.getTargetNodeNumber()), StateSpacePartition.getDefaultPartition());
        }
        FunctionPointerState.Builder builder = FunctionPointerState.createEmptyState().createBuilder();
        block10: for (String s : Splitter.on((String)", ").splitToList((CharSequence)serialized)) {
            if (s.isBlank()) continue;
            List parts = Splitter.on((String)":").limit(3).splitToList((CharSequence)s);
            assert (parts.size() >= 2);
            switch ((String)parts.get(0)) {
                case "I": {
                    builder.setTarget((String)parts.get(1), FunctionPointerState.InvalidTarget.getInstance());
                    continue block10;
                }
                case "U": {
                    builder.setTarget((String)parts.get(1), FunctionPointerState.UnknownTarget.getInstance());
                    continue block10;
                }
                case "N": {
                    builder.setTarget((String)parts.get(1), new FunctionPointerState.NamedFunctionTarget((String)parts.get(2)));
                    continue block10;
                }
            }
            throw new AssertionError((Object)"Unknwon FunctionPointerState");
        }
        return builder.build();
    }
}

