/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.predicate;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.BlockSummaryMessageProcessing;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.DistributedConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.operators.DeserializeOperator;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.operators.proceed.ProceedOperator;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

public class ProceedPredicateStateOperator
implements ProceedOperator {
    private final AnalysisDirection direction;
    private final BlockSummaryAnalysisOptions analysisOptions;
    private final BlockNode block;
    private final Solver solver;
    private final DeserializeOperator deserialize;
    private final Set<String> unsatPredecessors;
    private final Map<String, BlockSummaryMessage> receivedPostConditions;
    private final FormulaManagerView fmgr;
    private BlockSummaryPostConditionMessage latestOwnPostConditionMessage;
    private PathFormula latestOwnPostCondition;

    public ProceedPredicateStateOperator(BlockSummaryAnalysisOptions pOptions, AnalysisDirection pDirection, BlockNode pBlockNode, Solver pSolver, DeserializeOperator pDeserializeOperator) {
        this.direction = pDirection;
        this.analysisOptions = pOptions;
        this.block = pBlockNode;
        this.solver = pSolver;
        this.fmgr = this.solver.getFormulaManager();
        this.deserialize = pDeserializeOperator;
        this.unsatPredecessors = new LinkedHashSet<String>();
        this.receivedPostConditions = new HashMap<String, BlockSummaryMessage>();
    }

    @Override
    public BlockSummaryMessageProcessing proceed(BlockSummaryMessage pMessage) throws InterruptedException, SolverException {
        return this.direction == AnalysisDirection.FORWARD ? this.proceedForward((BlockSummaryPostConditionMessage)pMessage) : this.proceedBackward((BlockSummaryErrorConditionMessage)pMessage);
    }

    @Override
    public BlockSummaryMessageProcessing proceedBackward(BlockSummaryErrorConditionMessage message) throws SolverException, InterruptedException {
        BooleanFormula check;
        CFANode node = this.block.getNodeWithNumber(message.getTargetNodeNumber());
        if (!node.equals(this.block.getLastNode()) && (node.equals(this.block.getLastNode()) || node.equals(this.block.getStartNode()) || !this.block.getNodesInBlock().contains(node))) {
            return BlockSummaryMessageProcessing.stop();
        }
        PredicateAbstractState deserialized = (PredicateAbstractState)this.deserialize.deserialize(message);
        PathFormula messageFormula = deserialized.getPathFormula();
        if (this.analysisOptions.shouldCheckEveryErrorConditionForUnsatisfiability() && this.solver.isUnsat(messageFormula.getFormula())) {
            return BlockSummaryMessageProcessing.stopWith(BlockSummaryMessage.newErrorConditionUnreachableMessage(this.block.getId(), "unsat-formula: " + messageFormula));
        }
        if (this.latestOwnPostConditionMessage != null && (this.receivedPostConditions.size() <= 3 || this.analysisOptions.shouldCheckEveryErrorConditionForUnsatisfiability()) && this.receivedPostConditions.size() + this.unsatPredecessors.size() == this.block.getPredecessors().size() && this.solver.isUnsat(check = this.concatenate(this.latestOwnPostCondition, messageFormula))) {
            return BlockSummaryMessageProcessing.stopWith(BlockSummaryMessage.newErrorConditionUnreachableMessage(this.block.getId(), "unsat-with-last-post: " + check));
        }
        return BlockSummaryMessageProcessing.proceedWith(message);
    }

    @Override
    public BlockSummaryMessageProcessing proceedForward(BlockSummaryPostConditionMessage message) throws InterruptedException {
        CFANode node = this.block.getNodeWithNumber(message.getTargetNodeNumber());
        if (!this.block.getStartNode().equals(node)) {
            return BlockSummaryMessageProcessing.stop();
        }
        if (!message.isReachable()) {
            this.unsatPredecessors.add(message.getUniqueBlockId());
            return BlockSummaryMessageProcessing.stop();
        }
        PredicateAbstractState state = (PredicateAbstractState)this.deserialize.deserialize(message);
        try {
            if (this.solver.isUnsat(state.getPathFormula().getFormula())) {
                this.receivedPostConditions.remove(message.getUniqueBlockId());
                this.unsatPredecessors.add(message.getUniqueBlockId());
                return BlockSummaryMessageProcessing.stop();
            }
        }
        catch (SolverException pE) {
            return BlockSummaryMessageProcessing.stopWith(BlockSummaryMessage.newErrorMessage(this.block.getId(), pE));
        }
        this.unsatPredecessors.remove(message.getUniqueBlockId());
        this.storePostCondition(message);
        if (this.receivedPostConditions.size() + this.unsatPredecessors.size() == this.block.getPredecessors().size()) {
            return BlockSummaryMessageProcessing.proceedWith(this.receivedPostConditions.values());
        }
        return BlockSummaryMessageProcessing.stop();
    }

    private void storePostCondition(BlockSummaryPostConditionMessage pMessage) {
        BlockSummaryMessage toStore = BlockSummaryMessage.removeEntry(pMessage, "smart");
        if (this.analysisOptions.shouldAlwaysStoreCircularPostConditions() && pMessage.visitedBlockIds().stream().anyMatch(s -> s.equals(this.block.getId()))) {
            if (pMessage.representsFullPath()) {
                this.receivedPostConditions.put(pMessage.getUniqueBlockId(), toStore);
            } else {
                this.receivedPostConditions.remove(pMessage.getUniqueBlockId());
            }
        } else {
            this.receivedPostConditions.put(pMessage.getUniqueBlockId(), toStore);
        }
    }

    private BooleanFormula concatenate(PathFormula pLatestPostCondition, PathFormula pErrorCondition) {
        SSAMap ssaMap = pLatestPostCondition.getSsa();
        SSAMap formulaMap = pErrorCondition.getSsa();
        HashMap<Formula, Formula> substitution = new HashMap<Formula, Formula>();
        for (Map.Entry<String, Formula> stringFormulaEntry : this.fmgr.extractVariables((Formula)pErrorCondition.getFormula()).entrySet()) {
            Pair<String, OptionalInt> parsed = FormulaManagerView.parseName(stringFormulaEntry.getKey());
            String varName = parsed.getFirstNotNull();
            if (!ssaMap.containsVariable(varName)) continue;
            int index = parsed.getSecondNotNull().orElseThrow();
            SSAMap.SSAMapBuilder curr = SSAMap.emptySSAMap().builder();
            curr = curr.setIndex(varName, formulaMap.getType(varName), Math.abs(index - pErrorCondition.getSsa().getIndex(varName)) + ssaMap.getIndex(varName));
            substitution.put(stringFormulaEntry.getValue(), this.fmgr.instantiate(this.fmgr.uninstantiate(stringFormulaEntry.getValue()), curr.build()));
        }
        return this.fmgr.getBooleanFormulaManager().and(pLatestPostCondition.getFormula(), this.fmgr.substitute(pErrorCondition.getFormula(), substitution));
    }

    @Override
    public void synchronizeKnowledge(DistributedConfigurableProgramAnalysis pDCPA) throws InterruptedException {
        ProceedPredicateStateOperator proceed = (ProceedPredicateStateOperator)pDCPA.getProceedOperator();
        if (this.direction == AnalysisDirection.BACKWARD) {
            if (proceed.latestOwnPostConditionMessage != null) {
                this.update(proceed.latestOwnPostConditionMessage);
            }
            this.unsatPredecessors.clear();
            this.unsatPredecessors.addAll(proceed.unsatPredecessors);
            this.receivedPostConditions.clear();
            this.receivedPostConditions.putAll(proceed.receivedPostConditions);
        }
    }

    @Override
    public void update(BlockSummaryPostConditionMessage pLatestOwnPreconditionMessage) throws InterruptedException {
        this.latestOwnPostConditionMessage = pLatestOwnPreconditionMessage;
        this.latestOwnPostCondition = ((PredicateAbstractState)this.deserialize.deserialize(this.latestOwnPostConditionMessage)).getPathFormula();
    }
}

