/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.predicate;

import java.io.IOException;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.operators.SerializeOperator;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryMessagePayload;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.SerializeUtil;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;

public class SerializePredicateStateOperator
implements SerializeOperator {
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView formulaManagerView;

    public SerializePredicateStateOperator(PathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManagerView) {
        this.pathFormulaManager = pPathFormulaManager;
        this.formulaManagerView = pFormulaManagerView;
    }

    @Override
    public BlockSummaryMessagePayload serialize(AbstractState pState) {
        String pts;
        String ssa;
        PathFormula pathFormula;
        PredicateAbstractState state = (PredicateAbstractState)pState;
        if (state.isAbstractionState()) {
            if (state.getAbstractionFormula().isTrue()) {
                pathFormula = state.getAbstractionFormula().getBlockFormula();
            } else {
                pathFormula = this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(state.getAbstractionFormula().getBlockFormula());
                pathFormula = this.pathFormulaManager.makeAnd(pathFormula, state.getAbstractionFormula().asFormula());
            }
        } else {
            pathFormula = state.getPathFormula();
        }
        String formula = this.formulaManagerView.dumpFormula(pathFormula.getFormula()).toString();
        try {
            ssa = SerializeUtil.serialize(pathFormula.getSsa());
            pts = SerializeUtil.serialize(state.getPathFormula().getPointerTargetSet());
        }
        catch (IOException pE) {
            throw new AssertionError((Object)("Unable to serialize SSAMap " + pathFormula.getSsa()));
        }
        return new BlockSummaryMessagePayload.Builder().addEntry(PredicateCPA.class.getName(), formula).addEntry("ssa", ssa).addEntry("pts", pts).buildPayload();
    }
}

