/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.JSON;

public class BlockSummaryMessagePayload
extends ForwardingMap<String, Object> {
    public static final String FULL_PATH = "full";
    public static final String FIRST = "first";
    public static final String RESULT = "result";
    public static final String VISITED = "visited";
    public static final String EXCEPTION = "exception";
    public static final String REACHABLE = "reach";
    public static final String SMART = "smart";
    public static final String REASON = "reason";
    public static final String FAULT_LOCALIZATION = "fl";
    public static final String SOUND = "sound";
    public static final String PRECISE = "precise";
    public static final String PROPERTY = "property";
    public static final String SSA = "ssa";
    public static final String PTS = "pts";
    private final Map<String, Object> delegate;

    private BlockSummaryMessagePayload(Map<String, Object> pDelegate) {
        this.delegate = ImmutableMap.copyOf(pDelegate);
    }

    public static BlockSummaryMessagePayload empty() {
        return new BlockSummaryMessagePayload((Map<String, Object>)ImmutableMap.of());
    }

    public String toJSONString() throws IOException {
        StringBuilder builder = new StringBuilder();
        JSON.writeJSONString(this.delegate, (Appendable)builder);
        return builder.toString();
    }

    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static class Builder
    extends ImmutableMap.Builder<String, Object> {
        @CanIgnoreReturnValue
        public Builder addEntriesFromJSON(String json) throws JsonProcessingException {
            TypeFactory factory = TypeFactory.defaultInstance();
            MapType type = factory.constructMapType(HashMap.class, String.class, Object.class);
            ObjectMapper mapper = new ObjectMapper();
            Map result = (Map)mapper.readValue(json, (JavaType)type);
            this.putAll(result);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEntry(String key, Object value) {
            this.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEntries(Map<String, Object> entries) {
            this.putAll(entries);
            return this;
        }

        public BlockSummaryMessagePayload buildPayload() {
            return new BlockSummaryMessagePayload((Map<String, Object>)this.buildOrThrow());
        }
    }
}

