/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ForwardingBlockingQueue;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;

public class BlockSummarySortedMessageQueue
extends ForwardingBlockingQueue<BlockSummaryMessage> {
    private final BlockingQueue<BlockSummaryMessage> queue;
    private final Multimap<BlockSummaryMessage.MessageType, BlockSummaryMessage> messages;
    private final BlockSummaryMessage.MessageType[] ordering;

    private BlockSummarySortedMessageQueue(BlockingQueue<BlockSummaryMessage> pQueue) {
        this.queue = pQueue;
        this.messages = ArrayListMultimap.create();
        this.ordering = new BlockSummaryMessage.MessageType[]{BlockSummaryMessage.MessageType.FOUND_RESULT, BlockSummaryMessage.MessageType.ERROR, BlockSummaryMessage.MessageType.ERROR_CONDITION, BlockSummaryMessage.MessageType.ERROR_CONDITION_UNREACHABLE, BlockSummaryMessage.MessageType.BLOCK_POSTCONDITION};
    }

    public BlockSummarySortedMessageQueue() {
        this(new LinkedBlockingQueue<BlockSummaryMessage>());
    }

    protected BlockingQueue<BlockSummaryMessage> delegate() {
        return this.queue;
    }

    public void setOrdering(BlockSummaryMessage.MessageType ... pOrdering) {
        assert (pOrdering.length == this.ordering.length) : "please provide all types for the ordering";
        System.arraycopy(pOrdering, 0, this.ordering, 0, pOrdering.length);
    }

    private void moveToMap(BlockSummaryMessage pMessage) {
        this.messages.put((Object)pMessage.getType(), (Object)pMessage);
    }

    private Optional<BlockSummaryMessage> firstOfType(BlockSummaryMessage.MessageType pType) {
        if (!this.messages.get((Object)pType).isEmpty()) {
            Optional<BlockSummaryMessage> optionalMessage = this.messages.get((Object)pType).stream().findFirst();
            this.messages.remove((Object)pType, optionalMessage.orElseThrow());
            return optionalMessage;
        }
        return Optional.empty();
    }

    public BlockSummaryMessage take() throws InterruptedException {
        while (!this.queue.isEmpty()) {
            this.moveToMap(this.queue.take());
        }
        for (BlockSummaryMessage.MessageType messageType : this.ordering) {
            Optional<BlockSummaryMessage> m = this.firstOfType(messageType);
            if (!m.isPresent()) continue;
            return m.orElseThrow();
        }
        return this.queue.take();
    }
}

