/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class SerializeUtil {
    public static <T extends Serializable> String serialize(T pObject) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(pObject);
                out.flush();
                string = Base64.getEncoder().encodeToString(bos.toByteArray());
            }
            return string;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserialize(String pSerialize, Class<T> pClass) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(pSerialize));){
            Serializable serializable;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                serializable = (Serializable)pClass.cast(in.readObject());
            }
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException pE) {
            throw new AssertionError((Object)pE);
        }
    }
}

