/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryMessagePayload;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionUnreachableMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryResultMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryObserverWorker;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;

public abstract class BlockSummaryMessage
implements Comparable<BlockSummaryMessage> {
    private final int targetNodeNumber;
    private final String uniqueBlockId;
    private final MessageType type;
    private final BlockSummaryMessagePayload payload;
    private final Instant timestamp;

    protected BlockSummaryMessage(MessageType pType, String pUniqueBlockId, int pTargetNodeNumber, BlockSummaryMessagePayload pPayload, Instant pTimeStamp) {
        this.targetNodeNumber = pTargetNodeNumber;
        this.type = pType;
        this.payload = pPayload;
        this.uniqueBlockId = pUniqueBlockId;
        this.timestamp = pTimeStamp;
    }

    public static BlockSummaryMessage addEntry(BlockSummaryMessage message, String key, String value) {
        return message.replacePayload(new BlockSummaryMessagePayload.Builder().addAllEntries((Map<String, Object>)((Object)message.getPayload())).addEntry(key, value).buildPayload());
    }

    public static BlockSummaryMessage removeEntry(BlockSummaryMessage message, String key) {
        HashMap<String, Object> copy = new HashMap<String, Object>((Map<String, Object>)((Object)message.getPayload()));
        copy.remove(key);
        return message.replacePayload(new BlockSummaryMessagePayload.Builder().addAllEntries(copy).buildPayload());
    }

    public final String getPayloadJSON() throws IOException {
        return this.payload.toJSONString();
    }

    public Optional<String> getAbstractStateString(Class<? extends ConfigurableProgramAnalysis> pKey) {
        Object value = this.getPayload().get(pKey.getName());
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(value.toString());
    }

    public Optional<Algorithm.AlgorithmStatus> getOptionalStatus() {
        if (!(this.payload.containsKey("precise") && this.payload.containsKey("property") && this.payload.containsKey("sound"))) {
            return Optional.empty();
        }
        BlockSummaryObserverWorker.StatusObserver.StatusPrecise isPrecise = BlockSummaryObserverWorker.StatusObserver.StatusPrecise.valueOf((String)this.payload.get("precise"));
        BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked isPropertyChecked = BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked.valueOf((String)this.payload.get("property"));
        BlockSummaryObserverWorker.StatusObserver.StatusSoundness isSound = BlockSummaryObserverWorker.StatusObserver.StatusSoundness.valueOf((String)this.payload.get("sound"));
        return Optional.of(this.statusOf(isPropertyChecked, isSound, isPrecise));
    }

    private Algorithm.AlgorithmStatus statusOf(BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked pPropertyChecked, BlockSummaryObserverWorker.StatusObserver.StatusSoundness pIsSound, BlockSummaryObserverWorker.StatusObserver.StatusPrecise pIsPrecise) {
        if (pPropertyChecked == BlockSummaryObserverWorker.StatusObserver.StatusPropertyChecked.UNCHECKED) {
            return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
        }
        if (pIsSound == BlockSummaryObserverWorker.StatusObserver.StatusSoundness.SOUND) {
            if (pIsPrecise == BlockSummaryObserverWorker.StatusObserver.StatusPrecise.PRECISE) {
                return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
            }
            return Algorithm.AlgorithmStatus.SOUND_AND_IMPRECISE;
        }
        if (pIsPrecise == BlockSummaryObserverWorker.StatusObserver.StatusPrecise.PRECISE) {
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        return Algorithm.AlgorithmStatus.UNSOUND_AND_IMPRECISE;
    }

    protected abstract BlockSummaryMessage replacePayload(BlockSummaryMessagePayload var1);

    public static BlockSummaryMessage newBlockPostCondition(String pUniqueBlockId, int pTargetNodeNumber, BlockSummaryMessagePayload pPayload, boolean pFull, boolean pReachable, Set<String> pVisited) {
        BlockSummaryMessagePayload newPayload = new BlockSummaryMessagePayload.Builder().addAllEntries((Map<String, Object>)((Object)pPayload)).addEntry("full", Boolean.toString(pFull)).addEntry("visited", Joiner.on((String)",").join(pVisited)).addEntry("reach", Boolean.toString(pReachable)).buildPayload();
        return new BlockSummaryPostConditionMessage(pUniqueBlockId, pTargetNodeNumber, newPayload, Instant.now());
    }

    public static BlockSummaryMessage newErrorConditionMessage(String pUniqueBlockId, int pTargetNodeNumber, BlockSummaryMessagePayload pPayload, boolean pFirst, Set<String> pVisited) {
        BlockSummaryMessagePayload newPayload = new BlockSummaryMessagePayload.Builder().addAllEntries((Map<String, Object>)((Object)pPayload)).addEntry("first", Boolean.toString(pFirst)).addEntry("visited", pVisited).buildPayload();
        return new BlockSummaryErrorConditionMessage(pUniqueBlockId, pTargetNodeNumber, newPayload, Instant.now());
    }

    public static BlockSummaryMessage newErrorConditionUnreachableMessage(String pUniqueBlockId, String denied) {
        return new BlockSummaryErrorConditionUnreachableMessage(pUniqueBlockId, 0, new BlockSummaryMessagePayload.Builder().addEntry("reason", denied).buildPayload(), Instant.now());
    }

    public static BlockSummaryMessage newResultMessage(String pUniqueBlockId, int pTargetNodeNumber, CPAcheckerResult.Result pResult, Set<String> pVisited) {
        BlockSummaryMessagePayload payload = new BlockSummaryMessagePayload.Builder().addEntry("result", pResult.name()).addEntry("visited", pVisited).buildPayload();
        return new BlockSummaryResultMessage(pUniqueBlockId, pTargetNodeNumber, payload, Instant.now());
    }

    public static BlockSummaryMessage newErrorMessage(String pUniqueBlockId, Throwable pException) {
        return new BlockSummaryErrorMessage(pUniqueBlockId, 0, new BlockSummaryMessagePayload.Builder().addEntry("exception", Throwables.getStackTraceAsString((Throwable)pException)).buildPayload(), Instant.now());
    }

    public String getBlockId() {
        return this.uniqueBlockId;
    }

    @Override
    public int compareTo(BlockSummaryMessage o) {
        return this.getType().compareTo(o.getType());
    }

    protected ImmutableSet<String> extractVisited() {
        if (!this.getPayload().containsKey("visited")) {
            return ImmutableSet.of();
        }
        Object visited = this.getPayload().get("visited");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (visited instanceof Iterable) {
            ((Iterable)visited).forEach(item -> builder.add((Object)((String)item)));
        }
        return builder.build();
    }

    protected boolean extractFlag(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getPayload().getOrDefault(key, defaultValue).toString());
    }

    public int getTargetNodeNumber() {
        return this.targetNodeNumber;
    }

    protected BlockSummaryMessagePayload getPayload() {
        return this.payload;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getUniqueBlockId() {
        return this.uniqueBlockId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("targetNodeNumber", this.targetNodeNumber).add("uniqueBlockId", (Object)this.uniqueBlockId).add("type", (Object)this.type).add("payload", (Object)this.payload).toString();
    }

    public boolean equals(Object pO) {
        if (!(pO instanceof BlockSummaryMessage)) {
            return false;
        }
        BlockSummaryMessage message = (BlockSummaryMessage)pO;
        return this.targetNodeNumber == message.targetNodeNumber && Objects.equals(this.uniqueBlockId, message.uniqueBlockId) && this.type == message.type && Objects.equals((Object)this.payload, (Object)message.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetNodeNumber, this.uniqueBlockId, this.type, this.payload});
    }

    private static class MessageSerializer
    extends StdSerializer<BlockSummaryMessage> {
        private static final long serialVersionUID = 1324289L;

        private MessageSerializer(Class<BlockSummaryMessage> t) {
            super(t);
        }

        public void serialize(BlockSummaryMessage pMessage, JsonGenerator pJsonGenerator, SerializerProvider pSerializerProvider) throws IOException {
            pJsonGenerator.writeStartObject();
            pJsonGenerator.writeStringField("uniqueBlockId", pMessage.getUniqueBlockId());
            pJsonGenerator.writeNumberField("targetNodeNumber", pMessage.getTargetNodeNumber());
            pJsonGenerator.writeStringField("type", pMessage.getType().name());
            pJsonGenerator.writeStringField("payload", pMessage.getPayload().toJSONString());
            pJsonGenerator.writeStringField("timestamp", pMessage.getTimestamp().toString());
            pJsonGenerator.writeEndObject();
        }
    }

    private static class MessageDeserializer
    extends StdDeserializer<BlockSummaryMessage> {
        private static final long serialVersionUID = 196344175L;

        public MessageDeserializer(Class<BlockSummaryMessage> vc) {
            super(vc);
        }

        public BlockSummaryMessage deserialize(JsonParser parser, DeserializationContext deserializer) throws IOException {
            ObjectCodec codec = parser.getCodec();
            JsonNode node = (JsonNode)codec.readTree(parser);
            String uniqueBlockId = node.get("uniqueBlockId").asText();
            int nodeNumber = node.get("targetNodeNumber").asInt();
            MessageType type = MessageType.valueOf(node.get("type").asText());
            BlockSummaryMessagePayload payload = new BlockSummaryMessagePayload.Builder().addEntriesFromJSON(node.get("payload").asText()).buildPayload();
            Instant timestamp = Instant.parse(node.get("timestamp").asText());
            switch (type) {
                case FOUND_RESULT: {
                    return new BlockSummaryResultMessage(uniqueBlockId, nodeNumber, payload, timestamp);
                }
                case ERROR: {
                    return new BlockSummaryErrorMessage(uniqueBlockId, nodeNumber, payload, timestamp);
                }
                case ERROR_CONDITION_UNREACHABLE: {
                    return new BlockSummaryErrorConditionUnreachableMessage(uniqueBlockId, nodeNumber, payload, timestamp);
                }
                case ERROR_CONDITION: {
                    return new BlockSummaryErrorConditionMessage(uniqueBlockId, nodeNumber, payload, timestamp);
                }
                case BLOCK_POSTCONDITION: {
                    return new BlockSummaryPostConditionMessage(uniqueBlockId, nodeNumber, payload, timestamp);
                }
            }
            throw new AssertionError((Object)("Unknown MessageType " + type));
        }
    }

    public static class CompressedMessageConverter
    extends MessageConverter {
        @Override
        public byte[] messageToJson(BlockSummaryMessage pMessage) throws IOException {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                byte[] byArray;
                try (GZIPOutputStream writer = new GZIPOutputStream(output);){
                    byte[] message = super.messageToJson(pMessage);
                    writer.write(message);
                    byArray = output.toByteArray();
                }
                return byArray;
            }
        }

        @Override
        public BlockSummaryMessage jsonToMessage(byte[] pBytes) throws IOException {
            try (GZIPInputStream reader = new GZIPInputStream(new ByteArrayInputStream(pBytes));){
                BlockSummaryMessage blockSummaryMessage;
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    int n;
                    byte[] buf = new byte[4096];
                    while ((n = reader.read(buf)) >= 0) {
                        output.write(buf, 0, n);
                    }
                    byte[] data = output.toByteArray();
                    blockSummaryMessage = super.jsonToMessage(data);
                }
                return blockSummaryMessage;
            }
        }
    }

    public static class MessageConverter {
        private final ObjectMapper mapper = new ObjectMapper();

        public MessageConverter() {
            SimpleModule serializer = new SimpleModule("MessageSerializer", new Version(1, 0, 0, null, null, null));
            serializer.addSerializer(BlockSummaryMessage.class, (JsonSerializer)new MessageSerializer(BlockSummaryMessage.class));
            this.mapper.registerModule((Module)serializer);
            SimpleModule deserializer = new SimpleModule("MessageDeserializer", new Version(1, 0, 0, null, null, null));
            deserializer.addDeserializer(BlockSummaryMessage.class, (JsonDeserializer)new MessageDeserializer(BlockSummaryMessage.class));
            this.mapper.registerModule((Module)deserializer);
        }

        public byte[] messageToJson(BlockSummaryMessage pMessage) throws IOException {
            return this.mapper.writeValueAsBytes((Object)pMessage);
        }

        public BlockSummaryMessage jsonToMessage(byte[] pBytes) throws IOException {
            return (BlockSummaryMessage)this.mapper.readValue(pBytes, BlockSummaryMessage.class);
        }
    }

    public static enum MessageType {
        FOUND_RESULT,
        ERROR,
        ERROR_CONDITION_UNREACHABLE,
        ERROR_CONDITION,
        BLOCK_POSTCONDITION;

    }
}

