/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.memory;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;

public class InMemoryBlockSummaryConnection
implements BlockSummaryConnection {
    private final BlockingQueue<BlockSummaryMessage> in;
    private final ConcurrentLinkedQueue<BlockingQueue<BlockSummaryMessage>> out;
    private boolean closed;

    InMemoryBlockSummaryConnection(BlockingQueue<BlockSummaryMessage> pIn, List<BlockingQueue<BlockSummaryMessage>> pOut) {
        this.in = pIn;
        this.out = new ConcurrentLinkedQueue<BlockingQueue<BlockSummaryMessage>>(pOut);
        this.closed = false;
    }

    @Override
    public BlockSummaryMessage read() throws InterruptedException {
        if (this.closed) {
            throw new IllegalStateException("Cannot read from an already closed " + InMemoryBlockSummaryConnection.class);
        }
        return this.in.take();
    }

    @Override
    public boolean hasPendingMessages() {
        return !this.in.isEmpty();
    }

    @Override
    public void write(BlockSummaryMessage message) throws InterruptedException {
        if (this.closed) {
            throw new IllegalStateException("Cannot write to an already closed " + InMemoryBlockSummaryConnection.class);
        }
        for (BlockingQueue<BlockSummaryMessage> messages : this.out) {
            messages.add(message);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.clear();
        this.out.clear();
        this.closed = true;
    }
}

