/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.memory;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnectionProvider;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.memory.InMemoryBlockSummaryConnection;

public class InMemoryBlockSummaryConnectionProvider
implements BlockSummaryConnectionProvider<InMemoryBlockSummaryConnection> {
    private final Supplier<BlockingQueue<BlockSummaryMessage>> queueFactory;

    public InMemoryBlockSummaryConnectionProvider(Supplier<BlockingQueue<BlockSummaryMessage>> pQueueFactory) {
        this.queueFactory = pQueueFactory;
    }

    @Override
    public ImmutableList<InMemoryBlockSummaryConnection> createConnections(int connections) throws IOException {
        ArrayList<BlockingQueue<BlockSummaryMessage>> outs = new ArrayList<BlockingQueue<BlockSummaryMessage>>();
        for (int i = 0; i < connections; ++i) {
            outs.add(this.queueFactory.get());
        }
        return Collections3.transformedImmutableListCopy(outs, out -> new InMemoryBlockSummaryConnection((BlockingQueue<BlockSummaryMessage>)out, (List<BlockingQueue<BlockSummaryMessage>>)outs));
    }
}

