/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.visualization;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;

@Options
public class MessageLogger {
    @Option(description="output file for visualizing message exchange")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reportFile = Path.of("block_analysis/block_analysis.json", new String[0]);
    @Option(description="output file for visualizing the block graph")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path blockCFAFile = Path.of("block_analysis/blocks.json", new String[0]);
    private final Map<String, Multimap<String, Object>> entries;
    private final BlockGraph tree;

    public MessageLogger(BlockGraph pTree, Configuration pConfiguration) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        this.entries = new HashMap<String, Multimap<String, Object>>();
        this.tree = pTree;
        pTree.getDistinctNodes().forEach(n -> this.entries.put(n.getId(), this.createInitialMap((BlockNode)n)));
    }

    private Multimap<String, Object> createInitialMap(BlockNode pNode) {
        ArrayListMultimap map = ArrayListMultimap.create();
        map.putAll((Object)"code", (Iterable)Splitter.on((String)"\n").splitToList((CharSequence)pNode.getCode()));
        map.putAll((Object)"predecessors", (Iterable)Collections3.transformedImmutableSetCopy(pNode.getPredecessors(), p -> p.getId()));
        map.putAll((Object)"successors", (Iterable)Collections3.transformedImmutableSetCopy(pNode.getSuccessors(), p -> p.getId()));
        return map;
    }

    public synchronized void logTree() throws IOException {
        HashMap treeMap = new HashMap();
        this.tree.getDistinctNodes().forEach(n -> {
            HashMap attributes = new HashMap();
            attributes.put("code", Splitter.on((String)"\n").splitToList((CharSequence)n.getCode()));
            attributes.put("predecessors", Collections3.transformedImmutableListCopy(n.getPredecessors(), p -> p.getId()));
            attributes.put("successors", Collections3.transformedImmutableListCopy(n.getSuccessors(), p -> p.getId()));
            treeMap.put(n.getId(), attributes);
        });
        JSON.writeJSONString(treeMap, (Path)this.blockCFAFile);
    }

    public synchronized void log(BlockSummaryMessage pMessage) throws IOException {
        if (this.entries.get(pMessage.getUniqueBlockId()) == null) {
            return;
        }
        HashMap<String, String> messageToJSON = new HashMap<String, String>();
        messageToJSON.put("type", pMessage.getType().name());
        messageToJSON.put("timestamp", pMessage.getTimestamp().toString());
        messageToJSON.put("from", pMessage.getUniqueBlockId());
        if (pMessage.getAbstractStateString(PredicateCPA.class).isEmpty()) {
            pMessage = BlockSummaryMessage.addEntry(pMessage, PredicateCPA.class.getName(), "true");
        }
        messageToJSON.put("payload", pMessage.getPayloadJSON());
        this.entries.get(pMessage.getUniqueBlockId()).put((Object)"messages", messageToJSON);
        HashMap converted = new HashMap();
        this.entries.forEach((k, v) -> converted.put(k, v.asMap()));
        JSON.writeJSONString(converted, (Path)this.reportFile);
    }
}

