/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import java.nio.file.Path;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;

@Options(prefix="distributedSummaries.worker")
public class BlockSummaryAnalysisOptions {
    @Option(description="whether analysis worker store circular post conditions")
    private boolean storeCircularPostConditions = false;
    @Option(description="whether error conditions are always checked for unsatisfiability")
    private boolean checkEveryErrorCondition = true;
    @Option(description="Whether loop free programs have to deny all possible error messages. Enable this option to eagerly process every possible error message that occurs after an precondition update.")
    private boolean sendEveryErrorMessage = false;
    @Option(description="Configuration for forward analysis in computation of distributed summaries")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path forwardConfiguration = Path.of("config/distributed-block-summaries/predicateAnalysis-block-forward.properties", new String[0]);
    @Option(description="Configuration for backward analysis in computation of distributed summaries")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path backwardConfiguration = Path.of("config/distributed-block-summaries/predicateAnalysis-block-backward.properties", new String[0]);
    @Option(description="Destination directory for the logfiles of all BlockSummaryWorkers. The logfiles have the same name as the ID of the worker.")
    @FileOption(value=FileOption.Type.OUTPUT_DIRECTORY)
    private Path logDirectory = Path.of("block_summary/logfiles", new String[0]);
    private final Configuration parentConfig;

    public BlockSummaryAnalysisOptions(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.parentConfig = pConfig;
    }

    public boolean shouldAlwaysStoreCircularPostConditions() {
        return this.storeCircularPostConditions;
    }

    public boolean shouldCheckEveryErrorConditionForUnsatisfiability() {
        return this.checkEveryErrorCondition;
    }

    public boolean shouldSendEveryErrorMessage() {
        return this.sendEveryErrorMessage;
    }

    public Path getBackwardConfiguration() {
        return this.backwardConfiguration;
    }

    public Path getForwardConfiguration() {
        return this.forwardConfiguration;
    }

    public Configuration getParentConfig() {
        return this.parentConfig;
    }

    public Path getLogDirectory() {
        return this.logDirectory;
    }
}

