/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BackwardBlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.ForwardBlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.BlockSummaryMessageProcessing;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.composite.DistributedCompositeCPA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.java_smt.api.SolverException;

public class BlockSummaryAnalysisWorker
extends BlockSummaryWorker {
    private final BlockNode block;
    private final BlockAnalysis forwardAnalysis;
    private final BlockAnalysis backwardAnalysis;
    private boolean shutdown;
    private final BlockSummaryConnection connection;
    private final StatTimer forwardAnalysisTime = new StatTimer("Forward Analysis");
    private final StatTimer backwardAnalysisTime = new StatTimer("Backward Analysis");

    BlockSummaryAnalysisWorker(String pId, BlockSummaryAnalysisOptions pOptions, BlockSummaryConnection pConnection, BlockNode pBlock, CFA pCFA, Specification pSpecification, ShutdownManager pShutdownManager) throws CPAException, InterruptedException, InvalidConfigurationException, IOException {
        super("analysis-worker-" + pId, pOptions);
        this.block = pBlock;
        this.connection = pConnection;
        Configuration forwardConfiguration = Configuration.builder().loadFromFile(pOptions.getForwardConfiguration()).build();
        Configuration backwardConfiguration = Configuration.builder().loadFromFile(pOptions.getBackwardConfiguration()).build();
        Specification backwardSpecification = Specification.fromFiles((Iterable<Path>)ImmutableSet.of((Object)Path.of("config/specification/MainEntry.spc", new String[0]), (Object)Path.of("config/specification/TerminatingFunctions.spc", new String[0])), pCFA, backwardConfiguration, this.getLogger(), pShutdownManager.getNotifier());
        this.forwardAnalysis = new ForwardBlockAnalysis(this.getLogger(), pBlock, pCFA, pSpecification, forwardConfiguration, pShutdownManager, pOptions);
        this.backwardAnalysis = new BackwardBlockAnalysis(this.getLogger(), pBlock, pCFA, backwardSpecification, backwardConfiguration, pShutdownManager, pOptions);
    }

    @Override
    public Collection<BlockSummaryMessage> processMessage(BlockSummaryMessage message) throws InterruptedException, CPAException, IOException, SolverException {
        switch (message.getType()) {
            case ERROR_CONDITION: {
                return this.processErrorCondition(message);
            }
            case BLOCK_POSTCONDITION: {
                return this.processBlockPostCondition(message);
            }
            case ERROR: 
            case FOUND_RESULT: {
                this.shutdown = true;
                return ImmutableSet.of();
            }
            case ERROR_CONDITION_UNREACHABLE: {
                return ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)("MessageType " + message.getType() + " does not exist"));
    }

    @Override
    public BlockSummaryConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean shutdownRequested() {
        return this.shutdown;
    }

    private Collection<BlockSummaryMessage> processBlockPostCondition(BlockSummaryMessage message) throws CPAException, InterruptedException, SolverException {
        BlockSummaryMessageProcessing processing = this.forwardAnalysis.getDistributedCPA().getProceedOperator().proceed(message);
        if (processing.end()) {
            return processing;
        }
        return this.forwardAnalysis((Collection<BlockSummaryMessage>)((Object)processing));
    }

    private Collection<BlockSummaryMessage> processErrorCondition(BlockSummaryMessage message) throws SolverException, InterruptedException, CPAException {
        DistributedCompositeCPA distributed = this.backwardAnalysis.getDistributedCPA();
        BlockSummaryMessageProcessing processing = distributed.getProceedOperator().proceed(message);
        if (processing.end()) {
            return processing;
        }
        return this.backwardAnalysis(processing);
    }

    private Collection<BlockSummaryMessage> forwardAnalysis(Collection<BlockSummaryMessage> pPostConditionMessages) throws CPAException, InterruptedException, SolverException {
        this.forwardAnalysisTime.start();
        this.forwardAnalysis.getDistributedCPA().getProceedOperator().synchronizeKnowledge(this.backwardAnalysis.getDistributedCPA());
        Collection<BlockSummaryMessage> response = this.forwardAnalysis.analyze(pPostConditionMessages);
        this.forwardAnalysisTime.stop();
        return response;
    }

    protected Collection<BlockSummaryMessage> backwardAnalysis(BlockSummaryMessageProcessing pMessageProcessing) throws CPAException, InterruptedException, SolverException {
        assert (pMessageProcessing.size() == 1) : "BackwardAnalysis can only be based on one message";
        this.backwardAnalysisTime.start();
        this.backwardAnalysis.getDistributedCPA().getProceedOperator().synchronizeKnowledge(this.forwardAnalysis.getDistributedCPA());
        Collection<BlockSummaryMessage> response = this.backwardAnalysis.analyze((Collection<BlockSummaryMessage>)((Object)pMessageProcessing));
        this.backwardAnalysisTime.stop();
        return response;
    }

    @Override
    public void run() {
        try {
            this.broadcast(this.forwardAnalysis.performInitialAnalysis());
            super.run();
        }
        catch (CPAException pE) {
            this.getLogger().logException(Level.SEVERE, (Throwable)pE, "Worker stopped working...");
            this.broadcastOrLogException((Collection<BlockSummaryMessage>)ImmutableSet.of((Object)BlockSummaryMessage.newErrorMessage(this.getBlockId(), pE)));
        }
        catch (InterruptedException pE) {
            this.getLogger().logException(Level.SEVERE, (Throwable)pE, "Thread interrupted unexpectedly.");
        }
    }

    public String getBlockId() {
        return this.block.getId();
    }

    public String toString() {
        return "Worker{block=" + this.block + ", finished=" + this.shutdownRequested() + "}";
    }

    public BlockAnalysis getForwardAnalysis() {
        return this.forwardAnalysis;
    }
}

