/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryResultMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.java_smt.api.SolverException;

public class BlockSummaryObserverWorker
extends BlockSummaryWorker {
    private final BlockSummaryConnection connection;
    private final StatusObserver statusObserver;
    private boolean shutdown = false;
    private Optional<CPAcheckerResult.Result> result;
    private Optional<String> errorMessage;

    public BlockSummaryObserverWorker(String pId, BlockSummaryConnection pConnection, BlockSummaryAnalysisOptions pOptions) {
        super(pId, pOptions);
        this.connection = pConnection;
        this.statusObserver = new StatusObserver();
        this.errorMessage = Optional.empty();
        this.result = Optional.empty();
    }

    @Override
    public Collection<BlockSummaryMessage> processMessage(BlockSummaryMessage pMessage) throws InterruptedException, IOException, SolverException, CPAException {
        switch (pMessage.getType()) {
            case FOUND_RESULT: {
                this.shutdown = true;
                this.result = Optional.of(((BlockSummaryResultMessage)pMessage).getResult());
                this.statusObserver.updateStatus(pMessage);
                break;
            }
            case ERROR_CONDITION_UNREACHABLE: 
            case ERROR_CONDITION: 
            case BLOCK_POSTCONDITION: {
                this.statusObserver.updateStatus(pMessage);
                break;
            }
            case ERROR: {
                this.errorMessage = Optional.of(((BlockSummaryErrorMessage)pMessage).getErrorMessage());
                this.shutdown = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown message type: " + pMessage.getType()));
            }
        }
        return ImmutableList.of();
    }

    public Pair<Algorithm.AlgorithmStatus, CPAcheckerResult.Result> observe() throws CPAException {
        super.run();
        if (this.errorMessage.isPresent()) {
            throw new CPAException(this.errorMessage.orElseThrow());
        }
        if (this.result.isEmpty()) {
            throw new CPAException("Analysis finished but no result is present...");
        }
        return Pair.of(this.statusObserver.finish(), this.result.orElseThrow());
    }

    @Override
    public BlockSummaryConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean shutdownRequested() {
        return this.shutdown;
    }

    public static class StatusObserver {
        private final Map<String, Algorithm.AlgorithmStatus> statusMap = new HashMap<String, Algorithm.AlgorithmStatus>();

        private StatusObserver() {
        }

        private void updateStatus(BlockSummaryMessage pMessage) {
            pMessage.getOptionalStatus().ifPresent(status -> this.statusMap.put(pMessage.getUniqueBlockId(), (Algorithm.AlgorithmStatus)status));
        }

        private Algorithm.AlgorithmStatus finish() {
            return this.statusMap.values().stream().reduce(Algorithm.AlgorithmStatus::update).orElse(Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED);
        }

        public static enum StatusPrecise {
            PRECISE,
            IMPRECISE;

        }

        public static enum StatusPropertyChecked {
            CHECKED,
            UNCHECKED;

        }

        public static enum StatusSoundness {
            SOUND,
            UNSOUND;

        }
    }
}

