/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.java_smt.api.SolverException;

public class BlockSummaryResultWorker
extends BlockSummaryWorker {
    private final Map<String, BlockNode> nodeMap = new HashMap<String, BlockNode>();
    private final Set<String> messageReceived;
    private final Map<String, Integer> expectAnswer;
    private final int numWorkers;
    private final BlockSummaryConnection connection;
    private boolean shutdown;

    BlockSummaryResultWorker(Collection<BlockNode> pNodes, BlockSummaryConnection pConnection, BlockSummaryAnalysisOptions pOptions) {
        super("result-worker", pOptions);
        this.connection = pConnection;
        pNodes.forEach(node -> this.nodeMap.put(node.getId(), (BlockNode)node));
        this.messageReceived = new LinkedHashSet<String>();
        this.expectAnswer = new ConcurrentHashMap<String, Integer>();
        this.nodeMap.keySet().forEach(nodeId -> this.expectAnswer.put((String)nodeId, 0));
        this.numWorkers = pNodes.size();
    }

    @Override
    public Collection<BlockSummaryMessage> processMessage(BlockSummaryMessage pMessage) throws InterruptedException, CPAException, IOException, SolverException {
        String senderId = pMessage.getUniqueBlockId();
        BlockSummaryMessage.MessageType type = pMessage.getType();
        if (!this.nodeMap.containsKey(senderId)) {
            return ImmutableSet.of();
        }
        this.messageReceived.add(senderId);
        switch (type) {
            case ERROR_CONDITION: {
                boolean newPostCondition = ((BlockSummaryErrorConditionMessage)pMessage).isFirst();
                if (newPostCondition) {
                    this.expectAnswer.merge(senderId, 1, Integer::sum);
                } else {
                    this.expectAnswer.merge(senderId, -1, Integer::sum);
                    this.nodeMap.get(senderId).getPredecessors().forEach(b -> this.expectAnswer.merge(b.getId(), 1, Integer::sum));
                }
                return this.response(pMessage);
            }
            case ERROR_CONDITION_UNREACHABLE: {
                this.expectAnswer.merge(senderId, -1, Integer::sum);
                return this.response(pMessage);
            }
            case FOUND_RESULT: 
            case ERROR: {
                this.shutdown = true;
                return ImmutableSet.of();
            }
            case BLOCK_POSTCONDITION: {
                return this.response(pMessage);
            }
        }
        throw new AssertionError((Object)(type + " does not exist"));
    }

    @Override
    public BlockSummaryConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean shutdownRequested() {
        return this.shutdown;
    }

    private Collection<BlockSummaryMessage> response(BlockSummaryMessage pMessage) {
        if (this.getLogger().wouldBeLogged(Level.ALL)) {
            this.getLogger().logf(Level.ALL, "Waiting for answers: %s (%d/%d)", new Object[]{Maps.filterValues(this.expectAnswer, v -> v != 0), this.messageReceived.size(), this.numWorkers});
        }
        if (this.messageReceived.size() == this.numWorkers && this.expectAnswer.values().stream().allMatch(i -> i == 0)) {
            this.shutdown = true;
            Object visited = ImmutableSet.of();
            if (pMessage.getType() == BlockSummaryMessage.MessageType.BLOCK_POSTCONDITION) {
                visited = ((BlockSummaryPostConditionMessage)pMessage).visitedBlockIds();
            } else if (pMessage.getType() == BlockSummaryMessage.MessageType.ERROR_CONDITION) {
                visited = ((BlockSummaryErrorConditionMessage)pMessage).visitedBlockIds();
            }
            return ImmutableSet.of((Object)BlockSummaryMessage.newResultMessage(pMessage.getUniqueBlockId(), 0, CPAcheckerResult.Result.TRUE, (Set<String>)visited));
        }
        return ImmutableSet.of();
    }
}

