/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.BlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.block_analysis.NoopBlockAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.BlockSummaryMessageProcessing;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryErrorConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.java_smt.api.SolverException;

public class BlockSummaryRootWorker
extends BlockSummaryWorker {
    private final BlockNode root;
    private final BlockAnalysis analysis;
    private final BlockSummaryConnection connection;
    private boolean shutdown;

    BlockSummaryRootWorker(String pId, BlockSummaryConnection pConnection, BlockSummaryAnalysisOptions pOptions, BlockNode pNode, CFA pCfa, Specification pSpecification, Configuration pConfiguration, ShutdownManager pShutdownManager) throws CPAException, InterruptedException, InvalidConfigurationException {
        super("root-worker-" + pId, pOptions);
        this.connection = pConnection;
        this.shutdown = false;
        this.root = pNode;
        if (!(this.root.isRoot() && this.root.isEmpty() && this.root.getLastNode().equals(this.root.getStartNode()))) {
            throw new AssertionError((Object)("Root node must be empty and cannot have predecessors: " + pNode));
        }
        this.analysis = new NoopBlockAnalysis(this.getLogger(), pNode, pCfa, AnalysisDirection.FORWARD, pSpecification, pConfiguration, pShutdownManager, pOptions);
    }

    @Override
    public Collection<BlockSummaryMessage> processMessage(BlockSummaryMessage pMessage) throws InterruptedException, SolverException, CPAException, IOException {
        switch (pMessage.getType()) {
            case ERROR_CONDITION: {
                if (pMessage.getTargetNodeNumber() == this.root.getLastNode().getNodeNumber() && this.root.getSuccessors().stream().anyMatch(block -> block.getId().equals(pMessage.getUniqueBlockId()))) {
                    BlockSummaryMessageProcessing processing = this.analysis.getDistributedCPA().getProceedOperator().proceedBackward((BlockSummaryErrorConditionMessage)pMessage);
                    if (processing.end()) {
                        return processing;
                    }
                    return ImmutableSet.of((Object)BlockSummaryMessage.newResultMessage(this.root.getId(), this.root.getLastNode().getNodeNumber(), CPAcheckerResult.Result.FALSE, ((BlockSummaryErrorConditionMessage)pMessage).visitedBlockIds()));
                }
                return ImmutableSet.of();
            }
            case FOUND_RESULT: 
            case ERROR: {
                this.shutdown = true;
                return ImmutableSet.of();
            }
            case BLOCK_POSTCONDITION: 
            case ERROR_CONDITION_UNREACHABLE: {
                return ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)("Unknown MessageType " + pMessage.getType()));
    }

    @Override
    public BlockSummaryConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean shutdownRequested() {
        return this.shutdown;
    }

    @Override
    public void run() {
        try {
            Collection<BlockSummaryMessage> initialMessage = this.analysis.performInitialAnalysis();
            this.analysis.getDistributedCPA().getProceedOperator().update((BlockSummaryPostConditionMessage)initialMessage.stream().findAny().orElseThrow());
            this.broadcast(initialMessage);
            super.run();
        }
        catch (InterruptedException | CPAException pE) {
            this.getLogger().logException(Level.SEVERE, (Throwable)pE, "Root worker stopped unexpectedly.");
            this.broadcastOrLogException((Collection<BlockSummaryMessage>)ImmutableSet.of((Object)BlockSummaryMessage.newErrorMessage(this.getId(), pE)));
        }
    }
}

