/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.distributed_cpa.BlockSummaryMessageProcessing;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryPostConditionMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisWorker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class BlockSummarySmartAnalysisWorker
extends BlockSummaryAnalysisWorker {
    private final BlockingQueue<BlockSummaryMessage> smartQueue = new PriorityBlockingQueue<BlockSummaryMessage>();
    private final BlockNode block;

    BlockSummarySmartAnalysisWorker(String pId, BlockSummaryAnalysisOptions pOptions, BlockSummaryConnection pConnection, BlockNode pBlock, CFA pCFA, Specification pSpecification, ShutdownManager pShutdownManager) throws CPAException, IOException, InterruptedException, InvalidConfigurationException {
        super("smart-worker-" + pId, pOptions, pConnection, pBlock, pCFA, pSpecification, pShutdownManager);
        this.block = pBlock;
    }

    @Override
    public BlockSummaryMessage nextMessage() throws InterruptedException {
        BlockSummaryConnection connection = this.getConnection();
        if (!this.smartQueue.isEmpty()) {
            return this.smartQueue.take();
        }
        if (!connection.hasPendingMessages()) {
            return connection.read();
        }
        LinkedHashSet<BlockSummaryMessage> newMessages = new LinkedHashSet<BlockSummaryMessage>();
        while (connection.hasPendingMessages()) {
            newMessages.add(connection.read());
        }
        BlockSummaryMessage postcondMessage = null;
        for (BlockSummaryMessage m : newMessages) {
            if (m.getType() == BlockSummaryMessage.MessageType.BLOCK_POSTCONDITION) {
                BlockSummaryMessageProcessing mp;
                if (m.getTargetNodeNumber() != this.block.getStartNode().getNodeNumber() || (mp = this.getForwardAnalysis().getDistributedCPA().getProceedOperator().proceedForward((BlockSummaryPostConditionMessage)m)).end()) continue;
                postcondMessage = BlockSummaryMessage.addEntry(m, "smart", "true");
                continue;
            }
            this.smartQueue.add(m);
        }
        if (postcondMessage != null) {
            this.smartQueue.add(postcondMessage);
        }
        return this.nextMessage();
    }
}

