/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.visualization.MessageLogger;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.java_smt.api.SolverException;

public class BlockSummaryVisualizationWorker
extends BlockSummaryWorker {
    private final MessageLogger messageLogger;
    private final BlockSummaryConnection connection;
    private boolean shutdown = false;

    BlockSummaryVisualizationWorker(BlockGraph pTree, BlockSummaryConnection pConnection, BlockSummaryAnalysisOptions pOptions) throws InvalidConfigurationException {
        super("visualization-worker", pOptions);
        this.connection = pConnection;
        this.messageLogger = new MessageLogger(pTree, pOptions.getParentConfig());
        try {
            this.messageLogger.logTree();
        }
        catch (IOException pE) {
            this.getLogger().logException(Level.WARNING, (Throwable)pE, "VisualizationWorker failed to log the BlockTree. The visualization might contain old data or will not work. However, the analysis continues normally.");
        }
    }

    @Override
    public Collection<BlockSummaryMessage> processMessage(BlockSummaryMessage pMessage) throws InterruptedException, IOException, SolverException, CPAException {
        this.messageLogger.log(pMessage);
        boolean stop = false;
        while (this.connection.hasPendingMessages()) {
            BlockSummaryMessage m = this.connection.read();
            this.messageLogger.log(m);
            stop |= m.getType() == BlockSummaryMessage.MessageType.ERROR || m.getType() == BlockSummaryMessage.MessageType.FOUND_RESULT;
        }
        if (stop) {
            this.shutdown = true;
        }
        return ImmutableSet.of();
    }

    @Override
    public BlockSummaryConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean shutdownRequested() {
        return this.shutdown;
    }
}

