/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.actor_messages.BlockSummaryMessage;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryActor;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.java_smt.api.SolverException;

public abstract class BlockSummaryWorker
implements BlockSummaryActor {
    private final LogManager logger;
    private final String id;

    protected BlockSummaryWorker(String pId, BlockSummaryAnalysisOptions pOptions) {
        LogManager logManager;
        this.id = pId;
        try {
            logManager = BasicLogManager.createWithHandler((Handler)new FileHandler(pOptions.getLogDirectory().toString() + "/" + this.id + ".log"));
        }
        catch (IOException pE) {
            logManager = LogManager.createNullLogManager();
        }
        this.logger = logManager;
    }

    @Override
    public void broadcast(Collection<BlockSummaryMessage> pMessage) throws InterruptedException {
        pMessage.forEach(m -> this.logger.log(Level.INFO, new Object[]{m}));
        for (BlockSummaryMessage message : pMessage) {
            this.getConnection().write(message);
        }
    }

    protected void broadcastOrLogException(Collection<BlockSummaryMessage> pMessage) {
        try {
            this.broadcast(pMessage);
        }
        catch (InterruptedException pE) {
            this.logger.logfException(Level.SEVERE, (Throwable)pE, "Broadcasting %s messages interrupted unexpectedly.", new Object[]{pMessage});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BlockSummaryConnection connection = this.getConnection();
        try (BlockSummaryConnection blockSummaryConnection = connection;){
            while (!this.shutdownRequested()) {
                this.broadcast(this.processMessage(this.nextMessage()));
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        catch (IOException | InterruptedException | CPAException | SolverException pE) {
            try {
                this.logger.logfException(Level.SEVERE, pE, "%s faced a problem while processing messages.", new Object[]{this.getId()});
                this.broadcastOrLogException((Collection<BlockSummaryMessage>)ImmutableList.of((Object)BlockSummaryMessage.newErrorMessage(this.getId(), pE)));
            }
            catch (Throwable throwable) {
                this.logger.logf(Level.INFO, "Worker %s finished and shuts down.", new Object[]{this.id});
                throw throwable;
            }
            this.logger.logf(Level.INFO, "Worker %s finished and shuts down.", new Object[]{this.id});
        }
        this.logger.logf(Level.INFO, "Worker %s finished and shuts down.", new Object[]{this.id});
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public LogManager getLogger() {
        return this.logger;
    }
}

