/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockGraph;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.exchange.BlockSummaryConnectionProvider;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisOptions;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryAnalysisWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryResultWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryRootWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummarySmartAnalysisWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryVisualizationWorker;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.worker.BlockSummaryWorker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class BlockSummaryWorkerBuilder {
    private final CFA cfa;
    private final Configuration configuration;
    private final ShutdownManager shutdownManager;
    private final Specification specification;
    private final List<WorkerGenerator> workerGenerators;
    private final BlockSummaryConnectionProvider<?> connectionProvider;
    private int additionalConnections;

    public BlockSummaryWorkerBuilder(CFA pCFA, BlockSummaryConnectionProvider<?> pConnectionProvider, Specification pSpecification, Configuration pConfiguration, ShutdownManager pShutdownManager) {
        this.cfa = pCFA;
        this.configuration = pConfiguration;
        this.shutdownManager = pShutdownManager;
        this.specification = pSpecification;
        this.connectionProvider = pConnectionProvider;
        this.workerGenerators = new ArrayList<WorkerGenerator>();
    }

    private String nextId(String pAdditionalIdentifier) {
        return "W" + this.workerGenerators.size() + pAdditionalIdentifier;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder createAdditionalConnections(int numberConnections) {
        this.additionalConnections = numberConnections;
        return this;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder addAnalysisWorker(BlockNode pNode, BlockSummaryAnalysisOptions pOptions) {
        this.workerGenerators.add(connection -> new BlockSummaryAnalysisWorker(this.nextId(pNode.getId()), pOptions, connection, pNode, this.cfa, this.specification, this.shutdownManager));
        return this;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder addSmartAnalysisWorker(BlockNode pNode, BlockSummaryAnalysisOptions pOptions) {
        this.workerGenerators.add(connection -> new BlockSummarySmartAnalysisWorker(this.nextId(pNode.getId()), pOptions, connection, pNode, this.cfa, this.specification, this.shutdownManager));
        return this;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder addResultCollectorWorker(Collection<BlockNode> nodes, BlockSummaryAnalysisOptions pOptions) {
        this.workerGenerators.add(connection -> new BlockSummaryResultWorker(nodes, connection, pOptions));
        return this;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder addVisualizationWorker(BlockGraph pBlockTree, BlockSummaryAnalysisOptions pOptions) {
        this.workerGenerators.add(connection -> new BlockSummaryVisualizationWorker(pBlockTree, connection, pOptions));
        return this;
    }

    @CanIgnoreReturnValue
    public BlockSummaryWorkerBuilder addRootWorker(BlockNode pNode, BlockSummaryAnalysisOptions pOptions) {
        this.workerGenerators.add(connection -> new BlockSummaryRootWorker(this.nextId(pNode.getId()), connection, pOptions, pNode, this.cfa, this.specification, this.configuration, this.shutdownManager));
        return this;
    }

    public Components build() throws IOException, CPAException, InterruptedException, InvalidConfigurationException {
        ImmutableList<?> connections = this.connectionProvider.createConnections(this.workerGenerators.size() + this.additionalConnections);
        ArrayList<BlockSummaryWorker> worker = new ArrayList<BlockSummaryWorker>(this.workerGenerators.size());
        for (int i = 0; i < this.workerGenerators.size(); ++i) {
            worker.add(this.workerGenerators.get(i).apply((BlockSummaryConnection)connections.get(i)));
        }
        List excessConnections = connections.subList(this.workerGenerators.size(), this.workerGenerators.size() + this.additionalConnections);
        return new Components(worker, excessConnections);
    }

    @FunctionalInterface
    private static interface WorkerGenerator {
        public BlockSummaryWorker apply(BlockSummaryConnection var1) throws CPAException, InterruptedException, InvalidConfigurationException, IOException;
    }

    public static class Components {
        private final List<BlockSummaryWorker> workers;
        private final List<? extends BlockSummaryConnection> additionalConnections;

        private Components(List<BlockSummaryWorker> pWorkers, List<? extends BlockSummaryConnection> pAdditionalConnections) {
            this.workers = pWorkers;
            this.additionalConnections = pAdditionalConnections;
        }

        public List<BlockSummaryWorker> getWorkers() {
            return this.workers;
        }

        public List<? extends BlockSummaryConnection> getAdditionalConnections() {
            return this.additionalConnections;
        }
    }
}

