/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.explainer.Alignment;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceCalculationHelper;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceMetric;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class AbstractDistanceMetric
implements DistanceMetric {
    private final DistanceCalculationHelper distanceHelper;

    public AbstractDistanceMetric(DistanceCalculationHelper pDistanceCalculationHelper) {
        this.distanceHelper = pDistanceCalculationHelper;
    }

    @Override
    public List<CFAEdge> startDistanceMetric(List<ARGPath> safePaths, ARGPath counterexample) {
        Preconditions.checkNotNull((Object)this.distanceHelper);
        List<CFAEdge> ce = this.distanceHelper.cleanPath(counterexample);
        ArrayList<List<CFAEdge>> paths = new ArrayList<List<CFAEdge>>();
        for (ARGPath p : safePaths) {
            paths.add(this.distanceHelper.cleanPath(p));
        }
        return this.comparePaths(ce, (List<List<CFAEdge>>)paths, (List<ARGState>)counterexample.asStatesList(), safePaths);
    }

    private List<CFAEdge> comparePaths(List<CFAEdge> counterexample, List<List<CFAEdge>> safePaths, List<ARGState> ceStates, List<ARGPath> pathsStates) {
        if (safePaths.isEmpty()) {
            return null;
        }
        assert (!safePaths.isEmpty());
        ArrayList<Integer> distances = new ArrayList<Integer>();
        int predicateWeight = 1;
        int unalignedStatesWeight = 2;
        for (int i = 0; i < safePaths.size(); ++i) {
            Alignment<CFAEdge> alignments = this.createAlignments(counterexample, safePaths.get(i));
            int predicateDistance = this.calculatePredicateDistance(alignments, ceStates, (List<ARGState>)pathsStates.get(i).asStatesList());
            List<CFAEdge> betterChoice = safePaths.get(i).size() > counterexample.size() ? safePaths.get(i) : counterexample;
            int unalignedStates = this.getNumberOfUnalignedStates(alignments.getCounterexample(), betterChoice);
            int d = predicateWeight * predicateDistance + unalignedStatesWeight * unalignedStates;
            distances.add(d);
        }
        ArrayList<Integer> finalDistances = new ArrayList<Integer>();
        for (int i = 0; i < distances.size(); ++i) {
            int distance = (Integer)distances.get(i);
            if (distance == 0) {
                safePaths.remove(i);
                continue;
            }
            finalDistances.add(distance);
        }
        distances = finalDistances;
        if (distances.isEmpty()) {
            return null;
        }
        int minimumDistance = (Integer)Collections.min(distances);
        int index = distances.indexOf(minimumDistance);
        return safePaths.get(index);
    }

    private int getNumberOfUnalignedStates(List<CFAEdge> alignedEdges, List<CFAEdge> safePath) {
        return Math.abs(alignedEdges.size() - safePath.size());
    }

    private int calculatePredicateDistance(Alignment<CFAEdge> alignments, List<ARGState> ceStates, List<ARGState> pathsStates) {
        int distance = 0;
        Alignment<ARGState> stateAlignments = new Alignment<ARGState>();
        for (int i = 0; i < alignments.getCounterexample().size(); ++i) {
            CFANode equivalentCFANode;
            CFANode safePathCFANode = alignments.getSafePathElement(i).getPredecessor();
            CFANode ceCFANode = alignments.getCounterexampleElement(i).getPredecessor();
            ARGState argCeState = null;
            ARGState argSpState = null;
            for (ARGState ceState : ceStates) {
                equivalentCFANode = AbstractStates.extractStateByType(ceState, AbstractStateWithLocation.class).getLocationNode();
                if (!ceCFANode.equals(equivalentCFANode)) continue;
                argCeState = ceState;
                break;
            }
            for (ARGState pathState : pathsStates) {
                equivalentCFANode = AbstractStates.extractStateByType(pathState, AbstractStateWithLocation.class).getLocationNode();
                if (!safePathCFANode.equals(equivalentCFANode)) continue;
                argSpState = pathState;
                break;
            }
            stateAlignments.addPair(argCeState, argSpState);
        }
        for (Pair cePathStatePair : stateAlignments) {
            ARGState counterexampleState = (ARGState)cePathStatePair.getFirst();
            ARGState safePathState = (ARGState)cePathStatePair.getSecond();
            Set<BooleanFormula> predicatesCE = this.distanceHelper.splitPredicates(AbstractStates.extractStateByType(counterexampleState, PredicateAbstractState.class).getAbstractionFormula().asFormula());
            Set<BooleanFormula> predicatesSafePath = this.distanceHelper.splitPredicates(AbstractStates.extractStateByType(safePathState, PredicateAbstractState.class).getAbstractionFormula().asFormula());
            for (BooleanFormula predicate : predicatesCE) {
                if (predicatesSafePath.contains(predicate)) continue;
                ++distance;
            }
            for (BooleanFormula predicate : predicatesSafePath) {
                if (predicatesCE.contains(predicate)) continue;
                ++distance;
            }
        }
        return distance;
    }

    private Alignment<CFAEdge> createAlignments(List<CFAEdge> ce, List<CFAEdge> safePath) {
        Alignment<CFAEdge> alignment = new Alignment<CFAEdge>();
        HashSet<CFAEdge> alreadyAligned = new HashSet<CFAEdge>();
        block0: for (CFAEdge ceEdge : ce) {
            for (CFAEdge spEdge : safePath) {
                if (ceEdge.getPredecessor().getNodeNumber() != spEdge.getPredecessor().getNodeNumber() || ceEdge.getSuccessor().getNodeNumber() == spEdge.getSuccessor().getNodeNumber() || alreadyAligned.contains(spEdge)) continue;
                alignment.addPair(ceEdge, spEdge);
                alreadyAligned.add(spEdge);
                continue block0;
            }
        }
        return alignment;
    }
}

