/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.explainer.Alignment;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceCalculationHelper;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceMetric;
import org.sosy_lab.cpachecker.core.algorithm.explainer.Event;
import org.sosy_lab.cpachecker.core.algorithm.explainer.ExplainTool;
import org.sosy_lab.cpachecker.core.algorithm.explainer.PathDistanceList;
import org.sosy_lab.cpachecker.core.algorithm.explainer.PathDistancePair;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ControlFlowDistanceMetric
implements DistanceMetric {
    private final DistanceCalculationHelper distanceHelper;

    public ControlFlowDistanceMetric(DistanceCalculationHelper pDistanceCalculationHelper) {
        this.distanceHelper = pDistanceCalculationHelper;
    }

    @Override
    public List<CFAEdge> startDistanceMetric(List<ARGPath> safePaths, ARGPath counterexample) {
        List<CFAEdge> ce = this.distanceHelper.cleanPath(counterexample);
        List<CFAEdge> counterexampleBranches = this.findBranches(ce);
        return this.comparePaths(counterexampleBranches, this.distanceHelper.convertPathsToEdges(safePaths));
    }

    void generateClosestSuccessfulExecution(ARGPath counterexample, CounterexampleInfo ceInfo) {
        List<CFAEdge> finalGeneratedPath;
        List<CFAEdge> ce = this.distanceHelper.cleanPath(counterexample);
        List<CFAEdge> branchesCe = this.findBranches(ce);
        List<List<CFAEdge>> successfulGeneratedPath = this.pathGenerator(branchesCe, (List<ARGState>)counterexample.asStatesList());
        if (successfulGeneratedPath == null) {
            return;
        }
        ArrayList<List<CFAEdge>> replace = new ArrayList<List<CFAEdge>>();
        for (List<CFAEdge> pCFAEdges : successfulGeneratedPath) {
            replace.add(this.distanceHelper.cleanPath(pCFAEdges));
        }
        successfulGeneratedPath = replace;
        successfulGeneratedPath.removeIf(c -> c.isEmpty());
        if (successfulGeneratedPath.stream().allMatch(c -> c.isEmpty())) {
            return;
        }
        int locationOfLastChangedNode = 0;
        List<CFAEdge> firstGeneratedPath = successfulGeneratedPath.get(0);
        CFANode firstNodeOfSafePath = firstGeneratedPath.get(0).getPredecessor();
        int spRootNodeNumber = firstNodeOfSafePath.getEnteringEdge(0).getPredecessor().getNodeNumber();
        for (int i = 0; i < ce.size(); ++i) {
            if (ce.get(i).getPredecessor().getNodeNumber() != spRootNodeNumber) continue;
            locationOfLastChangedNode = i;
            break;
        }
        ArrayList<CFAEdge> finalCE = new ArrayList<CFAEdge>();
        for (int i = locationOfLastChangedNode; i < ce.size(); ++i) {
            finalCE.add(ce.get(i));
        }
        if (successfulGeneratedPath.size() == 1) {
            finalGeneratedPath = successfulGeneratedPath.get(0);
        } else if (successfulGeneratedPath.size() > 1) {
            finalGeneratedPath = this.comparePaths(branchesCe, successfulGeneratedPath);
            if (finalGeneratedPath == null) {
                finalGeneratedPath = successfulGeneratedPath.get(0);
            }
        } else {
            return;
        }
        new ExplainTool().explainDeltas(finalCE, finalGeneratedPath, ceInfo);
    }

    /*
     * WARNING - void declaration
     */
    private List<CFAEdge> comparePaths(List<CFAEdge> ce, List<List<CFAEdge>> safePaths) {
        void var5_7;
        ArrayList<List<CFAEdge>> safePathBranchesList = new ArrayList<List<CFAEdge>>();
        if (safePaths.isEmpty()) {
            return null;
        }
        for (List<CFAEdge> list : safePaths) {
            safePathBranchesList.add(this.findBranches(this.distanceHelper.cleanPath(list)));
        }
        ArrayList<Event> ceEvents = new ArrayList<Event>();
        boolean bl = false;
        while (var5_7 < ce.size()) {
            ceEvents.add(new Event(ce.get((int)var5_7), ce));
            ++var5_7;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < safePathBranchesList.size(); ++i) {
            ArrayList events = new ArrayList();
            for (int j = 0; j < ((List)safePathBranchesList.get(i)).size(); ++j) {
                events.add(new Event((CFAEdge)((List)safePathBranchesList.get(i)).get(j), safePaths.get(i)));
            }
            arrayList.add(events);
        }
        ArrayList distances = new ArrayList();
        for (List list : arrayList) {
            distances.add(this.calculateDistance(ceEvents, list));
        }
        PathDistanceList<CFAEdge, Event> safePathsDistancesPair = new PathDistanceList<CFAEdge, Event>(safePaths, distances);
        if (safePathsDistancesPair.isEmpty()) {
            return null;
        }
        return this.findClosestSuccessfulRun(safePathsDistancesPair);
    }

    private List<CFAEdge> findClosestSuccessfulRun(PathDistanceList<CFAEdge, Event> pDistancePairs) {
        PathDistancePair<CFAEdge, Event> closest = Collections.min(pDistancePairs, new Comparator<PathDistancePair<CFAEdge, Event>>(){

            @Override
            public int compare(PathDistancePair<CFAEdge, Event> a, PathDistancePair<CFAEdge, Event> b) {
                int aSum = a.getDistances().stream().map(e -> e.getDistanceFromTheEnd()).reduce(0, Integer::sum);
                int bSum = b.getDistances().stream().map(e -> e.getDistanceFromTheEnd()).reduce(0, Integer::sum);
                return Integer.compare(aSum, bSum);
            }
        });
        return closest.getPath();
    }

    private List<Event> calculateDistance(List<Event> pCEvents, List<Event> pSafeEvents) {
        Alignment<Event> alignments = this.createAlignments(pCEvents, pSafeEvents);
        ArrayList<Event> deltas = new ArrayList<Event>();
        for (int i = 0; i < alignments.getCounterexample().size(); ++i) {
            if (alignments.getCounterexampleElement(i).getLine() != alignments.getSafePathElement(i).getLine() || alignments.getCounterexampleElement(i).getStatement().equals(alignments.getSafePathElement(i).getStatement())) continue;
            deltas.add(alignments.getCounterexampleElement(i));
            break;
        }
        return deltas;
    }

    private Alignment<Event> createAlignments(List<Event> pCEvents, List<Event> pSafeEvents) {
        HashSet<Event> alreadyAligned = new HashSet<Event>();
        Alignment<Event> alignments = new Alignment<Event>();
        block0: for (Event pCEvent : pCEvents) {
            for (Event pSafeEvent : pSafeEvents) {
                if (pCEvent.getNode().getNodeNumber() != pSafeEvent.getNode().getNodeNumber() || alreadyAligned.contains(pSafeEvent)) continue;
                alignments.addPair(pCEvent, pSafeEvent);
                alreadyAligned.add(pSafeEvent);
                continue block0;
            }
        }
        return alignments;
    }

    private List<CFAEdge> findBranches(List<CFAEdge> pCe) {
        ArrayList<CFAEdge> branches = new ArrayList<CFAEdge>();
        for (CFAEdge ceEdge : pCe) {
            if (!ceEdge.getEdgeType().equals((Object)CFAEdgeType.AssumeEdge)) continue;
            branches.add(ceEdge);
        }
        return branches;
    }

    private List<List<CFAEdge>> pathGenerator(List<CFAEdge> pBranchesCE, List<ARGState> pARGStates) {
        if (pBranchesCE.isEmpty()) {
            return null;
        }
        CFAEdge lastBranch = pBranchesCE.get(pBranchesCE.size() - 1);
        block0: for (CFAEdge pCFAEdge : pBranchesCE) {
            if (pCFAEdge.getPredecessor().getNumLeavingEdges() == 0) continue;
            if (pCFAEdge.getPredecessor().getNumLeavingEdges() == 2) {
                if (pCFAEdge.getPredecessor().getLeavingEdge(0).equals(pCFAEdge)) {
                    lastBranch = pCFAEdge.getPredecessor().getLeavingEdge(1);
                    continue;
                }
                lastBranch = pCFAEdge.getPredecessor().getLeavingEdge(0);
                continue;
            }
            for (int i = 0; i < pCFAEdge.getPredecessor().getNumLeavingEdges(); ++i) {
                if (pCFAEdge.getPredecessor().getLeavingEdge(i).equals(pCFAEdge)) continue;
                lastBranch = pCFAEdge.getPredecessor().getLeavingEdge(i);
                break block0;
            }
        }
        ARGState lastBranchAsState = this.findEquivalentState(lastBranch, pARGStates);
        return this.buildNewPath(lastBranch, lastBranchAsState);
    }

    private ARGState findEquivalentState(CFAEdge pCFAEdge, List<ARGState> states) {
        ARGState finalState = null;
        for (ARGState state : states) {
            if (!pCFAEdge.getPredecessor().equals(AbstractStates.extractStateByType(state, AbstractStateWithLocation.class).getLocationNode())) continue;
            finalState = state;
            break;
        }
        if (finalState == null) {
            return null;
        }
        ArrayList<ARGState> finalStatesChildren = new ArrayList<ARGState>(finalState.getChildren());
        for (int i = 0; i < finalState.getChildren().size(); ++i) {
            if (states.contains(finalStatesChildren.get(i))) continue;
            return (ARGState)finalStatesChildren.get(i);
        }
        return null;
    }

    private List<List<CFAEdge>> buildNewPath(CFAEdge lastBranch, ARGState lastBranchAsState) {
        assert (lastBranch.getEdgeType().equals((Object)CFAEdgeType.AssumeEdge));
        List<ARGPath> paths = this.distanceHelper.generateAllSuccessfulExecutions(null, lastBranchAsState, false);
        ArrayList<List<CFAEdge>> filteredPaths = new ArrayList<List<CFAEdge>>();
        for (ARGPath path : paths) {
            if (path.getLastState().isTarget()) continue;
            filteredPaths.add(path.getFullPath());
        }
        return filteredPaths;
    }
}

